/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#ifndef USE_EVERYTHING_H_
#define USE_EVERYTHING_H_

#include "../eam_types.h"

/* This fucntion does nothing directly useful, but calling it in the
   main compilation unit assures every object file in libepsilon is linked
   into the executable, so that C modules opened at runtime have always all
   they need, even if some functionality is not used in the main compilation
   unit.
   
   It is very important to update use_everything.c for each module which is
   added to libepsilon.
 */
void use_everything();
integer_t unused_constant; /* use_everything() updates this. */

#endif /* #ifndef USE_EVERYTHING_H_ */
