/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#ifndef STRING_H_
#define STRING_H_

#include "../eam_types.h"

/* Return a malloc()'d string with the same content as the given
   eAM string: */
char* epsilon_string_to_c_string(word_t s);

/* Return an allocate_inexact()'d string with the same content as the
   given C string: */
word_t c_string_to_epsilon_string(char* s);

#endif /* #ifndef STRING_H_ */
