/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#include "../eam_types.h"
#include "string.h"
#include <stdio.h>
#include <string.h>
#include "../../common/malloc.h"
#include "../gc/gc.h"

/* Return a malloc()'d string with the same content as the given
   eAM string: */
char* epsilon_string_to_c_string(word_t s){
  /* Create a buffer with the right size: */
  integer_t characters_no = ((integer_t*)s)[0];
  char* r = xmalloc(characters_no + 1); /* characters + '\0' */
  integer_t i;
  
  /* Fill the C string: */
  for(i = 0; i < characters_no; i++)
    r[i] = (char)(((integer_t*)s)[i + 1]);
  r[i] = '\0';

  /* Return the C string: */
  return r;
}

/* Return an allocate_inexact()'d string with the same content as the
   given C string: */
word_t c_string_to_epsilon_string(char* s){
  /* Create a buffer with the right size: */
  integer_t characters_no = (integer_t) (strlen(s));
  word_t* r = allocate_inexact(1 + characters_no); /* size + characters */
  integer_t i;
  
  /* Fill the epsilon string: */
  r[0] = (word_t)characters_no;
  for(i = 0; i < characters_no; i++)
    r[i + 1] = (word_t)((integer_t)(s[i]));

  /* Return the built string, cast to a word_t: */
  return (word_t)r;
}

/* Used in use_everything.c */
integer_t string_constant = 10;
