/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#ifndef LIST_H_
#define LIST_H_

#include "../eam_types.h"

/* Return the number of elements of the given list: */
integer_t length_of_list(word_t list);

/* Convert the given C array with the given size into an epsilon list,
   allocated with allocate_exact(): */
word_t c_array_to_list(word_t array, integer_t size);

/* Convert the given C array with the given size into an epsilon array,
   allocated with allocate_inexact(): */
word_t c_array_to_epsilon_array(word_t array, integer_t size);

/* Convert the given epsilon array into a list, allocated with
   allocate_exact(): */
word_t epsilon_array_to_list(word_t array);

/* Convert the given list into an epsilon array, allocated with
   allocate_inexact(): */
word_t list_to_epsilon_array(word_t list);

#endif /* #ifndef LIST_H_ */
