/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* A "dynamic library" is not meant to be directly referred from epsilon; it's
   thought as a useful way of extending a "C library", which instead is directly
   referred from epsilon sources (c_object, c_function, etc.). 
   I will maybe find a better name. */


#ifndef DYNAMIC_LIBRARIES_H
#define DYNAMIC_LIBRARIES_H

/* Functions in this compilation unit are *NOT* thread-safe, and calls to
   them should be explicitly synchronized with a mutex in a multi-threaded
   environment. */

/* An handle for a dynamic library: */
typedef void* dynamic_library_handle_t;

/* The value of a symbol from a dynamic library. This must usually be cast to
   a pointer-to-function type, or however to a pointer to an object of the
   appropriate type for what the symbol stands for. */
typedef void* symbol_value_t;

/* Initialize the data structures for the dynamic-libraries subsystem.
   This is called exactly *once* in evm.c or in the generated C file. */
void
initialize_dynamic_libraries();

/* Open a dynamic library, or exit with a fatal message on failure: */
dynamic_library_handle_t
open_dynamic_library(const char* library_name);

/* Load the definition for a symbol from the given handle. Exit with a 
   fatal error on failure. */
symbol_value_t
load_symbol_from_handle(dynamic_library_handle_t handle,
			const char* symbol_name);

/* Load the definition for a symbol from the given handle. Exit with a
   fatal error on failure. */
symbol_value_t
load_symbol_from_dynamic_library(const char* library_name,
				 const char* symbol_name);

/* Try loading the symbol from each opened library, starting from the one
   which was opened more recently.
   Exit with a fatal error if the symbol is not found in any library. */
symbol_value_t
load_symbol(const char* symbol_name);

/* Close all opened dynamic libraries and destroy the data structures for
   the dynamic-libraries subsystem: */
void
close_dynamic_libraries();

#endif /* #ifndef DYNAMIC_LIBRARIES_H */
