/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Please pay attention to the difference between "C libraries" and "dynamic
   libraries".
   A "dynamic library" is not meant to be directly referred from epsilon; it's
   thought as a useful way of extending a "C library", which instead is directly
   referred from epsilon sources (c_object, c_function, etc.).
   I will maybe find a better name. */

/* Dynamic libraries must be initialized *before* using C libraries, since dynamic
   libraries are internally used for implementing C libraries. */

#ifndef C_LIBRARIES_H
#define C_LIBRARIES_H

#include "../eam_types.h"

/* An handle for a C library: */
typedef void* c_library_handle_t;

/* The value of a symbol from a C library. This is used in epsilon code, and
   often needs to be cast to a function type. */
typedef word_t c_value_t;

/* All of these exit with a fatal error on failure. */
c_library_handle_t open_c_library(char* library_name);
c_value_t load_c_symbol(c_library_handle_t handle, char* symbol_name);

#endif /* #ifndef C_LIBRARIES_H */
