/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#ifndef SET_H_
#define SET_H_

#include "../eam_types.h"

/* A data structure implementing a set of non-NULL word_t's */

typedef struct set* set_t;

set_t create_set(integer_t size);
void destroy_set(set_t set);

void insert_pointer_into_set(word_t pointer, set_t set);

/* Return 0 if the element was present, -1 otherwise: */
integer_t remove_pointer_from_set(word_t pointer, set_t set);

integer_t does_pointer_belong_to_set(word_t pointer, set_t set);

/* Only useful for debugging (complexity is O(m)) */
void dump_set(set_t s);

#endif /* #ifndef SET_H_ */
