/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include "output_c.h"
#include "../commontext.h"
#include "../common/command_line.h"

void output_scheme (FILE * output_stream);

int
main (int argc, char **argv)
{
  int strlen_of_argv_1;
  FILE *f;

  set_program_name ("eamx2scheme (" PACKAGE_NAME ")");
  set_general_help_message
    ("Translates the eAM executable FILE.eamx into the Scheme source file FILE.scm.");
  set_synopsis_string ("eamx2scheme [OPTIONS] FILE.eamx");
  set_version_string (VERSION_STRING);
  set_copyright_string (COPYRIGHT_STRING);
  set_license_message (LICENSE_STRING);
  set_bug_reporting_message (BUG_REPORTING_MESSAGE);

  parse_command_line (&argc, argv);

  /* Load bytecode: */
  if (argc != 2)
    show_help ();

  /* Test for correctness of filename: */
  strlen_of_argv_1 = strlen (argv[1]);
  if (strlen_of_argv_1 < 6)
    {
      fprintf (stderr,
	       "The filename XXXXXX.eamx must be at least 6 characters long\n",
	       argv[1]);
      exit (EXIT_FAILURE);
    }
  if (strcmp (".eamx", argv[1] + strlen_of_argv_1 - 5))
    {
      fprintf (stderr, "The filename extension must be .eamx\n", argv[1]);
      exit (EXIT_FAILURE);
    }

  /* Actually load the file: */
  load_file (argv[1]);

  /* Output Scheme code: */
  argv[1][strlen_of_argv_1 - 4] = 's';
  argv[1][strlen_of_argv_1 - 3] = 'c';
  argv[1][strlen_of_argv_1 - 2] = 'm';
  argv[1][strlen_of_argv_1 - 1] = '\0';
  f = fopen (argv[1], "w");
  if (f == NULL)
    {
      fprintf (stderr, "Could not open %s for writing\n", argv[1]);
      exit (EXIT_FAILURE);
    }
  output_scheme (f);
  fclose (f);

  /* Exit: */
  return EXIT_SUCCESS;
}
