/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include "eam.h"
  //#include "runtime.h"

#include "instructions.h"
#include "bytecode.h"


/* Declared in eam.h: */
struct epsilon_executable *executable;

void
load_file (const char *filename)
{
  /* Load the given epsilon executable: */
  executable = read_epsilon_executable_file (filename);

  /* Fail if we could not load the executable: */
  if (executable == NULL)
    {
      /* No need to issue an error message, read_epsilon_executable_file() has already
         been shown. */
      exit (EXIT_FAILURE);
    }
}
