/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <limits.h>
#include "eam_types.h"
#include "../commontext.h"
#include "../common/command_line.h"
#include "../common/malloc.h"
#include "prefixes.h"

#define SHOW_SIZE_OF_TYPE(type) \
  printf("  Objects of type " #type " are %i bits wide.\n", sizeof(type) * CHAR_BIT)

void show_types(){
  printf("  A C char is %i bits wide.\n", CHAR_BIT);
  SHOW_SIZE_OF_TYPE(word_t);
  SHOW_SIZE_OF_TYPE(integer_t);
  SHOW_SIZE_OF_TYPE(wide_integer_t);
  SHOW_SIZE_OF_TYPE(float_t);
  SHOW_SIZE_OF_TYPE(wide_float_t);
  SHOW_SIZE_OF_TYPE(wide_wide_float_t);
}

void show_paths(){
  printf("  GNU epsilon libraries are installed in %s\n",
	 EPSILON_LIBRARIES_PATH);
  printf("  GNU epsilon interfaces are installed in %s\n",
	 EPSILON_INTERFACES_PATH);
  printf("  GNU epsilon C libraries are installed in %s\n",
	 EPSILON_C_LIBRARIES_PATH);
}

void show_threading(){
#ifdef __GNUC__
  #define THREADING "GCC \'labels as values\' extension"
#else
  #define THREADING "not supported by the C compiler"
#endif /* #ifdef __GNUC__ */
  printf("  Threading: %s\n", THREADING);
}

void show_line(){
  /* printf("---------------------------------\n"); */
}

void show_everything(){
  show_line();

  printf("Information about eAM types:\n");
  show_types();
  show_line();

  printf("Information about paths:\n");
  show_paths();
  show_line();

  printf("Information about threading:\n");
  show_threading();
  show_line();
}

int main(int argc, char** argv){
  /* Define command line behavior: */
  set_program_name ("eam-config (" PACKAGE_NAME ")");
  set_general_help_message("Show the configuration of the epsilon Abstract Machine");
  set_synopsis_string ("eam-config [OPTIONS]");
  set_version_string (VERSION_STRING);
  set_copyright_string (COPYRIGHT_STRING);
  set_license_message (LICENSE_STRING);
  set_bug_reporting_message (BUG_REPORTING_MESSAGE);

  add_toggle_option ("types", 't', 0,
                     "Show only types information");
  add_toggle_option ("paths", 'p', 0,
                     "Show only paths information");
  add_toggle_option ("threading", 'T', 0,
                     "Show only threading information");

  
  /* Parse command-line and check its correctness: */
  parse_command_line(&argc, argv);

  if(argc != 1)
    command_line_fatal("There must be no command-line arguments");
  
  if(long_option_to_value("types"))
    show_types();
  else if(long_option_to_value("paths"))
    show_paths();
  else if(long_option_to_value("threading"))
    show_threading();
  else /* default: no command-line options */
    show_everything();
  
  return EXIT_SUCCESS;
} /* main */
