/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#ifndef _TERM_H_
#define _TERM_H_

#include <stdio.h>

typedef int constructor_t;

typedef int variable_t;

typedef int term_t;
extern term_t error;

void init_terms ();
void free_terms ();

constructor_t constructor (char *name, int ariety);
variable_t variable (char *name);
term_t term (constructor_t c, ...);
term_t vterm (variable_t v);

constructor_t term_to_constructor (term_t t);	/* t must _not_ be a variable */

term_t subterm (term_t t, int n);

int is_error (term_t t);

int are_terms_equal (term_t m, term_t n);
int are_terms_equal_excluding_variables (term_t m, term_t n);	// Not implemented yet

int is_term_more_general_than_or_equal_to (term_t m, term_t n);

void output_term (FILE * f, term_t t);

term_t normalize_term (term_t t);
term_t freshen_term (term_t t);

/* When unifying a variable in t1 with a variable in t2 it's the one
   in t2 to be returned in the unified term. */
term_t unify (term_t t1, term_t t2);

/* When unifying a variable in t1 with a variable in t2 it's the one
   in t2 to win. The hidden terms table is modified in the entry for
   t1: this is a rough emulation of a parameter passed 'by reference';
   t2 instead is passed 'by constant'. */
void make_term_unify_with_term (term_t t1, term_t t2);

int is_constructed_with (term_t t, constructor_t c);

term_t latest_term ();

void replace_term_with_term (term_t t1, term_t t2);

#endif /* #ifndef _TERM_H_ */
