/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#ifndef LANG_H_
#define LANG_H_

#include "../common/command_line.h" /* for MAX_FILENAME_LENGTH */

#define IDENTIFIER_LENGTH    1000
#define MODULES_PATH_LENGTH  16000
#define MAX_INCLUDED_MODULES 100
//#define MAX_FILENAME_LENGTH  (IDENTIFIER_LENGTH+2000)

#define MAX_QUALIFIED_LENGTH (MODULES_PATH_LENGTH+1+IDENTIFIER_LENGTH)

#define MODULES_SEPARATOR    ':'

extern char current_module_name[MAX_FILENAME_LENGTH + 1];

/* Defined in epsilon.l: */
void check_entered_line (char *text,
			 int *is_last_token_a_semicolon,
			 int *is_there_a_semicolon_before_last_token);

/* Defined in epsilon.l: */
/* Returns nonzero iff text is a 'define': */
int is_a_define_line (char *text, char **identifier, char **definition);

/* Returns nonzero iff text is an 'undefine': */
int is_an_undefine_line (char *text, char **identifier);

#endif /*#ifndef LANG_ */
