/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#ifndef _READLINE_WRAPPER_H_
#define _READLINE_WRAPPER_H_

#include "../config.h"

#ifdef HAVE_LIBREADLINE
  #include <readline/readline.h>
  #include <readline/history.h>
#else
  /* This function emulates readline() when it is not available: */
  char *readline(char *prompt);

  /* This stub "emulates" add_history() when readline is not
     available: */
  void add_history (const char *text);

#endif /* #ifndef HAVE_LIBREADLINE */

#endif /* #ifndef _READLINE_WRAPPER_H_ */
