/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#ifndef MY_MALLOC_H_
#define MY_MALLOC_H_

#include <sys/types.h> /* for size_t */

/* Simple malloc() and realloc() replacements for broken systems: */
void* rpl_malloc(size_t size);
void* rpl_realloc(void* old_pointer, size_t new_size);

/* Commodity versions of malloc() and realloc() which abort instead of
   returning NULL when memory is exhausted: */
void* xmalloc(size_t size);
void* xrealloc(void* old_pointer, size_t new_size);

#endif /* #ifndef MY_MALLOC_H_ */
