  
(use-modules (check))
(use-modules (ice-9 pretty-print))
(define test-errors '())

(use-modules (emacsy window))
(eval-when (compile load eval)
           (module-use! (current-module) (resolve-module '(emacsy window)))) 
  (check (window? root-window) => #t)
  (check (window-live? root-window) => #t)
(check (edges->bcoords '(0 1 1 0)) => '(0 0 1 1))
(check (bcoords->edges '(0 0 1 1)) => '(0 1 1 0))
(define i-window (make <internal-window>))
(define window (make <window>))
(check (window? i-window) => #t)
(check (window? window) => #t)
(check (procedure? split-window) => #t)
(define s-window (split-window window))
(check (is-a? s-window <internal-window>) => #t)
(define small-window (make <window>))
(define parent-window (split-window small-window 0.2))
(define big-window (cdr (window-children parent-window)))
(check (orientation parent-window) => 'vertical)
(define left-window (make <window>))
(define parent-window-2 (split-window left-window 0.2 'right))
(define right-window (cdr (window-children parent-window-2)))
(check (orientation parent-window-2) => 'horizontal)
(let* ((w (make <window>))
       (sw (split-window w))
       (c (cadr (window-children sw)))
       (sc (split-window c))
       (nc (cadr (window-children sc)))
  )

  (check (window-list w) => (list w))
  (check (window-tree sw) => (list w (list c nc)))
  (check (window-list sw) => (list w c nc))
  ;(check (window-list sw) => (list w c #f))
  ) 


;(run-tests)
(check-report)
'(if (> (length test-errors) 0)
    (format #t "~a ERROR in tests: ~a." (length test-errors) (reverse test-errors))
    (format #t "NO ERRORs in tests."))
(exit (if (and (= (length test-errors) 0) (= 0 (length check:failed))) 0 1))
