(use-modules (emacsy mru-stack)
             (check))

(use-private-modules (emacsy mru-stack))
(define s (make <mru-stack>))
(mru-add! s 'a)
(mru-add! s 'b)
(mru-add! s 'c)
(check (mru-list s) => '(c b a))
(check (mru-recall! s 'a) => '(a c b))
(check (mru-ref s) => 'a)
(mru-next! s)
(check (mru-ref s) => 'c)
(mru-next! s)
(check (mru-ref s) => 'b)
(mru-next! s)
(check (mru-ref s) => 'a)
(mru-prev! s)
(check (mru-ref s) => 'b)
(check (mru-list s) => '(a c b))
(mru-remove! s 'c)
(check (mru-list s) => '(a b))
(check (mru-ref s) => 'b)
(mru-remove! s 'a)
(mru-remove! s 'b)
(check (mru-list s) => '())
(check (mru-ref s) => #f)
(mru-next! s)
(check (mru-ref s) => #f)
(mru-add! s 'a)
(mru-add! s 'b)
(mru-add! s 'c)
(check (mru-list s) => '(c b a))
(mru-remove! s 'c)
(check (mru-list s) => '(b a))
(check (mru-ref s) => 'b)
(check-exit)
