(define-module (emacsy block)
  #:use-module (ice-9 optargs)
  #:use-module (oop goops)
  #:use-module (emacsy util))
(define-syntax-public with-blockable
  (syntax-rules ()
    ((with-blockable e ...)
     (call-blockable (lambda () e ...)))))
(define-class <blocking-continuation> ()
  (number #:getter number #:init-thunk (let ((count -1))
                                         (lambda () (incr! count))))
  (loop-number #:getter loop-number #:init-keyword #:loop-number)
  (tag #:getter tag #:init-keyword #:tag)
  (continuation #:init-keyword #:continuation)
  (continue-when? #:init-keyword #:continue-when?)
  (continue-now #:init-keyword #:continue-now)
  ;; Has this ran and ready to be deleted?
  (ran? #:accessor ran? #:init-value #f)
  (serial? #:getter serial? #:init-keyword #:serial? #:init-value #t))

(define-method (write (obj <blocking-continuation>) port)
  (write (string-concatenate 
          (list "#<bc " (symbol->string (tag obj))
                " " (number->string (number obj))
                " cl " (number->string (loop-number obj)) ">")) port))
(define blocking-continuations '())
(define-public no-blocking-continuations-hook (make-hook))
(define-public (block-yield)
  ;; I forgot why I'm running this thunk.
  (run-thunk (abort-to-prompt 'block 'block-until 
                              (const #t) #t)))
(define-public (call-blockable thunk)
  (let ((bc #f))
    (call-with-prompt
     'block
     thunk
     (lambda (cc kind . args)
       (case kind
         ((block-until)
          (let ((continue-command-loop? #t)
                (continue-wait? #t))
            (set! bc (make <blocking-continuation>
                       #:tag 'block-until
                       #:continuation cc
                       #:loop-number 0
                       #:continue-when? (car args)
                       #:continue-now 
                       (lambda ()
                         (set! continue-command-loop? #f)
                         (if continue-wait?
                             (call-blockable
                              (lambda () (cc (lambda () #t))))))
                       #:serial? (cadr args)))
            ;; Remember this bc.
            (cons! bc blocking-continuations))))))
    bc))
(define-public (block-tick)
  (set! blocking-continuations
        ;; Sort the continuations by the most recent ones.
        (sort! blocking-continuations (lambda (a b)
                                        (> (number a) (number b)))))
     (let ((ran-serial? #f))
       (for-each 
        (lambda (bc)
          (if (not (serial? bc)) 
              ;; If it's not serial, we might run it.
              (maybe-continue bc)
              ;; If it's serial, we only run the top one.
              (if (and (not ran-serial?) (serial? bc))
                  (begin
                    (if (maybe-continue bc)
                        (set! ran-serial? #t))))))
        blocking-continuations))
     ;; Keep everything that hasn't been run.
     (set! blocking-continuations 
           (filter! (lambda (bc) (not (ran? bc))) 
                    blocking-continuations))
     ;(format #t "blocking-continuations #~a of ~a~%" (length blocking-continuations) (map number blocking-continuations))
     (when (or (null? blocking-continuations)
               (null? (filter serial? blocking-continuations)))
       (run-hook no-blocking-continuations-hook))
    #t)
(define*-public (blocking?)
  (> (length blocking-continuations) 0))
(define-method (maybe-continue (obj <blocking-continuation>))
  (if (and (not (ran? obj))
;           (or run-serial? (serial? obj))
           ;; this line crashed.
           (run-thunk (slot-ref obj 'continue-when?)))
      (begin (set! (ran? obj) #t)
             (run-thunk (slot-ref obj 'continue-now))
             #t)
      #f))
(define*-public (block-until condition-thunk #:optional (serial? #f))
  (if (not (run-thunk condition-thunk))
      (run-thunk (abort-to-prompt 'block 'block-until 
                                  condition-thunk serial?))))
(define*-public (block-while condition-thunk #:optional (serial? #f))
  (block-until (negate condition-thunk) serial?))
(define-method-public (block-kill (obj <blocking-continuation>))
  (set! (ran? obj) #t)
  (call-blockable
   (lambda () ((slot-ref obj 'continuation)
               (lambda ()
                 (throw 'block-killed obj)
                 #f)))))

