(use-modules (emacsy minibuffer)
             (emacsy event)
             (emacsy klecl)
             (oop goops)
             (check))

(use-private-modules (emacsy minibuffer))

(set! emacsy-interactive? #t)

(use-modules (check))
(use-modules (ice-9 pretty-print))
(define test-errors '())
(check (buffer-string minibuffer) => "")
(check (point-min minibuffer) => 1)
(set! (minibuffer-prompt minibuffer) "What? ")
(check (buffer-string minibuffer) => "What? ")
(check (point-min minibuffer) => 7)
(with-buffer minibuffer
             (insert "Nothing."))
(check (buffer-string minibuffer) => "What? Nothing.")
(set! default-klecl-maps (lambda () (list minibuffer-local-map)))
(set-buffer! minibuffer)
(delete-minibuffer-contents minibuffer)
(check (buffer-string minibuffer) => "What? ")
(insert "A")
(agenda-schedule (colambda ()
                  (minibuffer-message " [Huh?]")))
#;(with-blockable
  (minibuffer-message " [Huh?]"))
(update-agenda)
(check (buffer-string minibuffer) => "What? A [Huh?]")
(update-agenda)
(check (buffer-string minibuffer) => "What? A")
(emacsy-key-event #\c)
(agenda-schedule (colambda () (command-tick)))
(update-agenda)
(check (buffer-string minibuffer) => "What? Ac")
;(emacsy-key-event #\a)
;(block-tick)
;(check (buffer-string minibuffer) => "What? Aa")
(emacsy-discard-input!)
(emacsy-key-event #\a)
(emacsy-key-event #\cr)
(check (read-from-minibuffer "What? ") => "a")
(emacsy-discard-input!)
(emacsy-key-event #\a)
(emacsy-key-event #\g '(control))
;(with-backtrace* (read-from-minibuffer "What?1 "))
;(set! emacsy-interactive? #f)
(check-throw ((colambda () (read-from-minibuffer "What?1 "))) => 'quit-command)
;((colambda () (read-from-minibuffer "What?1 ")))
;; Displaying the "Quit!" message causes a pause.
;(check-throw (update-agenda) => 'quit-command)
;(set! emacsy-interactive? #t)
(emacsy-discard-input!)
(emacsy-key-event #\h)
(emacsy-key-event #\i)
(emacsy-key-event #\cr)
(emacsy-key-event #\b)
(emacsy-key-event #\y)
(emacsy-key-event #\e)
(emacsy-key-event #\cr)
;(with-backtrace* (read-from-minibuffer "What?1 "))
(let ((h (make-history '())))
  (check (read-from-minibuffer "What?3 " #:history h) => "hi")
  (check (cursor-list->list h) => '("hi"))
  (check (read-from-minibuffer "What?4 " #:history h) => "bye")
  (check (cursor-list->list h) => '("hi" "bye"))
  )
(emacsy-discard-input!)
(emacsy-key-event #\p '(meta))
(emacsy-key-event #\cr)
(emacsy-key-event #\1)
(emacsy-key-event #\cr)
;(with-backtrace* (read-from-minibuffer "What?1 "))
(let ((h (make-history '("hi"))))
  (check (cursor-list->list h) => '("hi"))
  (check (read-from-minibuffer "What?3 " #:history h) => "hi")
  (check (cursor-list->list h) => '("hi" ""))
  (check (read-from-minibuffer "What?5 " #:history h) => "1")
  (check (cursor-list->list h) => '("hi" "1" ""))
)
(emacsy-discard-input!)
(emacsy-key-event #\1)
(emacsy-key-event #\cr)
(emacsy-key-event #\p '(meta))
(emacsy-key-event #\cr)
(emacsy-key-event #\p '(meta))
(emacsy-key-event #\cr)
;(with-backtrace* (read-from-minibuffer "What?1 "))
(let ((h (make-history '("hi"))))
  (check (read-from-minibuffer "What?6 " #:history 'h1) => "1")
  (check (read-from-minibuffer "What?7 " #:history 'h1) => "1")

  (check (read-from-minibuffer "What?6 " #:history 'h2) => "")
)
(check (try-completion "f" (list "foo" "foobar" "barfoo")) => "foo")
(check (try-completion "b" (list "foo" "foobar" "barfoo")) => "barfoo")

;; Try against readline completer
(check (try-completion "f" (make-completion-function (list "foo" "foobar" "barfoo"))) => "foo")
(check (try-completion "b" (make-completion-function (list "foo" "foobar" "barfoo"))) => "barfoo")
(check (try-completion "f" (lambda (string predicate all?) (if (string=? string "f") "blah" "huh"))) => "blah")
(check (try-completion "w" (lambda (string predicate all?) (if (string=? string "f") "blah" "huh"))) => "huh")
(check (sort! (stream->list (readline-completer->stream command-completion-function "")) string<?) => (sort! '("switch-to-buffer" "eval-expression" "execute-extended-command" "load-file" "quit-application" "universal-argument") string<?))
(check (all-completions "f" (list "foo" "foobar" "barfoo")) => (list "foo" "foobar"))
(check (all-completions "b" (list "foo" "foobar" "barfoo")) => (list "barfoo"))

(check (all-completions "f" (make-completion-function (list "foo" "foobar" "barfoo"))) => (list "foo" "foobar"))
(check (all-completions "b" (make-completion-function (list "foo" "foobar" "barfoo"))) => (list "barfoo"))
(chdir (format #f "~a/~a" (getenv "ABS_TOP_SRCDIR") "test/minibuffer-test-dir"))
(check (dirname "") => ".")
(check (my-dirname "") => ".")
(check (my-dirname "../now") => "..")
(check (my-dirname "bin") => "bin/")
(check (my-dirname "bin/") => "bin/")
(check (my-dirname "mini") => ".")
(check (directory? ".") => #t)
(check (directory? "..") => #t)
(check (canonize-filename ".") => "./")
;(check (files-in-dir ".") => '())
(for-each (lambda (file-name-completer)
            (check (file-name-completer "mini" (const #t) #t) => '("minibuffer-a" "minibuffer-b"))
            (check (file-name-completer "mini" (const #t) #f) => "minibuffer-")
            (check (file-name-completer "bi" (const #t) #f) => "bin/")
            (check (file-name-completer "bin" (const #t) #f) => "bin/")
            (check (file-name-completer "bin/" (const #t) #f) => "bin/")
            ;; Get rid of the dot files.
            (check (file-name-completer "bin" no-dot-files #f) => "bin/run-test")
            (check (file-name-completer "bin/" no-dot-files #f) => "bin/run-test")
            (check (file-name-completer "ex" (const #t) #f) => "exam/")
            (check (file-name-completer "em" (const #t) #f) => "empty-dir/"))
          (list file-name-completer
                #;(lambda (string predicate all?)
                  (if all?
                      (stream->list (readline-completer->stream filename-completion-function string))
                      (filename-completion-function string #f)))))
(check (dirname "bin/") => ".")
(check (basename "bin/") => "bin")
(check (basename "bin/f") => "f")
(check (dirname "bin/f") => "bin")
(check (my-dirname "bin/") => "bin/")
(check (files-in-parent-dir "bin/") => '("bin/../" "bin/./" "bin/run-test"))
(check (files-in-parent-dir "bin") => '( "bin/../" "bin/./" "bin/run-test"))

(check (files-in-dir "bin/") => '("." ".." "run-test"))
(check (files-in-dir "bin") => '( "." ".." "run-test"))
(check (file-name-completer "bin/" no-dot-files #t) => '("bin/run-test"))

;(check (files-in-dir "..") => '())

(chdir (format #f "~a/~a" (getenv "ABS_TOP_SRCDIR") "test/minibuffer-test-dir/empty-dir"))
(check (file-name-completer "../ex" (const #t) #f) => "../exam/")
(let ((h (make-history '("3" "2" "1"))))
  (cursor-left! h)
    (check ( history-ref h) => "1")
    (history-set! h "a")
    (check ( history-ref h) => "a")
    (cursor-left! h)
    (check ( history-ref h) => "2")
    (cursor-right! h)
    (cursor-right! h)
    (check (cursor-list->list h) => '("3" "2" "a")))
;(run-tests)
(check-report)
'(if (> (length test-errors) 0)
    (format #t "~a ERROR in tests: ~a." (length test-errors) (reverse test-errors))
    (format #t "NO ERRORs in tests."))
(exit (if (and (= (length test-errors) 0) (= 0 (length check:failed))) 0 1))
