(use-modules (emacsy kbd-macro)
             (emacsy event)
             (emacsy command)     
             (emacsy klecl)
             (oop goops)
             (check))

(use-private-modules (emacsy kbd-macro))

(set! emacsy-interactive? #t)

(use-modules (check))
(use-modules (ice-9 pretty-print))
(define test-errors '())
(define test-command-called 0)
(define test-keymap (make-keymap))
(define-interactive (test-command)
  (incr! test-command-called))

(define-key test-keymap (kbd "a") 'test-command)
(set! default-klecl-maps (lambda () (list test-keymap)))

(check test-command-called => 0)
(kmacro-start-macro)
(emacsy-key-event #\a)
(emacsy-key-event #\b) ;; this executes no command.
(primitive-command-loop (lambda args #f))
(primitive-command-loop (lambda args #f))
(kmacro-end-macro)
(check test-command-called => 1)
(check (map command-char last-kbd-macro) => '(#\b #\a))
(execute-kbd-macro last-kbd-macro)
(check test-command-called => 2)
(check test-command-called => 2)
(execute-temporal-kbd-macro last-kbd-macro)
(primitive-command-loop (lambda args #f))
(check test-command-called => 3)
;(run-tests)
(check-report)
'(if (> (length test-errors) 0)
    (format #t "~a ERROR in tests: ~a." (length test-errors) (reverse test-errors))
    (format #t "NO ERRORs in tests."))
(exit (if (and (= (length test-errors) 0) (= 0 (length check:failed))) 0 1))
