(define-module (emacsy help)
  #:use-module (emacsy self-doc)
  #:use-module (emacsy keymap)
  #:use-module (emacsy klecl)
  #:use-module (emacsy command)
  #:use-module (emacsy minibuffer)
  #:use-module (emacsy core))



(define-interactive 
  (describe-variable 
   #:optional 
   (symbol (completing-read 
              "Describe variable: "
              (emacsy-collect-kind (current-module) 'variable 1)
              #:to-string symbol->string)))
  #;(message "Describing variable ~a: ~a" symbol (variable-documentation symbol))
  (message "~a" (variable-documentation symbol)))

(define-interactive 
  (describe-command
   #:optional 
   (symbol (completing-read 
              "Describe command: "
              (emacsy-collect-kind (current-module) 'command 1)
              #:to-string symbol->string)))
  #;(message "Describing variable ~a: ~a" symbol (variable-documentation symbol))
  (message "~a" (procedure-documentation (module-ref (current-module) symbol))))

(define-key global-map "C-h v" 'describe-variable)
(define-key global-map "C-h c" 'describe-command)
