﻿; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!
#define AppName              "Eliot"
#define SimpleName           "eliot"
#define CurrentVersion       "2.2"
#define AppVersion           "2.2"
#define Homepage             "http://www.nongnu.org/eliot"
#define MainBinaryName       "eliot.exe"
#define SetupBaseName        "setup_eliot_"
#define AppID                "{4652A7B1-B7F2-43CF-A524-9ABACC0AAD25}"
#define AppIDStr             "{" + AppID

#define DicPathRegKey        "Software\eliot\eliot\Interface"

#define EnglishDict          "English (Worldwide), CSW12"
#define English2Dict         "English (North America), TWL06"
#define BambaraDict          "Bambara (Bambara), Bamanakan v1"
#define CatalanDict          "Catalan (Català), DISC 2.4.10"
#define CzechDict            "Czech (Čeština)"
#define FrenchDict           "French (Français)"
#define ItalianDict          "Italian (Italiano), Zinga2011"
#define MalagasyDict         "Malagasy (Malagasy), RAK 1"
#define NorwegianDict        "Norwegian (Norwegian), NSF"
#define PolishDict           "Polish (Polish), SJP"
#define RomanianDict         "Romanian (Română), LOC 5"
#define SerbianDict          "Serbian (Српски)"
#define SpanishDict          "Spanish (Español), Lexicón FISE 2009"
; add a new dictionary following the template
; #define LangDict "LangName_in_English (LangName_in_own_language)`[, Dict_Name [version_numer]]"


#define EnglishFile          "\dicts\english\csw12.dawg"
#define English2File         "\dicts\english\twl06.dawg"
#define BambaraFile          "\dicts\bambara\bamanakan-v1.dawg"
#define CatalanFile          "\dicts\catalan\disc2.4.10.dawg"
#define CzechFile            "\dicts\czech\eliot-dic-cs.dawg"
#define FrenchFile           "\dicts\french\eliot-dic-fr.dawg"
#define ItalianFile          "\dicts\italian\zinga2011.dawg"
#define MalagasyFile         "\dicts\malagasy\rak.dawg"
#define NorwegianFile        "\dicts\norwegian\nsf.dawg"
#define PolishFile           "\dicts\polish\sjp.dawg"
#define RomanianFile         "\dicts\romanian\loc5.dawg"
#define SerbianFile          "\dicts\serbian\serbian-unofficial.dawg"
#define SpanishFile          "\dicts\spanish\lex-fise.dawg"
; add a new dictionary following the template
; #define LangFile "filename.dawg"

[LangOptions]
; Only change LanguageName in following 2 cases:

; case a.- there at least 2 dictionaries for the same language
english.LanguageName=English (Worldwide)
english2.LanguageName=English (North America)

; case b.- there isn't Inno Setup language file and we use English default file instead
malagasy.LanguageName=Malagasy
bambara.LanguageName=Bambara


[CustomMessages]
; please, translate the following 6 messages when adding a new installer language

;message1
CreateStartMenuFolder=Create start menu folder
catalan.CreateStartMenuFolder=Crea una carpeta al menú d'inici
spanish.CreateStartMenuFolder=Crea una carpeta en el Menú Inicio
french.CreateStartMenuFolder=Créer un dossier dans le menu Démarrer
;message2
EliotDictionaries=DAWG dictionaries for {#AppName}
catalan.EliotDictionaries=Diccionaris DAWG per a l'{#AppName}
spanish.EliotDictionaries=Diccionarios DAWG para {#AppName}
french.EliotDictionaries=Dictionnaires DAWG pour {#AppName}
;message3
EliotIsInstalled={#AppName} is already installed on your computer. It must be uninstalled before installing {#AppVersion} version. Do you want to continue?
catalan.EliotIsInstalled=L'{#AppName} ja és instal·lat a l'ordinador. Heu de desinstal·lar-lo abans d'instal·lar la versió {#AppVersion}. Voleu continuar?
spanish.EliotIsInstalled=L'{#AppName} ya está instalado en el equipo. Debe desinstalar-lo antes de instalar la versión {#AppVersion}. ¿Desea continuar?
french.EliotIsInstalled={#AppName} est déjà installé sur votre ordinateur. Il doit être désinstallé avant l'installation de la version {#AppVersion}. Voulez-vous continuer ?
;message4
UninstallError=Error occurred uninstalling {#AppName}.
catalan.UninstallError=S'ha produït un error en la desinstal·lació de la versió de l'{#AppName} a l'ordinador.
spanish.UninstallError=Se ha producido un error en la desinstalación de la versión de l'{#AppName} en el equipo.
french.UninstallError=Une erreur s'est produite durant la désinstallation d'{#AppName}.
;message5
AbortInstallation={#AppName} {#AppVersion} installation was cancelled.
catalan.AbortInstallation=S'ha cancel·lat la instal·lació de l'{#AppName} {#AppVersion}.
spanish.AbortInstallation=Se ha cancelado la instalación de {#AppName} {#AppVersion}.
french.AbortInstallation=L'installation d'{#AppName} {#AppVersion} a été annulée.
;message6
SeveralDicts=You can select any of the installed {#AppName} dictionaries in "{app}\dicts".
catalan.SeveralDicts=Podeu seleccionar qualsevol dels diccionaris de l'{#AppName} instal·lats a la carpeta "{app}\dicts".
spanish.SeveralDicts=Puede seleccionar cualquiera de los diccionarios de {#AppName} instalados en la carpeta "{app}\dicts".
french.SeveralDicts=Vous pouvez sélectionner n'importe quel dictionnaire d'{#AppName} installé dans le répertoire "{app}\dicts".

[Types]
Name: "compact"; Description: "{code:CompactInstall}"
Name: "full"; Description: "{code:FullInstall}"
Name: "custom"; Description: "{code:CustomInstall}"; Flags: iscustom

[Setup]
AppID={#AppIDStr}
AppName={#AppName}
AppVerName={#AppName} {#AppVersion}
AppVersion={#AppVersion}

AppPublisher=Olivier Teulière
AppPublisherURL={#Homepage}
AppSupportURL={#Homepage}
AppUpdatesURL={#Homepage}

DefaultDirName={pf}\{#AppName}
DefaultGroupName={#AppName}
LicenseFile=.\{#SimpleName}\COPYING.txt
OutputBaseFilename={#SetupBaseName}{#CurrentVersion}
Compression=lzma
SolidCompression=yes
AllowNoIcons=yes
DisableProgramGroupPage=auto
AlwaysShowGroupOnReadyPage=yes
UninstallDisplayIcon={app}\{#MainBinaryName}
UsePreviousAppDir=no
UsePreviousSetupType=no
UsePreviousGroup=no
UsePreviousLanguage=no
UsePreviousTasks=no
UsePreviousUserInfo=no
MinVersion=5.1

; installer UI language, used for dictionaries too.
[Languages]
; we have 2 English dictionaries, so create 2 English languages entries in installer language selection
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "english2"; MessagesFile: "compiler:Default.isl"
; there is no Bambara language file for Inno Setup, so use English strings
Name: "bambara"; MessagesFile: "compiler:Default.isl"
Name: "catalan"; MessagesFile: "compiler:Languages\Catalan.isl"
Name: "czech"; MessagesFile: "compiler:Languages\Czech.isl"
Name: "french"; MessagesFile: "compiler:Languages\French.isl"
Name: "italian"; MessagesFile: "compiler:Languages\Italian.isl"
; there is no Malagasy language file for Inno Setup, so use English strings
Name: "malagasy"; MessagesFile: "compiler:Default.isl"
Name: "norwegian"; MessagesFile: "compiler:Languages\Norwegian.isl"
Name: "polish"; MessagesFile: "compiler:Languages\Polish.isl"
Name: "serbian"; MessagesFile: "compiler:Languages\SerbianCyrillic.isl"
Name: "spanish"; MessagesFile: "compiler:Languages\Spanish.isl"
Name: "romanian"; MessagesFile: ".\innosetup-langs\Romanian.isl"

; enable languages not supported by Eliot, but supported by InnoSetup
Name: "brazilianportuguese"; MessagesFile: "compiler:Languages\BrazilianPortuguese.isl"
Name: "corsican"; MessagesFile: "compiler:Languages\Corsican.isl"
Name: "danish"; MessagesFile: "compiler:Languages\Danish.isl"
Name: "dutch"; MessagesFile: "compiler:Languages\Dutch.isl"
Name: "finnish"; MessagesFile: "compiler:Languages\Finnish.isl"
Name: "german"; MessagesFile: "compiler:Languages\German.isl"
Name: "greek"; MessagesFile: "compiler:Languages\Greek.isl"
Name: "hebrew"; MessagesFile: "compiler:Languages\Hebrew.isl"
Name: "hungarian"; MessagesFile: "compiler:Languages\Hungarian.isl"
Name: "italian"; MessagesFile: "compiler:Languages\Italian.isl"
Name: "japanese"; MessagesFile: "compiler:Languages\Japanese.isl"
Name: "nepali"; MessagesFile: "compiler:Languages\Nepali.islu"
Name: "portuguese"; MessagesFile: "compiler:Languages\Portuguese.isl"
Name: "russian"; MessagesFile: "compiler:Languages\Russian.isl"
Name: "scottishgaelic"; MessagesFile: "compiler:Languages\ScottishGaelic.isl"
Name: "serbianlatin"; MessagesFile: "compiler:Languages\SerbianLatin.isl"
Name: "slovenian"; MessagesFile: "compiler:Languages\Slovenian.isl"
Name: "turkish"; MessagesFile: "compiler:Languages\Turkish.isl"
Name: "ukrainian"; MessagesFile: "compiler:Languages\Ukrainian.isl"
; add a new dictionary following the template
; Name: "langname"; MessagesFile: "compiler:Languages\LanguageFileName.isl"


[Tasks]
;Name: "startmenufolder"; Description: "{cm:CreateStartMenuFolder}"; GroupDescription: "{cm:AdditionalIcons}";
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}";
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked; OnlyBelowVersion: 0,6.1

[Files]
; main program, Eliot
Source: ".\eliot\*"; DestDir: "{app}"; Components: main; Flags: ignoreversion recursesubdirs createallsubdirs
; dictionaries, one line for dict.
Source: ".{#EnglishFile}"; DestDir: "{app}\dicts\english"; Components:dicts\english; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#English2File}"; DestDir: "{app}\dicts\english"; Components:dicts\english2; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#BambaraFile}"; DestDir: "{app}\dicts\bambara"; Components:dicts\bambara; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#CatalanFile}"; DestDir: "{app}\dicts\catalan"; Components:dicts\catalan; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#CzechFile}"; DestDir: "{app}\dicts\czech"; Components:dicts\czech; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#FrenchFile}"; DestDir: "{app}\dicts\french"; Components:dicts\french; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#ItalianFile}"; DestDir: "{app}\dicts\italian"; Components:dicts\italian; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#MalagasyFile}"; DestDir: "{app}\dicts\malagasy"; Components:dicts\malagasy; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#NorwegianFile}"; DestDir: "{app}\dicts\norwegian"; Components:dicts\norwegian; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#PolishFile}"; DestDir: "{app}\dicts\polish"; Components:dicts\polish; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#RomanianFile}"; DestDir: "{app}\dicts\romanian"; Components:dicts\romanian; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#SerbianFile}"; DestDir: "{app}\dicts\serbian"; Components:dicts\serbian; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#SpanishFile}"; DestDir: "{app}\dicts\spanish"; Components:dicts\spanish; Flags: ignoreversion recursesubdirs createallsubdirs
; add a new dictionary following the template
;Source: ".\dicts\language_name\*"; DestDir: "{app}\dicts\language_name"; Components:dicts\language_name; Flags: ignoreversion recursesubdirs createallsubdirs

[Icons]
Name: "{group}\Eliot"; Filename: "{app}\eliot.exe";
;Name: "{group}\Eliot"; Filename: "{app}\eliot.exe"; Tasks: startmenufolder
Name: "{commondesktop}\Eliot"; Filename: "{app}\eliot.exe"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\Eliot"; Filename: "{app}\eliot.exe"; Tasks: quicklaunchicon
;Name: "{group}\{cm:ProgramOnTheWeb,{appName}"; Filename: "{#MyAppURL}"
;Name: "{group}\{cm:UninstallProgram,{app}"; Filename: "{uninstallexe}"


[Run]
Filename: "{app}\eliot.exe"; Description: "{cm:LaunchProgram,Eliot}"; Flags: nowait postinstall skipifsilent


[Components]
Name: "main"; Description: "Eliot"; Types: full compact custom; Flags: fixed
Name: "dicts"; Description: "{cm:EliotDictionaries}";Types: full
; English Worldwide
Name: "dicts\english"; Description: {#EnglishDict}; Languages: english; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\english"; Description: {#EnglishDict}; Languages: not english; Types: full; Flags: disablenouninstallwarning
; English North America
Name: "dicts\english2"; Description: {#English2Dict}; Languages: english2; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\english2"; Description: {#English2Dict}; Languages: not english2; Types: full; Flags: disablenouninstallwarning
; Bambara
Name: "dicts\bambara"; Description: {#BambaraDict}; Languages: bambara; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\bambara"; Description: {#BambaraDict}; Languages: not bambara; Types: full; Flags: disablenouninstallwarning
; Catalan
Name: "dicts\catalan"; Description: {#CatalanDict}; Languages: catalan; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\catalan"; Description: {#CatalanDict}; Languages: not catalan; Types: full; Flags: disablenouninstallwarning
; Czech
Name: "dicts\czech"; Description: {#CzechDict}; Languages: czech; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\czech"; Description: {#CzechDict}; Languages: not czech; Types: full; Flags: disablenouninstallwarning
; French
Name: "dicts\french"; Description: {#FrenchDict}; Languages: french; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\french"; Description: {#FrenchDict}; Languages: not french; Types: full; Flags: disablenouninstallwarning
; Italian
Name: "dicts\italian"; Description: {#ItalianDict}; Languages: italian; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\italian"; Description: {#ItalianDict}; Languages: not italian; Types: full; Flags: disablenouninstallwarning
; Malagasy
Name: "dicts\malagasy"; Description: {#MalagasyDict}; Languages: malagasy; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\malagasy"; Description: {#MalagasyDict}; Languages: not malagasy; Types: full; Flags: disablenouninstallwarning
; Norwegian
Name: "dicts\norwegian"; Description: {#NorwegianDict}; Languages: norwegian; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\norwegian"; Description: {#NorwegianDict}; Languages: not norwegian; Types: full; Flags: disablenouninstallwarning
; Polish
Name: "dicts\polish"; Description: {#PolishDict}; Languages: polish; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\polish"; Description: {#PolishDict}; Languages: not polish; Types: full; Flags: disablenouninstallwarning
; Romanian
Name: "dicts\romanian"; Description: {#RomanianDict}; Languages: romanian; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\romanian"; Description: {#RomanianDict}; Languages: not romanian; Types: full; Flags: disablenouninstallwarning
; Serbian
Name: "dicts\serbian"; Description: {#SerbianDict}; Languages: serbian; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\serbian"; Description: {#SerbianDict}; Languages: not serbian; Types: full; Flags: disablenouninstallwarning
; Spanish
Name: "dicts\spanish"; Description: {#SpanishDict}; Languages: spanish; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\spanish"; Description: {#SpanishDict}; Languages: not spanish; Types: full; Flags: disablenouninstallwarning
; add a new dictionary following the template
; language
;Name: "dicts\language_name"; Description: {#LangNameDict}; Languages: language_name; Types: full compact; Flags: disablenouninstallwarning
;Name: "dicts\language_name"; Description: {#LangNameDict}; Languages: not language_name; Types: full; Flags: disablenouninstallwarning

[Code]

/////////////////////////////////////////////////////////////////////
// following 3 functions are need to set Compact type as default
//
function FullInstall(Param : String) : String;
begin
  result := SetupMessage(msgFullInstallation);
end;
//
function CustomInstall(Param : String) : String;
begin
  result := SetupMessage(msgCustomInstallation);
end;
//
function CompactInstall(Param : String) : String;
begin
  result := SetupMessage(msgCompactInstallation);
end;


/////////////////////////////////////////////////////////////////////
function GetUninstallCommand(): String;
var
  sUninstallPath: String;
  sUninstallCommand: String;
begin
  sUnInstallPath := 'Software\Microsoft\Windows\CurrentVersion\Uninstall\{#AppID}_is1';
  sUninstallCommand := '';
  // get and return Eliot uninstall command and return
  if not RegQueryStringValue(HKLM, sUninstallPath, 'UninstallString', sUninstallCommand) then
    RegQueryStringValue(HKCU, sUninstallPath, 'UninstallString', sUninstallCommand);

   Result := sUninstallCommand;
end;


/////////////////////////////////////////////////////////////////////
function IsEliotInstalled(): Boolean;
begin
  // check if Eliot uninstall command exits and is not empty
  Result := (GetUninstallCommand() <> '');
end;


/////////////////////////////////////////////////////////////////////
function UninstallOldVersion(): Integer;
var
  sUninstallCommand: String;
  iResultCode: Integer;
begin
// Return Values:
// 0 - successfully executed the UninstallCommand
// 1 - error executing the UninstallCommand
// 2 - UninstallCommand string is empty

  Result := 2;

  // get the uninstall command string for the old app
  sUninstallCommand := GetUninstallCommand();
  if sUninstallCommand <> '' then begin
    sUninstallCommand := RemoveQuotes(sUninstallCommand);
    // run it.
    if Exec(sUninstallCommand, '/NORESTART','', SW_HIDE, ewWaitUntilTerminated, iResultCode) then
       Result := 0
    else
      // there was an error.
      Result := 1;
  end else
    // there is no uninstall command, so there is no old Eliot version installed
    Result := 2;
end;


/////////////////////////////////////////////////////////////////////
function GetConfiguredDict(): String;
var
  sDictRegKey: String;
  sDictPath: String;
begin

  // get path to current configured dictionary
  sDictRegKey := ExpandConstant('Software\eliot\eliot\Interface');
  sDictPath := '';
  if not RegQueryStringValue(HKCU, sDictRegKey, 'DicPath', sDictPath) then
    RegQueryStringValue(HKLM, sDictRegKey, 'DicPath', sDictPath);

  // return it
  Result := sDictPath;
end;


/////////////////////////////////////////////////////////////////////
function IsConfiguredDict(): Boolean;
begin
  // check if there is configured a dictionary
  Result := (GetConfiguredDict() <> '');
end;


/////////////////////////////////////////////////////////////////////
function SetConfiguredDict(): Integer;
var
  sSelectedComponents: String;
  sSelectedDictPath: String;
begin
// Return Values:
// 0 - successfully executed the SetConfiguredDict
// 1 - a dict is already set as default
// 2 - error setting the default dict


  // default return value
  Result := 2;

  sSelectedComponents := WizardSelectedComponents(False);


  if ( CompareText('main,dicts,dicts/', sSelectedComponents) < 0) then
  begin
      // remove 'main,dicts,dicts/' part: 17 chars.
      Delete(sSelectedComponents, 1, 17);

      // check if more than 1 dictionary/component was selected
      if (Pos (',', sSelectedComponents) > 0) then
       MsgBox(ExpandConstant(CustomMessage('SeveralDicts')), mbInformation, MB_OK)
      else
      begin
        //Only 1 dictionary was selected, remove current regkeys
        RegDeleteValue(HKEY_CURRENT_USER, '{#DicPathRegKey}', 'DicPath');
        RegDeleteValue(HKEY_LOCAL_MACHINE, '{#DicPathRegKey}', 'DicPath');
        sSelectedDictPath := '';
        if ( sSelectedComponents = 'english') then
          sSelectedDictPath := '{#EnglishFile}'
        else if ( sSelectedComponents = 'english2') then
          sSelectedDictPath := '{#English2File}'
        else if ( sSelectedComponents = 'bambara') then
          sSelectedDictPath := '{#BambaraFile}'
        else if ( sSelectedComponents = 'catalan') then
          sSelectedDictPath := '{#CatalanFile}'
        else if ( sSelectedComponents = 'czech') then
          sSelectedDictPath := '{#CzechFile}'
        else if ( sSelectedComponents = 'french') then
          sSelectedDictPath := '{#FrenchFile}'
        else if ( sSelectedComponents = 'italian') then
          sSelectedDictPath := '{#ItalianFile}'
        else if ( sSelectedComponents = 'malagasy') then
          sSelectedDictPath := '{#MalagasyFile}'
        else if ( sSelectedComponents = 'norwegian') then
          sSelectedDictPath := '{#NorwegianFile}'
        else if ( sSelectedComponents = 'polish') then
          sSelectedDictPath := '{#PolishFile}'
        else if ( sSelectedComponents = 'romanian') then
          sSelectedDictPath := '{#RomanianFile}'
        else if ( sSelectedComponents = 'serbian') then
          sSelectedDictPath := '{#SerbianFile}'
        else if ( sSelectedComponents = 'spanish') then
          sSelectedDictPath := '{#SpanishFile}'
        else // default, empty dict path
          sSelectedDictPath := '';

        // Config selected dictionary as default
        RegWriteStringValue(HKEY_CURRENT_USER, '{#DicPathRegKey}','DicPath', ExpandConstant('{app}'+ sSelectedDictPath));
        Result:=0;
      end
  end;
  Result := 1;
end;

/////////////////////////////////////////////////////////////////////
procedure CurStepChanged(CurStep: TSetupStep);
begin
 if (CurStep=ssPostInstall) then // After installing files, check current configured dictionary.
  begin
    if (IsConfiguredDict = False) then // There is no configured/custom dict.
      SetConfiguredDict()
    else if (not FileExists(GetConfiguredDict)) then // the configured dictionary file doesn't exists.
    begin
        RegDeleteValue(HKEY_CURRENT_USER, '{#DicPathRegKey}', 'DicPath');
        RegDeleteValue(HKEY_LOCAL_MACHINE, '{#DicPathRegKey}', 'DicPath');
        SetConfiguredDict();
    end
    // else
    // There is a default/custom dict and the file exists.
    // Keep untouched. Nothing to do.
  end

end;

/////////////////////////////////////////////////////////////////////
function InitializeSetup(): Boolean;

begin

 if IsEliotInstalled then // Eliot is installed -> ask user to uninstall it.
  begin
   if MsgBox(CustomMessage('EliotIsInstalled'), mbConfirmation, MB_YESNO) = IDYES then
   begin // user clicked yes -> uninstall old Eliot version
    if UninstallOldVersion = 0 then
     result:=True
    else // unable to uninstall -> alert user
    begin
     MsgBox(CustomMessage('UninstallError'), mbInformation, MB_OK);
     result:= False;
    end
   end
   else // user clicked no -> abort installation
   begin
    MsgBox(CustomMessage('AbortInstallation'), mbInformation, MB_OK);
    result:= False;
   end
  end
  else
   result:= True;

end;
