﻿; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!
#define MainBinaryName  "eliot\eliot.exe"
#define SetupBaseName   "setup_eliot_"
#define CurrentVersion "2.1"
#define DicPathRegKey "Software\eliot\eliot\Interface"

#define EnglishDict "English, CSW12 (Worldwide)"           
#define English2Dict "English, TWL06 (North America)"
#define CatalanDict "Catalan (Català), DISC 2.0.6"
#define CzechDict "Czech (Čeština)"
#define FrenchDict "French (Français)"
#define ItalianDict "Italian (Italiano), Zinga2011"
#define MalagasyDict "Malagasy (Malagasy), RAK 1"
#define RomanianDict "Romanian (Română), LOC 5"
#define SerbianDict  "Serbian (Српски)"
#define SpanishDict "Spanish (Español), Lexicón FISE 2009"
; add a new dictionary following the template
; #define LangDict "LangName_in_English (LangName_in_that_language), Dict_Name"


#define EnglishFile "\dicts\english\csw12.dawg"
#define English2File "\dicts\english\twl06.dawg"
#define CatalanFile "\dicts\catalan\disc2.0.6.dawg"
#define CzechFile "\dicts\czech\eliot-dic-cs.dawg"
#define FrenchFile "\dicts\french\eliot-dic-fr.dawg"
#define ItalianFile "\dicts\italian\zinga2011.dawg"
#define MalagasyFile "\dicts\malagasy\rak.dawg"
#define RomanianFile "\dicts\romanian\loc5.dawg"
#define SerbianFile "\dicts\serbian\serbian-unofficial.dawg"
#define SpanishFile "\dicts\spanish\lex-fise.dawg"

; add a new dictionary following the template
; #define LangFile "filename.dawg"

[LangOptions]
; change LanguageName when:
; a.- there are two or more dictionries for the same language 
english.LanguageName=English (Worldwide)
english2.LanguageName=English (North America)
; b.- there isn't Inno Setup language file and we use English default file instead
malagasy.LanguageName=Malagasy

[CustomMessages]
; please, translate following messages when adding a new language

;message1
CreateStartMenuFolder=Create start menu folder
catalan.CreateStartMenuFolder=Crea una carpeta al menú d'inici
spanish.CreateStartMenuFolder=Crea una carpeta en el Menú Inicio
;message2
EliotDictionaries=DAWG dictionaries for Eliot
catalan.EliotDictionaries=Diccionaris DAWG per a l'Eliot
spanish.EliotDictionaries=Diccionarios DAWG para Eliot

[Types]
Name: "compact"; Description: "{code:CompactInstall}"
Name: "full"; Description: "{code:FullInstall}"
Name: "custom"; Description: "{code:CustomInstall}"; Flags: iscustom

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{4652A7B1-B7F2-43CF-A524-9ABACC0AAD25}
AppName=Eliot
AppVersion={#CurrentVersion}
;AppVerName=Eliot 2.0
AppPublisher=Olivier Teulière
AppPublisherURL=http://www.nongnu.org/eliot/en/
AppSupportURL=http://www.nongnu.org/eliot/en/
AppUpdatesURL=http://www.nongnu.org/eliot/en/
DefaultDirName={pf}\Eliot
DefaultGroupName=Eliot
LicenseFile=.\eliot\COPYING.txt
OutputBaseFilename={#SetupBaseName}{#CurrentVersion}
Compression=lzma
SolidCompression=yes
AllowNoIcons=yes
DisableProgramGroupPage=auto
AlwaysShowGroupOnReadyPage=yes

[Languages]
; installer UI language
; add a new installer language when adding a new game language
; current mangalasy is missing
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "english2"; MessagesFile: "compiler:Default.isl"
Name: "catalan"; MessagesFile: "compiler:Languages\Catalan.isl"
Name: "czech"; MessagesFile: "compiler:Languages\Czech.isl"
Name: "french"; MessagesFile: "compiler:Languages\French.isl"
Name: "italian"; MessagesFile: "compiler:Languages\Italian.isl"
; there is no Malagasy language file for Inno Setup, use English strings
Name: "malagasy"; MessagesFile: "compiler:Default.isl"
Name: "serbian"; MessagesFile: "compiler:Languages\SerbianCyrillic.isl"
Name: "spanish"; MessagesFile: "compiler:Languages\Spanish.isl"
Name: "romanian"; MessagesFile: ".\innosetup-langs\Romanian.isl"

[Tasks]
;Name: "startmenufolder"; Description: "{cm:CreateStartMenuFolder}"; GroupDescription: "{cm:AdditionalIcons}";
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}";
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked; OnlyBelowVersion: 0,6.1

[Files]
; main program, Eliot
Source: ".\eliot\*"; DestDir: "{app}"; Components: main; Flags: ignoreversion recursesubdirs createallsubdirs
; dictionaries, one line for dict.
Source: ".{#EnglishFile}"; DestDir: "{app}\dicts\english"; Components:dicts\english; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#English2File}"; DestDir: "{app}\dicts\english"; Components:dicts\english2; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#CatalanFile}"; DestDir: "{app}\dicts\catalan"; Components:dicts\catalan; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#CzechFile}"; DestDir: "{app}\dicts\czech"; Components:dicts\czech; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#FrenchFile}"; DestDir: "{app}\dicts\french"; Components:dicts\french; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#ItalianFile}"; DestDir: "{app}\dicts\italian"; Components:dicts\italian; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#MalagasyFile}"; DestDir: "{app}\dicts\malagasy"; Components:dicts\malagasy; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#RomanianFile}"; DestDir: "{app}\dicts\romanian"; Components:dicts\romanian; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#SerbianFile}"; DestDir: "{app}\dicts\serbian"; Components:dicts\serbian; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".{#SpanishFile}"; DestDir: "{app}\dicts\spanish"; Components:dicts\spanish; Flags: ignoreversion recursesubdirs createallsubdirs
; add a new dictionary following the template
;Source: ".\dicts\language_name\*"; DestDir: "{app}\dicts\language_name"; Components:dicts\language_name; Flags: ignoreversion recursesubdirs createallsubdirs

[Icons]
Name: "{group}\Eliot"; Filename: "{app}\eliot.exe";
;Name: "{group}\Eliot"; Filename: "{app}\eliot.exe"; Tasks: startmenufolder
Name: "{commondesktop}\Eliot"; Filename: "{app}\eliot.exe"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\Eliot"; Filename: "{app}\eliot.exe"; Tasks: quicklaunchicon
;Name: "{group}\{cm:ProgramOnTheWeb,{appName}"; Filename: "{#MyAppURL}"
;Name: "{group}\{cm:UninstallProgram,{app}"; Filename: "{uninstallexe}"


[Run]
Filename: "{app}\eliot.exe"; Description: "{cm:LaunchProgram,Eliot}"; Flags: nowait postinstall skipifsilent


[Components]
Name: "main"; Description: "Eliot"; Types: full compact custom; Flags: fixed
Name: "dicts"; Description: "{cm:EliotDictionaries}";Types: full
; english Worldwide
Name: "dicts\english"; Description: {#EnglishDict}; Languages: english; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\english"; Description: {#EnglishDict}; Languages: not english; Types: full; Flags: disablenouninstallwarning
; english North America
Name: "dicts\english2"; Description: {#English2Dict}; Languages: english2; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\english2"; Description: {#English2Dict}; Languages: not english2; Types: full; Flags: disablenouninstallwarning
; catalan
Name: "dicts\catalan"; Description: {#CatalanDict}; Languages: catalan; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\catalan"; Description: {#CatalanDict}; Languages: not catalan; Types: full; Flags: disablenouninstallwarning
; czech
Name: "dicts\czech"; Description: {#CzechDict}; Languages: czech; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\czech"; Description: {#CzechDict}; Languages: not czech; Types: full; Flags: disablenouninstallwarning
;french
Name: "dicts\french"; Description: {#FrenchDict}; Languages: french; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\french"; Description: {#FrenchDict}; Languages: not french; Types: full; Flags: disablenouninstallwarning
; italian
Name: "dicts\italian"; Description: {#ItalianDict}; Languages: italian; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\italian"; Description: {#ItalianDict}; Languages: not italian; Types: full; Flags: disablenouninstallwarning
; malagasy
Name: "dicts\malagasy"; Description: {#MalagasyDict}; Languages: malagasy; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\malagasy"; Description: {#MalagasyDict}; Languages: not malagasy; Types: full; Flags: disablenouninstallwarning
; romanian
Name: "dicts\romanian"; Description: {#RomanianDict}; Languages: romanian; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\romanian"; Description: {#RomanianDict}; Languages: not romanian; Types: full; Flags: disablenouninstallwarning
;serbian
Name: "dicts\serbian"; Description: {#SerbianDict}; Languages: serbian; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\serbian"; Description: {#SerbianDict}; Languages: not serbian; Types: full; Flags: disablenouninstallwarning
;spanish
Name: "dicts\spanish"; Description: {#SpanishDict}; Languages: spanish; Types: full compact; Flags: disablenouninstallwarning
Name: "dicts\spanish"; Description: {#SpanishDict}; Languages: not spanish; Types: full; Flags: disablenouninstallwarning
; add a new dictionary following the template
; language
;Name: "dicts\language_name"; Description: {#LangNameDict}; Languages: language_name; Types: full compact; Flags: disablenouninstallwarning
;Name: "dicts\language_name"; Description: {#LangNameDict}; Languages: not language_name; Types: full; Flags: disablenouninstallwarning


[Code]

// following 3 functions are need to set Compact type as default
function FullInstall(Param : String) : String;
begin
  result := SetupMessage(msgFullInstallation);
end;

function CustomInstall(Param : String) : String;
begin
  result := SetupMessage(msgCustomInstallation);
end;

function CompactInstall(Param : String) : String;
begin
  result := SetupMessage(msgCompactInstallation);
end;
//



/////////////////////////////////////////////////////////////////////
function GetUninstallString(): String;
var
  sUnInstPath: String;
  sUnInstallString: String;
begin
  sUnInstPath := ExpandConstant('Software\Microsoft\Windows\CurrentVersion\Uninstall\{#emit SetupSetting("AppId")}_is1');
  sUnInstallString := '';
  if not RegQueryStringValue(HKLM, sUnInstPath, 'UninstallString', sUnInstallString) then
    RegQueryStringValue(HKCU, sUnInstPath, 'UninstallString', sUnInstallString);
  Result := sUnInstallString;
end;


/////////////////////////////////////////////////////////////////////
function IsUpgrade(): Boolean;
begin
  Result := (GetUninstallString() <> '');
end;


/////////////////////////////////////////////////////////////////////
function UnInstallOldVersion(): Integer;
var
  sUnInstallString: String;
  iResultCode: Integer;
begin
// Return Values:
// 1 - uninstall string is empty
// 2 - error executing the UnInstallString
// 3 - successfully executed the UnInstallString

  // default return value
  Result := 0;

  // get the uninstall string of the old app
  sUnInstallString := GetUninstallString();
  if sUnInstallString <> '' then begin
    sUnInstallString := RemoveQuotes(sUnInstallString);
    if Exec(sUnInstallString, '/SILENT /NORESTART /SUPPRESSMSGBOXES','', SW_HIDE, ewWaitUntilTerminated, iResultCode) then
      Result := 3
    else
      Result := 2;
  end else
    Result := 1;
end;


/////////////////////////////////////////////////////////////////////
function GetDefaultDict(): String;
var
  sDictRegKey: String;
  sDictPath: String;
begin

  sDictRegKey := ExpandConstant('Software\eliot\eliot\Interface');
  sDictPath := '';
  if not RegQueryStringValue(HKCU, sDictRegKey, 'DicPath', sDictPath) then
    RegQueryStringValue(HKLM, sDictRegKey, 'DicPath', sDictPath);
  
  Result := sDictPath;
end;


/////////////////////////////////////////////////////////////////////
function IsDefaultDict(): Boolean;
begin
  Result := (GetDefaultDict() <> '');
end;


/////////////////////////////////////////////////////////////////////
function SetDefaultDict(): Integer;
var
  sSelectedComponents: String;
  tmp: TArrayOfString;
  sSelectedDictPath: String;
  sSelectedDicts: String;
  sDictRegKey: String;
  iResultCode: Integer;
begin
// Return Values:
// 1 - a dict is already set as default
// 2 - error setting the default dict
// 3 - successfully executed the SetDefaultDict

  // default return value
  Result := 0;
  sSelectedComponents := WizardSelectedComponents(False);
  

  if ( CompareText('main,dicts,dicts/', sSelectedComponents) < 0) then
  begin
      // remove 'main,dicts,dicts/' part
      Delete(sSelectedComponents, 1, 17);
      if (Pos (',', sSelectedComponents) = 0) then
      // only one dictionary was selected. Set it as default dictionary
      begin

        RegDeleteValue(HKEY_CURRENT_USER, '{#DicPathRegKey}', 'DicPath');
        RegDeleteValue(HKEY_LOCAL_MACHINE, '{#DicPathRegKey}', 'DicPath');
        if ( sSelectedComponents = 'english') then begin
          sSelectedDictPath := '{#EnglishFile}';
          end
        else if ( sSelectedComponents = 'english2') then begin
          sSelectedDictPath := '{#English2File}';
          end
        else if ( sSelectedComponents = 'catalan') then begin
          sSelectedDictPath := '{#CatalanFile}';
          end
        else if ( sSelectedComponents = 'czech') then begin
          sSelectedDictPath := '{#CzechFile}';
          end
        else if ( sSelectedComponents = 'french') then begin
          sSelectedDictPath := '{#FrenchFile}';
          end
        else if ( sSelectedComponents = 'italian') then begin
          sSelectedDictPath := '{#ItalianFile}';
          end
        else if ( sSelectedComponents = 'malagasy') then begin
          sSelectedDictPath := '{#MalagasyFile}';
          end
        else if ( sSelectedComponents = 'romanian') then begin
          sSelectedDictPath := '{#RomanianFile}';
          end
        else if ( sSelectedComponents = 'serbian') then begin
          sSelectedDictPath := '{#SerbianFile}';
          end
        else if ( sSelectedComponents = 'spanish') then begin
          sSelectedDictPath := '{#SpanishFile}';
          end
        else begin
          sSelectedDictPath := '';
          end;
  
        RegWriteStringValue(HKEY_CURRENT_USER, '{#DicPathRegKey}','DicPath', ExpandConstant('{app}'+ sSelectedDictPath));

      end else
      // two or more dicts was selected. Delete DicPath value because the file is missing
      begin
        RegDeleteValue(HKEY_CURRENT_USER, '{#DicPathRegKey}', 'DicPath');
        RegDeleteValue(HKEY_LOCAL_MACHINE, '{#DicPathRegKey}', 'DicPath'); 
      end;

  end;
  Result := 1;
end;

/////////////////////////////////////////////////////////////////////
procedure CurStepChanged(CurStep: TSetupStep);
var
  sDefaultDict: String;
  
begin
  if (CurStep=ssInstall) then
  begin
    if (IsUpgrade()) then
    begin
      UnInstallOldVersion();
    end;
  end;

  if (CurStep=ssPostInstall) then
  begin
    if ( ( IsDefaultDict = False) or (not FileExists(GetDefaultDict)) ) then
    begin
      // There isn't a default dict or the file doesn't exists.    
      SetDefaultDict();

    end else 
      // There is a default dict and the file exists.
      // Nothing to do.
  
  end;
     
end;



