/*****************************************************************************
 * Eliot
 * Copyright (C) 2005-2009 Olivier Teulière
 * Authors: Olivier Teulière <ipkiss @@ gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *****************************************************************************/

#include "tile.h"
#include "rack.h"
#include "pldrack.h"
#include "round.h"
#include "move.h"
#include "results.h"
#include "board.h"
#include "ai_percent.h"


AIPercent::AIPercent(float iPercent)
{
    if (iPercent < 0)
        iPercent = 0;
    if (iPercent > 1)
        iPercent = 1;

    // Use BestResults to be slightly faster when the percentage is 100%
    if (iPercent == 1)
        m_results = new BestResults;
    else
        m_results = new PercentResults(iPercent);
}


AIPercent::~AIPercent()
{
    delete m_results;
}


void AIPercent::compute(const Dictionary &iDic, const Board &iBoard, bool iFirstWord)
{
    m_results->clear();

    Rack rack;
    getCurrentRack().getRack(rack);
    m_results->search(iDic, iBoard, rack, iFirstWord);
}


Move AIPercent::getMove() const
{
    if (m_results->size() == 0)
    {
        // If there is no result, pass the turn.
        // XXX: it is forbidden in duplicate mode (even passing is forbidden),
        // but well, what else to do?
        return Move(L"");
    }
    else
    {
        return Move(m_results->get(0));
    }
}

