(setq eproc (elim-start))
(setq uname (user-login-name))
(elim-add-account eproc (concat uname "-elim@irc.freenode.net") "prpl-irc" nil)
(elim-connect     eproc (concat uname "-elim@irc.freenode.net"))
(elim-disconnect  eproc (concat uname "-elim@irc.freenode.net"))
(elim-join-chat   eproc (concat uname "-elim@irc.freenode.net") "#emacs" 
                  '("channel" "#emacs"))

(elim-join-chat   eproc (concat uname "-elim@irc.freenode.net") "#elim" 
                  '("channel" "#elim"))

;; you'll need to grab conbversation UIDs from *Messages*
;; accounts can be identified by either uid or name+protocol
(elim-process-send eproc
  (elim-daemon-call 'message nil
    `(alist nil
       (string ((name . "account-name"))
               ,(concat uname "-elim@irc.freenode.net"))
       (string ((name . "im-protocol" )) "prpl-irc" )
       (int    ((name . "conv-uid"    )) "134985920")
       (string ((name . "text"        )) "wootles"  ))))

(elim-process-send eproc
  (elim-daemon-call 'message nil
    `(alist nil
       (string ((name . "account-name")) 
               ,(concat uname "-elim@irc.freenode.net"))
       (string ((name . "conv-name"  )) "#elim")
       (string ((name . "text"       )) 
               ,(read-string "IM> " "" nil "elim-test-string" t)))))

(elim-process-send eproc
  (elim-daemon-call 'enumerations nil `(alist nil)))

(elim-process-send eproc
  (elim-daemon-call 'enumerations nil 
   `(alist nil (string ((name . "enum-type")) ":connection-error"))) )

(elim-process-send eproc
  (elim-daemon-call 'list-accounts nil nil))

(elim-process-send eproc
  (elim-daemon-call 'list-protocols nil nil))


(elim-fetch-process-data eproc 'accounts)
(elim-fetch-process-data eproc 'protocols)

(process-plist eproc)


(progn
  (mapcar 
   (lambda (B) (when B (kill-buffer B)))
   (list (get-buffer "*elim*")
         (get-buffer "*elim-proto*")))
  (setq eproc nil))

(setq eproc (elim-start ))


(elim-list-accounts-response 
      eproc nil nil nil 
      '(("status" . 0) 
        ("value" 
         ("134892792" 
          ("account-name" . "vivek-elim@irc.freenode.net") 
          ("im-protocol"  . "prpl-irc") 
          ("connected") 
          ("account-uid" . 134892792 )))))

(elim-parse-proto-args 
 '(alist nil
         (int   ((name . "status")) "0")
         (alist ((name . "value" )) 
                (string ((name . "a-string")) "sashdksaj")
                (bool   ((name . "true"    )) "1"        )
                (bool   ((name . "false"   )) "0"        )
                (float  ((name . "π"       )) "3.1415"   )
                (int    ((name . "mfeat"             )
                         (type . ":message-flags"    )) "16438")
                (int    ((name . "ctype"             )
                         (type . ":conversation-type")) "3"))))

(elim-enumerations-response nil nil nil nil 
                            (elim-parse-proto-args
 '(alist nil (int ((name . "status")) "0") 
         (alist ((name . "value")) 
                (alist ((name . ":account-request-type")) 
                       (int ((name . "AUTHORIZATION")) "0"))
                (alist ((name . ":blist-node-type"))
                      (int ((name . "GROUP_NODE"   )) "0")
                      (int ((name . "CONTACT_NODE" )) "1")
                      (int ((name . "BUDDY_NODE"   )) "2")
                      (int ((name . "CHAT_NODE"    )) "3")
                      (int ((name . "OTHER_NODE"   )) "4"))
               (alist ((name . ":blist-node-flags"))
                      (int ((name . "NO_SAVE")) "1"))
               (alist ((name . ":certificate-verification-status"))
                      (int ((name . "INVALID" )) "0")
                      (int ((name . "VALID"   )) "1"))
               (alist ((name . ":connection-flags"))
                      (int ((name . "HTML"            )) "1")
                      (int ((name . "NO_BGCOLOR"      )) "2")
                      (int ((name . "AUTO_RESP"       )) "4")
                      (int ((name . "FORMATTING_WBFO" )) "8")
                      (int ((name . "NO_NEWLINES"     )) "16")
                      (int ((name . "NO_FONTSIZE"     )) "32")
                      (int ((name . "NO_URLDESC"      )) "64")
                      (int ((name . "NO_IMAGES"       )) "128"))
               (alist ((name . ":connection-state" ))
                      (int ((name . "DISCONNECTED" )) "0")
                      (int ((name . "CONNECTED"    )) "1")
                      (int ((name . "CONNECTING"   )) "2"))
               (alist ((name . ":connection-error"))
                      (int ((name . "NETWORK_ERROR"             )) "0")
                      (int ((name . "INVALID_USERNAME"          )) "1")
                      (int ((name . "AUTHENTICATION_FAILED"     )) "2")
                      (int ((name . "AUTHENTICATION_IMPOSSIBLE" )) "3")
                      (int ((name . "NO_SSL_SUPPORT"            )) "4")
                      (int ((name . "ENCRYPTION_ERROR"          )) "5")
                      (int ((name . "NAME_IN_USE"               )) "6")
                      (int ((name . "INVALID_SETTINGS"          )) "7")
                      (int ((name . "CERT_NOT_PROVIDED"         )) "8")
                      (int ((name . "CERT_UNTRUSTED"            )) "9")
                      (int ((name . "CERT_EXPIRED"              )) "10")
                      (int ((name . "CERT_NOT_ACTIVATED"        )) "11")
                      (int ((name . "CERT_HOSTNAME_MISMATCH"    )) "12")
                      (int ((name . "CERT_FINGERPRINT_MISMATCH" )) "13")
                      (int ((name . "CERT_SELF_SIGNED"          )) "14")
                      (int ((name . "CERT_OTHER_ERROR"          )) "15")
                      (int ((name . "OTHER_ERROR"               )) "16"))
               (alist ((name . ":conversation-type"))
                      (int ((name . "UNKNOWN")) "0")
                      (int ((name . "IM")) "1")
                      (int ((name . "CHAT")) "2")
                      (int ((name . "MISC")) "3")
                      (int ((name . "ANY")) "4"))
               (alist ((name . ":conv-update-type"))
                      (int ((name . "ADD")) "0")
                      (int ((name . "REMOVE")) "1")
                      (int ((name . "ACCOUNT")) "2")
                      (int ((name . "TYPING")) "3")
                      (int ((name . "UNSEEN")) "4")
                      (int ((name . "LOGGING")) "5")
                      (int ((name . "TOPIC")) "6")
                      (int ((name . "ONLINE")) "7")
                      (int ((name . "OFFLINE")) "8")
                      (int ((name . "AWAY")) "9")
                      (int ((name . "ICON")) "10")
                      (int ((name . "TITLE")) "11")
                      (int ((name . "CHATLEFT")) "12")
                      (int ((name . "FEATURES")) "13"))
               (alist ((name . ":typing-state"))
                      (int ((name . "NOT_TYPING")) "0")
                      (int ((name . "TYPING")) "1")
                      (int ((name . "TYPED")) "2"))
               (alist ((name . ":message-flags"))
                      (int ((name . "SEND")) "1")
                      (int ((name . "RECV")) "2")
                      (int ((name . "SYSTEM")) "4")
                      (int ((name . "AUTO_RESP")) "8")
                      (int ((name . "ACTIVE_ONLY")) "16")
                      (int ((name . "NICK")) "32")
                      (int ((name . "NO_LOG")) "64")
                      (int ((name . "WHISPER")) "128")
                      (int ((name . "ERROR")) "512")
                      (int ((name . "DELAYED")) "1024")
                      (int ((name . "RAW")) "2048")
                      (int ((name . "IMAGES")) "4096")
                      (int ((name . "NOTIFY")) "8192")
                      (int ((name . "NO_LINKIFY")) "16384")
                      (int ((name . "INVISIBLE")) "32768"))
               (alist ((name . ":conv-chat-buddy-flags"))
                      (int ((name . "NONE")) "0")
                      (int ((name . "VOICE")) "1")
                      (int ((name . "HALFOP")) "2")
                      (int ((name . "OP")) "4")
                      (int ((name . "FOUNDER")) "8")
                      (int ((name . "TYPING")) "16"))
               (alist ((name . ":debug-level"))
                      (int ((name . "ALL")) "0")
                      (int ((name . "MISC")) "1")
                      (int ((name . "INFO")) "2")
                      (int ((name . "WARNING")) "3")
                      (int ((name . "ERROR")) "4")
                      (int ((name . "FATAL")) "5"))
               (alist ((name . ":input-condition"))
                      (int ((name . "READ")) "1")
                      (int ((name . "WRITE")) "2"))
               (alist ((name . ":xfer-type"))
                      (int ((name . "UNKNOWN")) "0")
                      (int ((name . "SEND")) "1")
                      (int ((name . "RECEIVE")) "2"))
               (alist ((name . ":xfer-status-type"))
                      (int ((name . "UNKNOWN")) "0")
                      (int ((name . "NOT_STARTED")) "1")
                      (int ((name . "ACCEPTED")) "2")
                      (int ((name . "STARTED")) "3")
                      (int ((name . "DONE")) "4")
                      (int ((name . "CANCEL_LOCAL")) "5")
                      (int ((name . "CANCEL_REMOTE")) "6"))
               (alist ((name . ":log-type"))
                      (int ((name . "IM")) "0")
                      (int ((name . "CHAT")) "1")
                      (int ((name . "SYSTEM")) "2"))
               (alist ((name . ":log-read-flags"))
                      (int ((name . "NO_NEWLINE")) "1"))
               (alist ((name . ":notify-type"))
                      (int ((name . "MESSAGE")) "0")
                      (int ((name . "EMAIL")) "1")
                      (int ((name . "EMAILS")) "2")
                      (int ((name . "FORMATTED")) "3")
                      (int ((name . "SEARCHRESULTS")) "4")
                      (int ((name . "USERINFO")) "5")
                      (int ((name . "URI")) "6"))
               (alist ((name . ":notify-msg-type"))
                      (int ((name . "ERROR")) "0")
                      (int ((name . "WARNING")) "1")
                      (int ((name . "INFO")) "2"))
               (alist ((name . ":notify-search-button-type"))
                      (int ((name . "LABELED")) "0")
                      (int ((name . "CONTINUE")) "1")
                      (int ((name . "ADD")) "2")
                      (int ((name . "INFO")) "3")
                      (int ((name . "IM")) "4")
                      (int ((name . "JOIN")) "5")
                      (int ((name . "INVITE")) "6"))
               (alist ((name . ":notify-user-info-entry-type"))
                      (int ((name . "PAIR")) "0")
                      (int ((name . "SECTION_BREAK")) "1")
                      (int ((name . "SECTION_HEADER")) "2"))
               (alist ((name . ":plugin-type"))
                      (int ((name . "UNKNOWN")) "-1")
                      (int ((name . "STANDARD")) "0")
                      (int ((name . "LOADER")) "1")
                      (int ((name . "PROTOCOL")) "2"))
               (alist ((name . ":string-format-type"))
                      (int ((name . "NONE")) "0")
                      (int ((name . "MULTILINE")) "1")
                      (int ((name . "HTML")) "2"))
               (alist ((name . ":plugin-pref-type"))
                      (int ((name . "NONE")) "0")
                      (int ((name . "CHOICE")) "1")
                      (int ((name . "INFO")) "2")
                      (int ((name . "STRING_FORMAT")) "3"))
               (alist ((name . ":pounce-event"))
                      (int ((name . "NONE")) "0")
                      (int ((name . "SIGNON")) "1")
                      (int ((name . "SIGNOFF")) "2")
                      (int ((name . "AWAY")) "4")
                      (int ((name . "AWAY_RETURN")) "8")
                      (int ((name . "IDLE")) "16")
                      (int ((name . "IDLE_RETURN")) "32")
                      (int ((name . "TYPING")) "64")
                      (int ((name . "TYPED")) "128")
                      (int ((name . "TYPING_STOPPED")) "256")
                      (int ((name . "MESSAGE_RECEIVED")) "512"))
               (alist ((name . ":pounce-option"))
                      (int ((name . "NONE")) "0")
                      (int ((name . "AWAY")) "1"))
               (alist ((name . ":pref-type"))
                      (int ((name . "NONE")) "0")
                      (int ((name . "BOOLEAN")) "1")
                      (int ((name . "INT")) "2")
                      (int ((name . "STRING")) "3")
                      (int ((name . "STRING_LIST")) "4")
                      (int ((name . "PATH")) "5")
                      (int ((name . "PATH_LIST")) "6"))
               (alist ((name . ":privacy-type"))
                      (int ((name . "ALLOW_ALL")) "1")
                      (int ((name . "DENY_ALL")) "2")
                      (int ((name . "ALLOW_USERS")) "3")
                      (int ((name . "DENY_USERS")) "4")
                      (int ((name . "ALLOW_BUDDYLIST")) "5"))
               (alist ((name . ":proxy-type"))
                      (int ((name . "USE_GLOBAL")) "-1")
                      (int ((name . "NONE")) "0")
                      (int ((name . "HTTP")) "1")
                      (int ((name . "SOCKS4")) "2")
                      (int ((name . "SOCKS5")) "3")
                      (int ((name . "USE_ENVVAR")) "4"))
               (alist ((name . ":request-type"))
                      (int ((name . "INPUT")) "0")
                      (int ((name . "CHOICE")) "1")
                      (int ((name . "ACTION")) "2")
                      (int ((name . "FIELDS")) "3")
                      (int ((name . "FILE")) "4")
                      (int ((name . "FOLDER")) "5"))
               (alist ((name . ":request-field-type"))
                      (int ((name . "NONE")) "0")
                      (int ((name . "STRING")) "1")
                      (int ((name . "INTEGER")) "2")
                      (int ((name . "BOOLEAN")) "3")
                      (int ((name . "CHOICE")) "4")
                      (int ((name . "LIST")) "5")
                      (int ((name . "LABEL")) "6")
                      (int ((name . "IMAGE")) "7")
                      (int ((name . "ACCOUNT")) "8"))
               (alist ((name . ":roomlist-room-type"))
                      (int ((name . "CATEGORY")) "1")
                      (int ((name . "ROOM")) "2"))
               (alist ((name . ":roomlist-field-type"))
                      (int ((name . "BOOL")) "0")
                      (int ((name . "INT")) "1")
                      (int ((name . "STRING")) "2"))
               (alist ((name . ":ssl-error-type"))
                      (int ((name . "HANDSHAKE_FAILED")) "1")
                      (int ((name . "CONNECT_FAILED")) "2")
                      (int ((name . "CERTIFICATE_INVALID")) "3"))
               (alist ((name . ":presence-context"))
                      (int ((name . "UNSET")) "0")
                      (int ((name . "ACCOUNT")) "1")
                      (int ((name . "CONV")) "2")
                      (int ((name . "BUDDY")) "3"))
               (alist ((name . ":status-primitive"))
                      (int ((name . "UNSET")) "0")
                      (int ((name . "OFFLINE")) "1")
                      (int ((name . "AVAILABLE")) "2")
                      (int ((name . "UNAVAILABLE")) "3")
                      (int ((name . "INVISIBLE")) "4")
                      (int ((name . "AWAY")) "5")
                      (int ((name . "EXTENDED_AWAY")) "6")
                      (int ((name . "MOBILE")) "7")
                      (int ((name . "TUNE")) "8")
                      (int ((name . "NUM_PRIMITIVES")) "9"))))
)
)

(setq eproc (get-process "*elim*"))
(elim-load-enum-values (get-process "*elim*"))