/*
ecp is designed to copy files, and is named extended cp.
Copyright (C) 2006  Andre Reffhaug <areffhaug@areffhaug.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

ecp homepage   : https://savannah.nongnu.org/projects/ecp/
Contact author : areffhaug@gmail.com
*/

#include <stdbool.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <limits.h>

#define CHUNK 128

#ifdef PATH_MAX
#    define path_max PATH_MAX

#else
#    define path_max 4096

#endif

#define NAME "ecp"
#define AUTHOR "Andre Reffhaug"

/* struct for file sizes */
struct fsize {
    off_t bytes;
    off_t kbytes;
    off_t mbytes;
    off_t gbytes;
};

/* structure for the progress indication */
struct progress {
    float percent;
    int chunk;
    char fname[path_max];
    struct fsize in_total;
    struct fsize total;
};

/* structure holding information on which options the program was 
   invoked with */

struct opt {
  bool information; /* implemented */
  bool recursive; /* implemented */
  bool preserve; /* implemented */
  bool no_zero_bytes; /* implemented */
  bool no_hidden_files; /* implemented */
  bool create; /* implemented, depth 0 */
  bool symlinks; /* implemented */
  bool kill; /* implemented */
  bool quiet; /* implemented */
  bool update; /* half implemented */
  bool hreadable; /* half implemented */
};

/* initializes the progress bar for each file */
void init_progress(struct progress *prog, off_t *bsize, char *dstname);

/* updates progress bar as copying is taking place */
void update_progress(struct progress *prog);

/* prints progress (quite crudely) */
void do_progress(struct progress *prog, struct opt *options);

/* copies infile to outfile */
bool do_copy(char infile[path_max], 
             char outfile[path_max],
             struct opt *options,
             bool todir);

/* walks directories, calling do_copy on each file */
void copy_recursive(char real_src_dir[path_max], char real_target_dir[path_max], 
                    int depth, ino_t orig_inode, struct opt *options);
