/*
 * vstr - a variable length string for C
 * Copyright (C) 2007  Jeffrey Grembecki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __VSTR_H
#define __VSTR_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
	unsigned _private_buffersize;

	char *s;
	unsigned len;
} vstr;

vstr* vs_new();
void vs_free(vstr *p_vs);
int vs_print(vstr *p_vs, const char *p_format, ...);
int vs_cat(vstr *p_vs, const char *p_format, ...);
int vs_copy(vstr *p_dest, vstr *p_source);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __VSTR_H */
