/*
 * dvdspanky - a video to DVD MPEG conversion frontend for transcode
 * Copyright (C) 2007  Jeffrey Grembecki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __DVDSPANKY_H
#define __DVDSPANKY_H

#define SPANK_FIRST     0x1
#define SPANK_SECOND    0x2
#define SPANK_MULTI     0x3
#define SPANK_NONICE    0x4
#define SPANK_FIXNTSC   0x8
#define SPANK_AVPASS    0x10
#define SPANK_SPEED     0x20
#define SPANK_DOUBLEFPS 0x40
#define SPANK_MULTIPLEX 0x80
#define SPANK_MPLAYER   0x100
#define SPANK_PREVIEW   0x200
#define SPANK_NORMALISE 0x400
#define SPANK_PPROCESS  0x800
#define SPANK_AVOLUME   0x1000
#define SPANK_HARDFPS   0x2000
#define SPANK_DVD		0x4000
#define SPANK_DEINTER   0x8000
#define SPANK_NOUNLINK  0x10000
#define SPANK_MASK      0xffffffff

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include "forkit.h"

typedef struct {
	int width, height, vrate;
	int hz, abits, achans, arate;
	int frames, length, hours, minutes, seconds;
	int vcrop, hcrop;
	char p_vcodec[20], p_acodec[10], p_filename[512];
	double aspect, fps, gamma, volume;
	int feedback;
	int title;
	unsigned bytes;
} video_t;

void initvideo(video_t *p_video);
int cb_default(const char *p_string, void *p_options);
int cb_sox(const char *p_string, void *p_options);
int cb_ffmpeg(const char *p_string, void *p_options);
int cb_tcprobe(const char *p_string, void *p_options);
int cb_transcode(const char *p_string, void *p_options);
int cb_mplayer(const char *p_string, void *p_options);
int encode(video_t *p_in, video_t *p_out, uint32_t options, const char *p_filters);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __DVDSPANKY_H */

