#ifndef __DVDSPANKY_H
#define __DVDSPANKY_H

#define SPANK_FIRST 	0x1
#define SPANK_SECOND	0x2
#define SPANK_MULTI 	0x3
#define SPANK_NONICE	0x4
#define SPANK_FIXNTSC	0x8
#define SPANK_VERBOSE	0x10
#define SPANK_NEWFPS	0x20
#define SPANK_DOUBLEFPS 0x40
#define SPANK_MULTIPLEX	0x80
#define SPANK_MPLAYER   0x100
#define SPANK_PREVIEW   0x200

typedef struct {
	int width, height, vrate;
	int hz, abits, achans, arate;
	int frames, length, hours, minutes, seconds;
	int vcrop, hcrop;
	char p_vcodec[20], p_acodec[10], p_filename[512];
	float aspect, fps;
	int options, feedback;
} video_t;

typedef int (*forkitcallback)(const char *p_parsestring, void *p_options);

void initvideo(video_t *p_video);
int cb_tcprobe(const char *p_string, void *p_options);
int cb_transcode(const char *p_string, void *p_options);
int cb_mplayer(const char *p_string, void *p_options);
int forkit(forkitcallback callback, void *p_options, const char *p_path, const char *p_cmd);
int forkitf(forkitcallback callback, void *p_options, const char *p_path, const char *p_cmd, ...);
int encode(video_t *p_in, video_t *p_out, int options, const char *p_filters);
void cleanup();

#endif /* __DVDSPANKY_H */

