#file: new_game.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#This file creates a new character.
#Either call directly (which will use the first module seen), or
#call from rpg.py after setting g.mod_directory.

from Tkinter import *
#needed for the buttons.
import ImageTk
import Image

import g

from player import *

import main
import loadgame

#main stats for character. Taken from g.hp etc.
global name_stat
global hp_stat
global ep_stat
global attack_stat
global defense_stat
global gold_stat

help_text = StringVar()

#distance from the top of the button canvas each button should be placed.
#Values are added in init_window. begin is not needed; always zero.
reroll_height = 0
load_height = 0
quit_height = 0

#currently selected button. 0=New, 1=Load, 2=Quit, 3=None,
#4=Start, 5=Rename, 6=Reroll, 7=Back, 8=None
cur_button = 0

already_started_game = 0

curr_name_loc = -1

#give new stats for the character. Called when pressing the
#"Reroll stats" button.
def reroll_stats():
	#player.name = "Alfred"
	#name.get()

	#actual re-rolling
	global name_stat
	global hp_stat
	global ep_stat
	global attack_stat
	global defense_stat
	global gold_stat
	hp_stat = g.die_roll(g.new_game_dice[0][0], g.new_game_dice[0][1]) + \
		g.new_game_dice[0][2]
	ep_stat = g.die_roll(g.new_game_dice[1][0], g.new_game_dice[1][1]) + \
		g.new_game_dice[1][2]
	attack_stat = g.die_roll(g.new_game_dice[2][0], g.new_game_dice[2][1]) + \
		g.new_game_dice[2][2]
	defense_stat = g.die_roll(g.new_game_dice[3][0], g.new_game_dice[3][1]) + \
		g.new_game_dice[3][2]
	gold_stat = g.die_roll(g.new_game_dice[4][0], g.new_game_dice[4][1]) + \
		g.new_game_dice[4][2]

	main.canvas_map.itemconfigure("name", text=g.name_name+": "+ name_stat)
	main.canvas_map.itemconfigure("hp", text=g.hp_name+": "+str(hp_stat))
	main.canvas_map.itemconfigure("ep", text=g.ep_name+": "+str(ep_stat))
	main.canvas_map.itemconfigure("attack", text=g.attack_name+": "+str(attack_stat))
	main.canvas_map.itemconfigure("defense", text=g.defense_name+": "+str(defense_stat))
	main.canvas_map.itemconfigure("gold", text=g.gold_name+": "+str(gold_stat))

	reset_vars()

def rename_character():
	unbind_all()
	g.window_main.unbind("<ButtonRelease-1>")
	g.window_main.unbind("<Motion>")

	g.window_main.bind("<Key>", adjust_name)
	g.window_main.bind("<BackSpace>", backspace_name)
	g.window_main.bind("<Home>", name_home)
	g.window_main.bind("<End>", name_end)
	g.window_main.bind(g.binding_action, enter_name)
	g.window_main.bind(g.binding_cancel, enter_name)
	g.window_main.bind(g.binding_left, name_left)
	g.window_main.bind(g.binding_right, name_right)
	global curr_name_loc
	curr_name_loc = len(name_stat)
	main.canvas_map.itemconfigure("name", text=g.name_name+": "+
				name_stat[:curr_name_loc]+"_"+name_stat[curr_name_loc:])


def adjust_name(event=0):
	usable_chars = "`~!@#$%^&*()-_=+\|[{]};:'\",<.>/? "
	if event==0: return
	c = event.char
	if c == "": return
	if c.isalnum() == 0:
		if usable_chars.find(c) == -1: return
	global name_stat
	global curr_name_loc
	name_stat = name_stat[:curr_name_loc]+event.char+name_stat[curr_name_loc:]
	curr_name_loc += 1
	main.canvas_map.itemconfigure("name", text=g.name_name+": "+
				name_stat[:curr_name_loc]+"_"+name_stat[curr_name_loc:])

def backspace_name(event=0):
	global name_stat
	global curr_name_loc
	name_stat = name_stat[:curr_name_loc-1]+name_stat[curr_name_loc:]
# 	canvas_map.itemconfigure("name", text=g.name_name+": "+ name_stat)
	curr_name_loc -= 1
	if curr_name_loc < 0: curr_name_loc = 0
	main.canvas_map.itemconfigure("name", text=g.name_name+": "+
				name_stat[:curr_name_loc]+"_"+name_stat[curr_name_loc:])

def enter_name(event=0):
	g.window_main.unbind("<Key>")
	g.window_main.unbind("<BackSpace>")
	g.window_main.unbind("<Return>")
	main.canvas_map.itemconfigure("name", text=g.name_name+": "+ name_stat)
	new_game_bind()

def name_left(event=0):
	global curr_name_loc
	curr_name_loc -= 1
	if curr_name_loc < 0: curr_name_loc = 0
	main.canvas_map.itemconfigure("name", text=g.name_name+": "+
				name_stat[:curr_name_loc]+"_"+name_stat[curr_name_loc:])

def name_right(event=0):
	global curr_name_loc
	curr_name_loc += 1
	if curr_name_loc > len(name_stat): curr_name_loc = len(name_stat)
	main.canvas_map.itemconfigure("name", text=g.name_name+": "+
				name_stat[:curr_name_loc]+"_"+name_stat[curr_name_loc:])

def name_home(event=0):
	global curr_name_loc
	curr_name_loc = 0
	main.canvas_map.itemconfigure("name", text=g.name_name+": "+
				name_stat[:curr_name_loc]+"_"+name_stat[curr_name_loc:])

def name_end(event=0):
	global curr_name_loc
	curr_name_loc = len(name_stat)
	main.canvas_map.itemconfigure("name", text=g.name_name+": "+
				name_stat[:curr_name_loc]+"_"+name_stat[curr_name_loc:])

#call to reset the game
def reset_vars():
	#move variables to player.*
	player.maxhp = int(hp_stat)
	player.maxep = int(ep_stat)
	player.attack = int(attack_stat)
	player.defense = int(defense_stat)
	player.gold = int(gold_stat)

	player.exp = 0
	player.level = 0
	player.skillpoints = 0
	player.hp = player.maxhp
	player.ep = player.maxep

	#place the player
	g.xgrid = 0
	g.ygrid= 0
	g.zgrid = 0

	timestep = 0
	cur_mon_hp = 0
	g.var_list = {}
	g.item.dropped_items = []

	#clear the inventory
	for i in range(len(g.item.inv)):
		g.item.inv[i]= -1
	for i in range(len(player.equip)):
		player.equip[i]= -1
	#clear skills
	for i in range(len(player.skill)):
		player.skill[i][5] = 0
	global new_game
	new_game = 1


#get stats from g.*
def get_stats():
	global name_stat
	global hp_stat
	global ep_stat
	global attack_stat
	global defense_stat
	global gold_stat
	name_stat = player.name
	hp_stat = player.hp
	ep_stat = player.ep
	attack_stat = player.attack
	defense_stat = player.defense
	gold_stat = player.gold


#Use the stats given to create a new character.
def begin_game():
	#This prevents a race condition
	global already_started_game
	if already_started_game == 1: return 0
	already_started_game = 1

	main.canvas_map.create_rectangle(g.tilesize*main.mapsizex/4,
		g.tilesize*main.mapsizey/3, g.tilesize*main.mapsizex*3/4,
		g.tilesize*main.mapsizey*2/3, fill="#e3e3e3", tags="newgame")
	main.canvas_map.create_text(g.tilesize*main.mapsizex/2,
		g.tilesize*main.mapsizey/2,
		text="Starting game. Please wait", tags="newgame")
	g.window_main.update_idletasks()

	g.read_maps()
	g.item.load_dropped_items()

	#just in case someone changed the name
	#after rerolling or loading
	global name_stat
	player.name = name_stat
	#name.get()

	if player.name == "":
		player.name = "Nameless"
	#bring the main window up.
#	window_new_game.withdraw()
	main.init_window_main(new_game)
	already_started_game = 0
# 	try:
# 		if window_new_game.winfo_exists():
# 			window_new_game.deiconify()
# 	except TclError:
# 		pass

	#after returning to this screen, reset everything.
#	reroll_stats()

def load_game():
	unbind_all()
	g.window_main.unbind("<ButtonRelease-1>")
	g.window_main.unbind("<Motion>")
	#bring the loadgame window up.
#	window_new_game.withdraw()
	global new_game
	load_game = 0
	load_game = loadgame.init_window_loadgame(main.canvas_map)
	if load_game == 1:
		new_game = 0
	new_game_bind()
	get_stats()
	if load_game == 1:
		begin_game()

def quit_game():
	g.window_main.destroy()

#refresh the buttons.
def refresh_buttons():
	if g.window_main.winfo_exists() == 0: return
	if cur_button > 3:
		if (cur_button == 4):
			main.canvas_map.itemconfigure("inner_begin", image=g.buttons["begin_sel.png"])
			main.canvas_map.itemconfigure("help_text", text="Begin a new game")
		else:
			main.canvas_map.itemconfigure("inner_begin", image=g.buttons["begin.png"])
		if (cur_button == 5):
			main.canvas_map.itemconfigure("inner_rename", image=g.buttons["skill_sel.png"])
			main.canvas_map.itemconfigure("help_text", text="Change your name")
		else:
			main.canvas_map.itemconfigure("inner_rename", image=g.buttons["skill.png"])
		if (cur_button == 6):
			main.canvas_map.itemconfigure("inner_reroll", image=g.buttons["reroll_sel.png"])
			main.canvas_map.itemconfigure("help_text", text="Reroll your statistics")
		else:
			main.canvas_map.itemconfigure("inner_reroll", image=g.buttons["reroll.png"])
		if (cur_button == 7):
			main.canvas_map.itemconfigure("inner_quit", image=g.buttons["leave_sel.png"])
			main.canvas_map.itemconfigure("help_text", text="Back to the main menu")
		else:
			main.canvas_map.itemconfigure("inner_quit", image=g.buttons["leave.png"])
		if (cur_button == 8):
			main.canvas_map.itemconfigure("help_text", text="")

	else:
		if (cur_button == 0):
			main.canvas_map.itemconfigure("begin", image=g.buttons["begin_sel.png"])
			main.canvas_map.itemconfigure("help_text", text="Create a new character")
		else:
			main.canvas_map.itemconfigure("begin", image=g.buttons["begin.png"])
		if (cur_button == 1):
			main.canvas_map.itemconfigure("load", image=g.buttons["load_sel.png"])
			main.canvas_map.itemconfigure("help_text", text="Load an old game")
		else:
			main.canvas_map.itemconfigure("load", image=g.buttons["load.png"])
		if (cur_button == 2):
			main.canvas_map.itemconfigure("quit", image=g.buttons["quit_sel.png"])
			main.canvas_map.itemconfigure("help_text", text="Quit the game")
		else:
			main.canvas_map.itemconfigure("quit", image=g.buttons["quit.png"])
		if (cur_button == 3):
			main.canvas_map.itemconfigure("help_text", text="")
def refresh_stats():
	pass


#All keypresses in window_shop pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(key_name):
	global cur_button
	if (key_name == "esc"):
		if cur_button > 3:
			back_from_new_game()
			return
		else:
			quit_game()
			return
	elif (key_name == "up" or key_name == "left"):
		if cur_button == 0: cur_button = 3
		if cur_button == 4: cur_button = 8
		cur_button -= 1
	elif (key_name == "down" or key_name == "right"):
		if cur_button == 3 or cur_button == 2: cur_button = -1
		if cur_button == 7 or cur_button == 8: cur_button = 3
		cur_button += 1
	elif (key_name == "return"):
		if   (cur_button == 0): init_new_game()
		elif (cur_button == 1): load_game()
		elif (cur_button == 2):
			quit_game()
			return
		elif (cur_button == 4): begin_game()
		elif (cur_button == 5): rename_character()
		elif (cur_button == 6): reroll_stats()
		elif (cur_button == 7):
			back_from_new_game()
			return

	refresh_buttons()


def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")


def mouse_handler_click(event=0):
	key_handler("return")

def mouse_handler_move(event=0):
	global cur_button
	if cur_button > 3:
		if (event.y < inner_button_start or
				event.y > inner_button_height + inner_button_start or
				event.x < inner_new_game_width):
			cur_button = 8
		else:
			if (event.x < inner_rename_width): cur_button = 4
			elif (event.x < inner_reroll_width): cur_button = 5
			elif (event.x < inner_quit_width): cur_button = 6
			elif (event.x < inner_final_width): cur_button = 7
			else: cur_button = 8
	else:
		if (event.y < button_start or event.y > button_height + button_start or
			event.x < new_game_width):
			cur_button = 3
		else:
			if (event.x < load_width): cur_button = 0
			elif (event.x < quit_width): cur_button = 1
			elif (event.x < final_width): cur_button = 2
			else: cur_button = 3
	refresh_buttons()

#Called when newgame is pressed on the main menu.
def init_new_game():
	main.canvas_map.create_rectangle(g.tilesize*main.mapsizex/4,
		g.tilesize*main.mapsizey/3, g.tilesize*main.mapsizex*3/4,
		g.tilesize*main.mapsizey*2/3, fill="#e3e3e3", tags="newgame")

	global inner_button_start
	inner_button_start = g.tilesize*main.mapsizey*2/3-g.buttons["begin.png"].height()
	global inner_button_height
	inner_button_height = g.buttons["begin.png"].height()
	global inner_new_game_width
	global inner_rename_width
	global inner_reroll_width
	global inner_quit_width
	global inner_final_width
	inner_new_game_width = g.tilesize*main.mapsizex/2 - \
		g.buttons["begin.png"].width() - g.buttons["skill.png"].width()
	inner_rename_width = inner_new_game_width + g.buttons["begin.png"].width()
	inner_reroll_width = inner_rename_width + g.buttons["skill.png"].width()
	inner_quit_width = inner_reroll_width + g.buttons["reroll.png"].width()
	inner_final_width = inner_quit_width + g.buttons["leave.png"].width()


	main.canvas_map.create_image(inner_new_game_width, inner_button_start, anchor=NW,
				image=g.buttons["begin.png"], tags=("inner_begin", "newgame"))
	main.canvas_map.create_image(inner_rename_width, inner_button_start, anchor=NW,
				image=g.buttons["skill.png"], tags=("inner_rename", "newgame"))
	main.canvas_map.create_image(inner_reroll_width, inner_button_start, anchor=NW,
				image=g.buttons["reroll.png"], tags=("inner_reroll", "newgame"))
	main.canvas_map.create_image(inner_quit_width, inner_button_start, anchor=NW,
				image=g.buttons["leave.png"], tags=("inner_quit", "newgame"))
	global cur_button
	cur_button = 4

	main.canvas_map.create_text(g.tilesize*main.mapsizex/4+10,
		g.tilesize*main.mapsizey/3+10, anchor=NW, tags=("newgame", "name"),
		text=g.name_name+": "+ name_stat)
	main.canvas_map.create_text(g.tilesize*main.mapsizex/4+10,
		g.tilesize*main.mapsizey/3+25, anchor=NW, tags=("newgame", "hp"),
		text=g.hp_name+": "+ str(hp_stat))
	main.canvas_map.create_text(g.tilesize*main.mapsizex/4+10,
		g.tilesize*main.mapsizey/3+40, anchor=NW, tags=("newgame", "ep"),
		text=g.ep_name+": "+ str(ep_stat))
	main.canvas_map.create_text(g.tilesize*main.mapsizex/4+10,
		g.tilesize*main.mapsizey/3+55, anchor=NW, tags=("newgame", "attack"),
		text=g.attack_name+": "+ str(attack_stat))
	main.canvas_map.create_text(g.tilesize*main.mapsizex/4+10,
		g.tilesize*main.mapsizey/3+70, anchor=NW, tags=("newgame", "defense"),
		text=g.defense_name+": "+ str(defense_stat))
	main.canvas_map.create_text(g.tilesize*main.mapsizex/4+10,
		g.tilesize*main.mapsizey/3+85, anchor=NW, tags=("newgame", "gold"),
		text=g.gold_name+": "+ str(gold_stat))


def back_from_new_game():
	main.canvas_map.delete("newgame")
	global cur_button
	cur_button = 0
	refresh_buttons()

#called upon game start
def init_window():
	#global g.window_main
#	g.window_main = Toplevel()
	g.window_main.title(g.game_name)
# 	g.window_main.resizable(0, 0)
# 	g.window_main.maxsize(1000, 1000)
# 	g.window_main.wm_geometry("+%d+%d" % (20, 20))
# 	g.window_main.protocol("WM_DELETE_WINDOW", main.cleanup)

	global bgcolour
	bgcolour="lightgrey"

#	global canvas_map
# 	main.canvas_map = Canvas(g.window_main, width=g.tilesize*main.mapsizex,
# 		height=g.tilesize*main.mapsizey, highlightthickness=0)
# 	main.canvas_map.grid(column=0, row=0)
	main.canvas_map.delete(ALL)
	main.canvas_map.create_image(0, 0, image=g.backgrounds["new_game.png"], anchor=NW)

	global name_stat
	name_stat = g.default_player_name

	#button coords
	global button_start
	button_start = 388
	global button_height
	button_height = g.buttons["begin.png"].height()
	global new_game_width
	global load_width
	global quit_width
	global final_width
	new_game_width = g.tilesize*main.mapsizex/2 - \
		g.buttons["begin.png"].width() - g.buttons["load.png"].width()/2
	load_width = new_game_width + g.buttons["begin.png"].width()
	quit_width = load_width + g.buttons["load.png"].width()
	final_width = quit_width + g.buttons["quit.png"].width()


	main.canvas_map.create_image(new_game_width, button_start, anchor=NW,
							image=g.buttons["begin.png"], tags="begin")
	main.canvas_map.create_image(load_width, button_start, anchor=NW,
							image=g.buttons["load.png"], tags="load")
	main.canvas_map.create_image(quit_width, button_start, anchor=NW,
							image=g.buttons["quit.png"], tags="quit")

	main.canvas_map.create_text(15, button_start+button_height/2, anchor=W,
		text="", tags="help_text", fill="#ffffff")

	global cur_button
	cur_button = 0
#
# 	#Canvas for buttons
# 	global canvas_buttons
# 	canvas_buttons = Canvas(new_game, width=g.buttons["begin.png"].width(),
# 		bg="#d3d3d3", height=quit_height +
# 		g.buttons["quit.png"].height(), highlightthickness=0)
# 	canvas_buttons.grid(column=1, row=1, rowspan=20, sticky=N+W+E)
#
# 	entry_name.focus_set()
	refresh_buttons()
#
# 	#give basic values.
	reroll_stats()


	#bindings
	new_game_bind()

	g.window_main.master.wait_window(g.window_main)

def unbind_all():
	if g.window_main.winfo_exists() == 0: return
	g.window_main.unbind(g.binding_cancel)
	g.window_main.unbind(g.binding_action)
	g.window_main.unbind(g.binding_up)
	g.window_main.unbind(g.binding_down)
	g.window_main.unbind(g.binding_left)
	g.window_main.unbind(g.binding_right)

def new_game_bind():
	if g.window_main.winfo_exists() == 0: return
	g.window_main.bind(g.binding_cancel, key_handler_esc)
	g.window_main.bind(g.binding_action, key_handler_return)
	g.window_main.bind(g.binding_up, key_handler_up)
	g.window_main.bind(g.binding_down, key_handler_down)
	g.window_main.bind(g.binding_left, key_handler_left)
	g.window_main.bind(g.binding_right, key_handler_right)
	g.window_main.bind("<ButtonRelease-1>", mouse_handler_click)
	g.window_main.bind("<Motion>", mouse_handler_move)
	g.window_main.unbind("<Double-Button-1>")

