#file: main.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#This file controls the wilderness and dungeon.

from Tkinter import *
#needed for the tiles.
import ImageTk
import Image
#needed for random battles
from random import random
#needed for dialog boxes
import tkMessageBox

import tkFont

#needed for benchmarking. Uncomment to use.
#from time import clock

#local imports.
import g
import inv
import battle
import shop
import action
import new_game

from player import *

#size, in tiles, of the main screen. While this is adjustable,
#odd numbers would work much better. (To keep the player centered.)
mapsizex = 23
mapsizey = 17

width = 20
tilesize = 32
iconsize = 20

bold_font = tkFont.Font ( family="Helvetica", size=10, weight="bold" )
msg_font = tkFont.Font ( family="Helvetica", size=10, weight="bold" )

#division is nasty. Only do it once. Used for centering items on the player.
half_mapx = mapsizex/2
half_mapy = mapsizey/2

#used for yes/no dialog boxes.
active_button = 0
return_from_yesno = StringVar()
return_from_popup = StringVar()

#used to prevent drawing problems.
global already_refreshed
already_refreshed = 0

#max number of messages to keep.
max_messages = 25

#number of free moves after attack left.
global free_move


name = StringVar()
hp = StringVar()
ep = StringVar()
attack = StringVar()
defense = StringVar()
gold = StringVar()
exp = StringVar()
level = StringVar()

#Image used for the inventory icon.
inv_icon_image = "inv.png"
quit_icon_image = "quit.png"
save_icon_image = "save.png"
scroller_icon_image = "scroller.png"

global message_array
message_array = []
global curr_message_num
curr_message_num = 0

#Print a message in status box. Works with ~Action~ embedded commands.
def print_message(message):
	global curr_message_num
	global message_array
	curr_message_num += 1
	if curr_message_num > 5: curr_message_num -= 6
	try:
		if g.window_main.state() != "normal":
			return 0
		message = action.interpret_line(message)
		message_array.append(message)

		canvas_map.move("message_scroll", 0, -15)
		canvas_map.delete("num"+str(curr_message_num))
		canvas_map.create_text(3, mapsizey*tilesize,
			text=message, anchor=SW,
			tags=("message_scroll", "num"+str(curr_message_num)))

		while len(message_array) > max_messages:
			message_array.pop(0)
		return 1
	except NameError:
		return 0

#save game
def save_game(event=0):
	if action.has_dialog == 1: return 0
	g.savegame(player.name)
	print_message("** Game Saved **");

#determine if the player is dead, and, if so, end the game.
def dead_yet():
	#did you die?
	if player.hp <= 0:
		action.run_command(g.xgrid, g.ygrid, g.zgrid, "die()")
		return 1
	return 0

#back to main menu. Called on death.
def close_window(event=0):
	if action.has_dialog == 1: return
	if player.hp < 1:
		try:
			cleanup()
			g.window_main.destroy()
		except TclError:
			pass
	elif show_yesno("Leave this game?", 0):
		try:
			cleanup()
			g.window_main.destroy()
		except TclError:
			pass



#Activate any scripting associated with a tile. X and Y are absolute coords.
#Assumes scripting stored in maps[zgrid].field[y][x].actions[]
def activate_scripting(x, y, z):
	return_num = 0
	temp_zgrid = z

	#Make sure this is a "real" tile:
	if(z < 0 or x < 0 or y < 0 or z >= len(g.maps) or
	y >= len(g.maps[g.zgrid].field) or x >= len(g.maps[g.zgrid].field[y])):
		return

	itemnum = 0
	while itemnum < len(g.maps[g.zgrid].field[y][x].items):
		itemname = g.maps[g.zgrid].field[y][x].items[itemnum]
		if action.run_command(x, y, z, "find(\"" + itemname + "\", \"a\")"):
			g.maps[g.zgrid].del_item(itemname, x, y)
			refresh_tile(x, y)
			refresh_inv_icon()
			refresh_bars()
		else: itemnum += 1

	#if there are no actions, leave immediately
	if len(g.maps[temp_zgrid].field[y][x].actions) == 0: return

	#go through all action lines.
	action.activate_lines(x, y, temp_zgrid,
					g.maps[temp_zgrid].field[y][x].actions)


#redraws the main map. Call after moving.
def refreshmap():
	#redraw the tiles
	for x in range(mapsizex):
		for y in range(mapsizey):
			refresh_tile(g.xgrid - half_mapx + x, g.ygrid - half_mapy + y)

	refreshhero()
	refresh_inv_icon()
	refresh_bars()
	recalc_stats()

#refreshes the inventory icon in the upper-left.
def refresh_inv_icon(redisplay=0):
	canvas_map.lift("inv_icon")
	canvas_map.lift("quit_icon")
	canvas_map.lift("save_icon")


	if redisplay == 1:
		canvas_map.itemconfigure("inv_icon", image=g.icons[inv_icon_image])
		canvas_map.itemconfigure("quit_icon", image=g.icons[quit_icon_image])
		canvas_map.itemconfigure("save_icon", image=g.icons[save_icon_image])
		canvas_map.itemconfigure("scroller_icon",
					image=g.buttons[scroller_icon_image])
	canvas_map.lift("status_rect")
	canvas_map.lift("info_rect")
	canvas_map.lift("message_scroll")
	canvas_map.lift("scroller_icon")

	info_top_x = mapsizex*tilesize-3*iconsize
	info_top_y = mapsizey*tilesize-7*iconsize
	info_bottom_x = mapsizex*tilesize
	info_bottom_y = mapsizey*tilesize-iconsize

	canvas_map.itemconfigure("info_attack", text=str(player.adj_attack))
	canvas_map.itemconfigure("info_defense", text=str(player.adj_defense))
	canvas_map.itemconfigure("info_gold", text=str(player.gold))
	canvas_map.itemconfigure("info_level", text=str(player.level))
	canvas_map.itemconfigure("info_exp", text=str(player.exp))


def refresh_bars():
	canvas_map.delete("point_bars")

	start_height = mapsizey*tilesize-7*iconsize-12
	start_width = iconsize*3

	bar_x = mapsizex*tilesize-3*iconsize

	canvas_map.create_rectangle(bar_x, start_height, bar_x+start_width, start_height+5,
				fill="#EE0505", tags="point_bars")
	hpbar_width=start_width*player.hp/player.adj_maxhp
	canvas_map.create_rectangle(bar_x, start_height,bar_x+hpbar_width, start_height+5,
				fill="#05BB05", tags="point_bars")

	canvas_map.create_rectangle(bar_x, start_height+6,bar_x+start_width, start_height+11,
				fill="#EE0505", tags="point_bars")
	epbar_width=start_width*player.ep/player.adj_maxep

	canvas_map.create_rectangle(bar_x, start_height+6,bar_x+epbar_width, start_height+11,
				fill="#0505EE", tags="point_bars")


#given x and y (absolute coods.) refresh the given tile.
def refresh_tile(x, y):
	search_for = str(x)+"."+str(y)
	canvas_map.delete(search_for)
	for picture in findtile(x, y):
		canvas_map.create_image((x-g.xgrid + half_mapx)*g.tilesize,
		(y-g.ygrid + half_mapy)*g.tilesize, anchor=NW,
		image=picture, tags=(str(x)+"."+str(y), "tilepix"))

#refreshs the hero; faster than refreshing the whole map.
def refreshhero():
	canvas_map.delete("hero")
	canvas_map.create_image(mapsizex*g.tilesize/2, mapsizey*g.tilesize/2,
		image=g.tiles[player.cur_hero], tags="hero")
	for picture in g.maps[g.zgrid].field[g.ygrid][g.xgrid].addoverpix:
		canvas_map.create_image(mapsizex*g.tilesize/2, mapsizey*g.tilesize/2,
					image=picture, tags="hero")

#called to process the onload portion of a level. Called whenever entering
#a level. Set g.zgrid properly before calling.
def process_onload():
	for y in range(len(g.maps[g.zgrid].field)):
		for x in range(len(g.maps[g.zgrid].field[y])):
			action.activate_lines(x, y, g.zgrid,
							g.maps[g.zgrid].field[y][x].onload)
			if dead_yet() == 1: break

#re-display stats.
def recalc_stats():
	refresh_bars()

#Return an array of pictures that the given tile should display.
#x and y are absolute coords.
def findtile(x, y):

	returnpix = []
	#If dealing with an off-map area, grab the nearest known tile.
	if x < 0: x = 0
	if y < 0: y = 0
	if y >= len(g.maps[g.zgrid].field): y = len(g.maps[g.zgrid].field) -1
	if x >= len(g.maps[g.zgrid].field[y]): x = len(g.maps[g.zgrid].field[y]) -1
	try:
		#This should not (normally) fail.
		returnpix.append(g.maps[g.zgrid].field[y][x].pix)
		for picture in g.maps[g.zgrid].field[y][x].addpix:
			returnpix.append(picture)
		for picture in g.maps[g.zgrid].field[y][x].addoverpix:
			returnpix.append(picture)
		for itemname in g.maps[g.zgrid].field[y][x].items:
			returnpix.append(
				g.tiles[g.item.item[g.item.finditem(itemname)].picturename])
		return returnpix
	except IndexError:
		#If it fails, there is rock there.
		returnpix.append(g.maps[g.zgrid].field[0][0].pix)
		return returnpix
	except KeyError:
		#if the author forgot to define the tile, point out the mistake.
		print "Tile of " + g.maps[g.zgrid].field[y][x].name + " is not defined" \
			+ " in map " + g.maps[g.zgrid].name
		returnpix.append(g.maps[g.zgrid].field[0][0].pix)
		return returnpix


#movement commands. Check to see if window_main is visible, and if there is no
#dialog box showing, then if travel is possible to a spot, move there.
#requires the change in xy coordinates. Called with move_north and the like.
def move_hero(x, y):
	try:
		tempy = g.ygrid + y
		tempx = g.xgrid + x

		#check for either the main window not existing, or a current dialog
		if g.window_main.state() != "normal" or action.has_dialog == 1:
			return
		#tempclock = clock()
		#check for any objects of interest. Called before moving, in case
		#the scripting changes the walkable status.
		activate_scripting(tempx, tempy, g.zgrid)

		if g.iswalkable(tempx, tempy, x, y):
			if g.allow_move == 1:
				g.xgrid=g.xgrid + x
				g.ygrid=g.ygrid + y
				passturn()
				if g.allow_change_hero == 1:
					if y == -1: player.cur_hero = "people/hero_n" + \
							g.maps[g.zgrid].hero_suffix + ".png"
					if y ==  1: player.cur_hero = "people/hero_s" + \
							g.maps[g.zgrid].hero_suffix + ".png"
					if x == -1: player.cur_hero = "people/hero_w" + \
							g.maps[g.zgrid].hero_suffix + ".png"
					if x ==  1: player.cur_hero = "people/hero_e" + \
							g.maps[g.zgrid].hero_suffix + ".png"
				g.allow_change_hero = 1
				#Sometimes, quick refresh is bad.
				global already_refreshed
				if already_refreshed == 1:
					refreshhero()
					already_refreshed = 0
					#print clock() - tempclock
					return

				#quick refresh.
				#Moves the canvas over a bit
				canvas_map.move("tilepix", -x*tilesize, -y*tilesize)

				#Refreshes the new part.
				refreshhero()
				recalc_stats()
				g.allow_move = 1
				if y == -1:
					for tilenum in range(mapsizex):
						refresh_tile(g.xgrid-half_mapx+tilenum, g.ygrid-half_mapy)
				if y ==  1:
					for tilenum in range(mapsizex):
						refresh_tile(g.xgrid-half_mapx+tilenum, g.ygrid+half_mapy)
				if x == -1:
					for tilenum in range(mapsizey):
						refresh_tile(g.xgrid-half_mapx, g.ygrid-half_mapy+tilenum)
				if x ==  1:
					for tilenum in range(mapsizey):
						refresh_tile(g.xgrid+half_mapx, g.ygrid-half_mapy+tilenum)
				refresh_inv_icon()
				refresh_bars()

		else:
			if (tempx == g.xgrid + x) and (tempy == g.ygrid + y) and \
									(g.allow_change_hero == 1):
				if y == -1: player.cur_hero = "people/hero_n" + g.maps[g.zgrid].hero_suffix + ".png"
				if y ==  1: player.cur_hero = "people/hero_s" + g.maps[g.zgrid].hero_suffix + ".png"
				if x == -1: player.cur_hero = "people/hero_w" + g.maps[g.zgrid].hero_suffix + ".png"
				if x ==  1: player.cur_hero = "people/hero_e" + g.maps[g.zgrid].hero_suffix + ".png"
			g.allow_change_hero = 1
			refreshhero()
			recalc_stats()
		g.allow_move = 1
		g.allow_change_hero = 1
		#print clock() - tempclock
	except TclError:
		pass


def move_north(event=0): move_hero(0, -1)
def move_east(event=0):  move_hero(1, 0)
def move_south(event=0): move_hero(0, 1)
def move_west(event=0):  move_hero(-1, 0)


#called at the end of movement. Controls the passing of time.
def passturn():
	global free_move

	#handle timed effects
	g.timestep = g.timestep + 1
	if g.timestep >= 30: g.timestep = g.timestep - 30

	action.activate_lines(g.xgrid, g.ygrid, g.zgrid,
		g.per_turn_script[g.timestep])
	if dead_yet() == 1: return

	#is there a monster here?
	chance = random() * 100
	#allow free moves after attack
	if free_move > 0:
		free_move = free_move - 1
		chance = 99

	if chance < 15:
		#battle
		temp = g.monster.find_level_monster(g.zgrid)
		#if there exists a monster to battle:
		if temp != -1:
			start_battle(temp)
			if dead_yet() != 1:
				#If I don't do this, the quick refresh wigs out.
				global already_refreshed
				already_refreshed = 1


#Starts a battle. Takes the index of the monster in g.monster.monster_groups
def start_battle(mon_index):
	global free_move
	tmp=battle.begin(mon_index)
	if tmp == 1:  #if you ran, you failed
		return_num = 0
	elif tmp == 0:
		return_num = 1  #otherwise, you succeeded.
	elif tmp == "end":
		return_num = "end"
		dead_yet()
	#number of free moves after attack:
	free_move = 4
	g.cur_window = "main"
	player.reset_stats()
	refreshmap()
	bind_keys()
	return return_num


#Call to display a dialog box. Used to work with action.py.
#Note this only works if window_main is visible.
def show_dialog(line=None, txt_width= -1, allow_move=1):
	return show_popup(line, ["begin.png"], allow_move, txt_width)

#given a string, display that string, along with yes and no buttons.
def show_yesno(line="", allow_move=1):
	return show_popup(line, ["no.png", "yes.png"], allow_move)


#when a yesno dialog box is active, switch to yes.
def change_yesno_to_yes(event=None):
	global active_button
	active_button = 1
	canvas_map.itemconfigure("no", image=g.buttons["no.png"])
	canvas_map.itemconfigure("yes", image=g.buttons["yes_sel.png"])

#when a yesno dialog box is active, switch to no.
def change_yesno_to_no(event=None):
	global active_button
	active_button = 0
	canvas_map.itemconfigure("no", image=g.buttons["no_sel.png"])
	canvas_map.itemconfigure("yes", image=g.buttons["yes.png"])

#when a yesno dialog box is active, switch the yes and no buttons.
def change_yesno_sel(event=None):
	if active_button == 0: change_yesno_to_yes()
	else: change_yesno_to_no()

#called on Return when the yesno dialog box is active.
def activate_yesno(event=None):
	global return_from_yesno
	return_from_yesno.set("1")


#given a string and an array of buttons,
#display that string, along with the given buttons.
def show_popup(line="", button_array=[], allow_move=1, input_width=-1):
	#Move the array of button names to a global array. We'll need it later.
	global button_array2
	button_array2 = button_array
	line = action.interpret_line(line)
	if g.window_main.state() != "normal":
		return 0
	action.has_dialog = 1
	g.allow_move = allow_move
	global active_button
	active_button = 0
	global return_from_yesno
	return_from_yesno.set("0")

	#button_width_array stores the starting and ending x-coords for each button
	global button_width_array
	button_width_array = []

	#find widths
	box_width = 0
	for button_line in button_array2:
		box_width += g.buttons[button_line].width()
	button_width_array.append((mapsizex*tilesize)/2 - (box_width)/2)
	for i in range(len(button_array2)):
		button_width_array.append(button_width_array[i] +
						g.buttons[button_array2[i]].width())
	text_width = box_width
	if text_width < 200: text_width = 200
	if input_width != -1: text_width = input_width

	#text
	canvas_map.create_text((mapsizex*tilesize/2),
		(6*mapsizey*tilesize/7), text=line, anchor="s",
		width=text_width, tags="dialogtxt")
	#generate the background size.
	unused, y1, unused, y2 = canvas_map.bbox("dialogtxt")
	#background
	canvas_map.create_rectangle((mapsizex*tilesize)/2 - (text_width)/2-5, y1-5,
		(mapsizex*tilesize)/2 + (text_width)/2+5,
		y2+g.buttons[button_array2[0]].height(),
		fill=g.fill_colour, outline="Black", tags="background_box")
	canvas_map.lift("dialogtxt")
	#buttons
	button_x_start = (mapsizex*tilesize)/2 - (box_width)/2
	for i in range(len(button_array2)):
		canvas_map.create_image(button_x_start, (6*mapsizey*tilesize/7),
				image=g.buttons[button_array2[i]], anchor="nw",
				tags="button"+str(i))
		canvas_map.tag_bind("button"+str(i), "<Motion>",
					change_button)
		canvas_map.tag_bind("button"+str(i), "<ButtonRelease-1>",
					choose_button)
		button_x_start += g.buttons[button_array2[i]].width()
	#bindings
	g.window_main.unbind("<Motion>")
	g.window_main.unbind("<ButtonRelease-1>")
	g.window_main.bind(g.binding_up, decrease_button)
	g.window_main.bind(g.binding_right, increase_button)
	g.window_main.bind(g.binding_left, decrease_button)
	g.window_main.bind(g.binding_down, increase_button)
	g.window_main.bind(g.binding_action, choose_button)

	tmp = button_array2[0][0:-4]+"_sel"+button_array2[0][-4:]
	canvas_map.itemconfigure("button0", image=g.buttons[tmp])
	#wait. Continue after activate_yesno() is run.
	g.window_main.wait_variable(return_from_yesno)
	#cleanup
	try:
		if g.window_main.state() != "normal": return 1
	except TclError: return 1
	if g.cur_window == "shop": shop.shop_bind_keys()
	elif g.cur_window == "playerstats": stats.menu_bind_keys()
	elif g.cur_window == "inventory": inv.menu_bind_keys()
	elif g.cur_window == "inventory_use": inv.use_bind_keys()
	elif g.cur_window == "inventory_drop": inv.drop_bind_keys()
	elif g.cur_window == "inventory_equip": inv.equip_bind_keys()
	elif g.cur_window == "battle": battle.bind_keys()
	elif g.cur_window == "battle_attack": battle.bind_attack_keys()
	elif g.cur_window == "battle_item": battle.bind_item_keys()
	elif g.cur_window == "battle_skill": battle.bind_skill_keys()
	else: bind_keys()
	action.has_dialog = 0
	canvas_map.delete("dialogtxt", "background_box")
	for i in range(len(button_array2)):
		canvas_map.delete("button"+str(i))

	return active_button

#The obvious way of doing this does not appear to work.
def change_button(event=None):
	global active_button
	curr_button = -1
	for i in range(len(button_array2)):
		if event.x >= button_width_array[i] and event.x <= button_width_array[i+1]:
			curr_button = i
			break
	#for some reason, <Enter> isn't exact.
	if curr_button == -1:
		return
	for i in range(len(button_array2)):
		if curr_button == i:
			tmp = button_array2[i][0:-4]+"_sel"+button_array2[i][-4:]
			canvas_map.itemconfigure("button"+str(i), image=g.buttons[tmp])
		else:
			canvas_map.itemconfigure("button"+str(i), image=g.buttons[button_array2[i]])
	active_button = curr_button
	return 1

def increase_button(event=None):
	global active_button
	active_button += 1
	if active_button >= len(button_array2):
		active_button -= len(button_array2)
	for i in range(len(button_array2)):
		if active_button == i:
			tmp = button_array2[i][0:-4]+"_sel"+button_array2[i][-4:]
			canvas_map.itemconfigure("button"+str(i), image=g.buttons[tmp])
		else:
			canvas_map.itemconfigure("button"+str(i), image=g.buttons[button_array2[i]])

def decrease_button(event=None):
	global active_button
	active_button -= 1
	if active_button < 0:
		active_button += len(button_array2)
	for i in range(len(button_array2)):
		if active_button == i:
			tmp = button_array2[i][0:-4]+"_sel"+button_array2[i][-4:]
			canvas_map.itemconfigure("button"+str(i), image=g.buttons[tmp])
		else:
			canvas_map.itemconfigure("button"+str(i), image=g.buttons[button_array2[i]])

#called on Return when the yesno dialog box is active.
def choose_button(event=None):
	global return_from_yesno
	return_from_yesno.set("1")


#Display the scripting console. This window will take scripting, then
#execute it.
def load_console(event=None):
	#Only let cheaters access the console.
	if player.name != "testing123" and player.name != "god" and \
									player.name != "script_test":
		return 0
	global console_text
	console_text = ""

	global curr_name_loc
	curr_name_loc = 0

	canvas_map.create_rectangle(0, 0, mapsizex*tilesize, 17,
		tags="consolerect", fill="#e3e3e3")
	canvas_map.create_text(5, 1, anchor=NW, text=console_text+"_", tags="console")

	g.window_main.unbind(g.binding_up)
	g.window_main.unbind(g.binding_right)
	g.window_main.unbind(g.binding_left)
	g.window_main.unbind(g.binding_down)
	g.window_main.unbind(g.binding_cancel)
	g.window_main.unbind(g.binding_inv)
	g.window_main.unbind(g.binding_attack)
	g.window_main.unbind(g.binding_save)
	g.window_main.unbind(g.binding_quit)
	g.window_main.unbind(g.binding_action)
	g.window_main.unbind(g.binding_console)

	g.window_main.bind("<Key>", adjust_console)
	g.window_main.bind("<BackSpace>", backspace_console)
	g.window_main.bind("<Home>", console_home)
	g.window_main.bind("<End>", console_end)
	g.window_main.bind(g.binding_action, accept_console)
	g.window_main.bind(g.binding_cancel, cancel_console)
	g.window_main.bind(g.binding_left, console_left)
	g.window_main.bind(g.binding_right, console_right)

def adjust_console(event=0):
	usable_chars = "`~!@#$%^&*()-_=+\|[{]};:'\",<.>/? "
	if event==0: return
	c = event.char
	if c == "": return
	if c.isalnum() == 0:
		if usable_chars.find(c) == -1: return
	global console_text
	global curr_name_loc
	console_text=console_text[:curr_name_loc]+event.char+console_text[curr_name_loc:]
	curr_name_loc += 1
	canvas_map.itemconfigure("console",
		text=console_text[:curr_name_loc]+"_"+console_text[curr_name_loc:])

def backspace_console(event=0):
	global console_text
	global curr_name_loc
	console_text = console_text[:curr_name_loc-1]+console_text[curr_name_loc:]
# 	canvas_map.itemconfigure("name", text=g.name_name+": "+ name_stat)
	curr_name_loc -= 1
	if curr_name_loc < 0: curr_name_loc = 0
	canvas_map.itemconfigure("console",
		text=console_text[:curr_name_loc]+"_"+console_text[curr_name_loc:])


def console_left(event=None):
	global curr_name_loc
	curr_name_loc -= 1
	if curr_name_loc < 0: curr_name_loc = 0
	canvas_map.itemconfigure("console",
		text=console_text[:curr_name_loc]+"_"+console_text[curr_name_loc:])


def console_right(event=None):
	global curr_name_loc
	curr_name_loc += 1
	if curr_name_loc > len(console_text): curr_name_loc = len(console_text)
	canvas_map.itemconfigure("console",
		text=console_text[:curr_name_loc]+"_"+console_text[curr_name_loc:])

def console_home(event=None):
	global curr_name_loc
	curr_name_loc = 0
	canvas_map.itemconfigure("console",
		text=console_text[:curr_name_loc]+"_"+console_text[curr_name_loc:])


def console_end(event=None):
	global curr_name_loc
	curr_name_loc = len(console_text)
	canvas_map.itemconfigure("console",
		text=console_text[:curr_name_loc]+"_"+console_text[curr_name_loc:])

#Called on hitting the "run scripting" button in the console. Runs the scripting
#in the console, then destroys the console.
def accept_console(event=None):
	console_input = console_text
	console_array = []
	console_array.append(console_input)

	bind_keys()
	canvas_map.delete("console")
	canvas_map.delete("consolerect")
	action.activate_lines(g.xgrid, g.ygrid, g.zgrid, g.interpret_lines(console_array))

def cancel_console(event=None):
	bind_keys()
	canvas_map.delete("console")
	canvas_map.delete("consolerect")



#If the main window is destroyed unexpectedly, try to prevent the worst errors.
def cleanup(event=None):
	activate_yesno()
	battle.back_to_main.set("2")
	try: inv.leave_inv()
	except AttributeError: pass
	try: stats.leave_stats()
	except AttributeError: pass
	shop.leave_shop()
	new_game.loadgame.return_from_loadgame.set(1)
	g.window_main.destroy()
	action.has_dialog = 0

#call to create window_main.
def init_window_main(is_new_game = 0):
	canvas_map.delete(ALL)
	g.window_main.bind("<ButtonRelease-1>", mouse_handler)

	g.load_tiles()

	#width of the hp/ep bars.
	g.hpbar_width = g.tilesize*3

	name.set(player.name)


	#put in the map, and do finishing touches on the window.
	player.reset_stats()
	process_onload()
	player.cur_hero = "people/hero_w" + g.maps[g.zgrid].hero_suffix + ".png"

	top_of_buttons = mapsizey*tilesize-iconsize

	canvas_map.create_image(mapsizex*tilesize-3*iconsize, top_of_buttons,
			image=g.icons[inv_icon_image], anchor=NW, tags="inv_icon")
	canvas_map.create_image(mapsizex*tilesize-iconsize, top_of_buttons,
			image=g.icons[quit_icon_image], anchor=NW, tags="quit_icon")
	canvas_map.create_image(mapsizex*tilesize-2*iconsize, top_of_buttons,
			image=g.icons[save_icon_image], anchor=NW, tags="save_icon")
	info_top_x = mapsizex*tilesize-3*iconsize
	info_top_y = mapsizey*tilesize-7*iconsize
	info_bottom_x = mapsizex*tilesize
	info_bottom_y = mapsizey*tilesize-iconsize
	canvas_map.create_rectangle(info_top_x, info_top_y,
					info_bottom_x, info_bottom_y, fill=g.fill_colour,
					stipple="gray50", tags="info_rect")
	icon_x = info_top_x + 5
	icon_y = info_top_y + 5
	canvas_map.create_image(icon_x, icon_y, anchor=NW,
			image=g.icons["attack.png"], tags="info_rect");
	icon_y += iconsize
	canvas_map.create_image(icon_x, icon_y, anchor=NW,
			image=g.icons["defense.png"], tags="info_rect");
	icon_y += iconsize
	canvas_map.create_image(icon_x, icon_y, anchor=NW,
			image=g.icons["gold.png"], tags="info_rect");
	icon_y += iconsize + 4
	canvas_map.create_image(icon_x, icon_y, anchor=NW,
			image=g.icons["level.png"], tags="info_rect");
	icon_y += iconsize + 4
	canvas_map.create_image(icon_x, icon_y, anchor=NW,
			image=g.icons["xp.png"], tags="info_rect");
	stats_x = info_top_x + iconsize + 10
	stats_y = info_top_y + 7
	canvas_map.create_text(stats_x, stats_y, font=bold_font,
		text=str(player.adj_attack), anchor=NW, tags=("info_rect", "info_attack"));
	stats_y += iconsize
	canvas_map.create_text(stats_x, stats_y, font=bold_font,
		text=str(player.adj_defense), anchor=NW, tags=("info_rect", "info_defense"));
	stats_y += iconsize
	canvas_map.create_text(stats_x, stats_y, font=bold_font,
			text=str(player.gold), anchor=NW, tags=("info_rect", "info_gold"));
	stats_y += iconsize + 4
	canvas_map.create_text(stats_x, stats_y, font=bold_font,
			text=str(player.level), anchor=NW, tags=("info_rect", "info_level"));
	stats_y += iconsize + 4
	canvas_map.create_text(stats_x, stats_y, font=bold_font,
			text=str(player.exp), anchor=NW, tags=("info_rect", "info_exp"));


	stuff_width = 3*iconsize
	canvas_map.create_image(mapsizex*tilesize-stuff_width, mapsizey*tilesize,
		image=g.buttons[scroller_icon_image], anchor=SE, tags="scroller_icon")

	canvas_map.create_rectangle(-1, mapsizey*tilesize*5/6,
		mapsizex*tilesize+1-stuff_width, mapsizey*tilesize+1, fill=g.fill_colour, tags="status_rect")


	refreshmap()
	global free_move
	free_move = 0
	g.cur_window = "main"

	bind_keys()

	#call newgame script
	if is_new_game == 1:
		action.activate_lines(g.xgrid, g.ygrid, g.zgrid, g.newgame_act)
	g.allow_move = 1
	g.window_main.protocol("WM_DELETE_WINDOW", close_window)

	#keep the new_game window asleep until this one is closed.
	g.window_main.wait_window(g.window_main)
	return 0

#this binds keys to the appropriate commands. Needs to be called after
#returning from various subwindows.
def bind_keys():
	g.window_main.bind(g.binding_up, move_north)
	g.window_main.bind(g.binding_right, move_east)
	g.window_main.bind(g.binding_left, move_west)
	g.window_main.bind(g.binding_down, move_south)
	g.window_main.bind(g.binding_cancel, close_window)
	g.window_main.bind(g.binding_inv, show_inv)
	g.window_main.unbind(g.binding_attack)
	g.window_main.bind(g.binding_save, save_game)
	g.window_main.bind(g.binding_quit, close_window)
	g.window_main.bind(g.binding_action, show_inv)
	g.window_main.bind(g.binding_console, load_console)
	g.window_main.bind("<ButtonRelease-1>", mouse_handler)
	g.window_main.unbind("<Double-Button-1>")
	g.window_main.bind("<Motion>", mouse_move)

def unbind_keys():
	g.window_main.unbind(g.binding_up)
	g.window_main.unbind(g.binding_right)
	g.window_main.unbind(g.binding_left)
	g.window_main.unbind(g.binding_down)
	g.window_main.unbind(g.binding_cancel)
	g.window_main.unbind(g.binding_inv)
	g.window_main.unbind(g.binding_attack)
	g.window_main.unbind(g.binding_save)
	g.window_main.unbind(g.binding_quit)
	g.window_main.unbind(g.binding_action)
	g.window_main.unbind(g.binding_console)
	g.window_main.unbind("<ButtonRelease-1>")
	g.window_main.unbind("<Double-Button-1>")
	g.window_main.unbind("<Motion>")

#handles mouse clicks on the main tile canvas.
def mouse_handler(event=0):
	icon_y1 = mapsizey*tilesize - iconsize
	icon_y2 = mapsizey*tilesize

	inv_x1 = mapsizex*tilesize - 3*iconsize
	inv_x2 = inv_x1 + iconsize
	if event.x > inv_x1 and event.x < inv_x2 and \
			event.y > icon_y1 and event.y < icon_y2:
		show_inv()
		return

	save_x1 = inv_x2
	save_x2 = save_x1 + iconsize
	if event.x > save_x1 and event.x < save_x2 and \
			event.y > icon_y1 and event.y < icon_y2:
		save_game()
		return

	quit_x1 = save_x2
	quit_x2 = quit_x1 + iconsize
	if event.x > quit_x1 and event.x < quit_x2 and \
			event.y > icon_y1 and event.y < icon_y2:
		close_window()
		return


	if event.x > mapsizex*tilesize - 3*iconsize - g.buttons["scroller.png"].width() and \
			event.x < mapsizex*tilesize - 3*iconsize and \
			event.y > mapsizey*tilesize - g.buttons["scroller.png"].height():
		tmpline = ""
		for line in message_array:
			tmpline += line + "\n"
		show_dialog(tmpline, 650, 0)
		return

	#set variables, based on the shape of the main window. (tall or wide)
	if mapsizex > mapsizey:
		mapsz = mapsizey*g.tilesize
		mapstartx = (mapsizex*g.tilesize - mapsz)/2
		mapstarty = 0
	else:
		mapsz = mapsizex*g.tilesize
		mapstartx = 0
		mapstarty = (mapsizey*g.tilesize - mapsz)/2
	#This basically divides the screen along diagonals, then finds the
	#current quadrent of the mouse.
	if (event.x - mapstartx < event.y - mapstarty): #south or west
		if (event.x + event.y > mapstartx+mapstarty+mapsz): move_south()
		else: move_west()
	else: #north or east
		if (event.x + event.y > mapstartx+mapstarty+mapsz): move_east()
		else: move_north()

#called whenever the mouse moves
def mouse_move(event=0):
	global inv_icon_image
	global quit_icon_image
	global save_icon_image
	global scroller_icon_image

	icon_y1 = mapsizey*tilesize - iconsize
	icon_y2 = mapsizey*tilesize

	inv_x1 = mapsizex*tilesize - 3*iconsize
	inv_x2 = inv_x1 + iconsize
	if event.x > inv_x1 and event.x < inv_x2 and \
			event.y > icon_y1 and event.y < icon_y2:
		new_icon_image = "inv_sel.png"
	else:
		new_icon_image = "inv.png"

	save_x1 = inv_x2
	save_x2 = save_x1 + iconsize
	if event.x > save_x1 and event.x < save_x2 and \
			event.y > icon_y1 and event.y < icon_y2:
		new_save_image = "save_sel.png"
	else:
		new_save_image = "save.png"


	quit_x1 = save_x2
	quit_x2 = quit_x1 + iconsize
	if event.x > quit_x1 and event.x < quit_x2 and \
			event.y > icon_y1 and event.y < icon_y2:
		new_quit_image = "quit_sel.png"
	else:
		new_quit_image = "quit.png"


	if event.x > mapsizex*tilesize - iconsize*3 - g.buttons["scroller.png"].width() and \
			event.x < mapsizex*tilesize - 3*iconsize and \
			event.y > mapsizey*tilesize - g.buttons["scroller.png"].height():
		new_scroll_icon_image = "scroller_sel.png"
	else:
		new_scroll_icon_image = "scroller.png"


	if (new_icon_image != inv_icon_image or
			quit_icon_image != new_quit_image or
			save_icon_image != new_save_image or
				scroller_icon_image != new_scroll_icon_image):
		inv_icon_image = new_icon_image
		quit_icon_image = new_quit_image
		save_icon_image = new_save_image

		scroller_icon_image = new_scroll_icon_image
		refresh_inv_icon(1)



#show the inventory.
def show_inv(event=0):
	try:
		if g.window_main.state() != "normal" or action.has_dialog == 1:
			return
		inv.init_window_inv()
		refreshmap()
		recalc_stats()
		bind_keys()
		g.cur_window = "main"
	except TclError:
		pass

def enter_store(cur_loc):
	unbind_keys()
	shop.init_window_shop(cur_loc)
	refreshmap()
	recalc_stats()
	bind_keys()
	g.cur_window = "main"
