#inv.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#This file controls the inventory screen.
from Tkinter import *
#needed for the buttons.
import ImageTk
import Image

import tkMessageBox
import g
import main
import action
import re
import item

from player import *

#width/height of inv canvas, in tiles.
# (g.tilesize + the 3 pixel border)
inv_width = 4
inv_height = 7

#width/height of the equipment canvas, in tiles.
equip_size = 3

#Currently selected item number
curr_item = 0


global active_button
active_button = 0

return_from_yesno = StringVar()

#these variables hold the name of the wielded equipment
weapon_name = StringVar()
armor_name = StringVar()
shield_name = StringVar()
helmet_name = StringVar()
gloves_name = StringVar()
boots_name = StringVar()

help_text = StringVar()

#currently selected button. 0=Drop, 1=Wear/Use, 2=Save, 3=Remove, 4=Leave
cur_button = 0


#distance from the left of the button canvas each button should be placed.
#Values are added in init_window. drop is not needed; always zero.
use_height = 0
remove_height = 0
save_height = 0
leave_height = 0


#called when "Save" is pressed
def inv_savegame():
	if action.has_dialog == 1: return 0
	g.savegame(player.name)
	main.print_message("** Game Saved **")
	help_text.set("Game Saved")

#called when "Leave" is pressed
def leave_inv():
	if action.has_dialog == 1: return 0
	try:
		g.cur_window = "main"
		window_inv.destroy()
	except TclError:
		pass

#puts a worn item into the inventory. Called from the remove button.
def rm_equip():
	if action.has_dialog == 1: return 0
	#Curr_item is the current location in the equipment canvas.
	#The missing numbers in this sequence are the blank spots in the display.
	sel_equipment = -1
	if curr_item == 1: sel_equipment = 3
	elif curr_item == 2: sel_equipment = 4
	elif curr_item == 3: sel_equipment = 0
	elif curr_item == 4: sel_equipment = 1
	elif curr_item == 5: sel_equipment = 2
	elif curr_item == 7: sel_equipment = 5
	if sel_equipment == -1: return 0

	if player.equip[sel_equipment] != -1:
		if -1 != item.take_inv_item(player.equip[sel_equipment]):
			main.print_message("You take off your " +
				item.item[player.equip[sel_equipment]].name)
			player.equip[sel_equipment] = -1
	player.reset_stats()
	refresh_inv()

#takes an item from the inventory, and wears it.
def wear_item():
	if action.has_dialog == 1: return 0

	try:
		item_value = item.inv[curr_item]
	except IndexError:
		return 0

	#put the equip slot into item_loc
	item_loc = item.item[item_value].type

	#if item is equipment
	if item_loc < 6:
		#trade the item and whatever's in the equip slot
		temp = player.equip[item_loc]
		player.equip[item_loc] = item_value
		item.drop_inv_item(curr_item)
		item.take_inv_item(temp)
		main.print_message("You equip yourself with your " +
			item.item[player.equip[item_loc]].name + ".")
		player.reset_stats()
		refresh_inv()

#drops an item from the inventory. Uses curr_item
def drop_item():
	if action.has_dialog == 1: return 0
	if curr_item >= len(item.inv) or item.inv[curr_item] == -1:
		return 0
	try: item_to_delete = item.find_inv_item(item.inv[curr_item])
	except IndexError: return 0

	if item.item[item.inv[item_to_delete]].price == 0 and \
				item.item[item.inv[item_to_delete]].value == 0:
		main.print_message("You feel attached to your " +
			item.item[item.inv[item_to_delete]].name)
		return 0
	#the inv[] location of the item is now in item_to_delete.
	#Ask if the player really wants to drop it.

	if inv_show_yesno("Drop your " +
			item.item[item.inv[item_to_delete]].name + "?"):
		main.print_message("You drop your " +
			item.item[item.inv[curr_item]].name)

		# add dropped item to map
		g.maps[g.zgrid].additem(item.item[item.inv[item_to_delete]].name,
			g.xgrid, g.ygrid)


		#remove the item from inventory
		item.drop_inv_item(curr_item)

	refresh_inv()

#Like show_yesno in main, but only expects one or two lines,
#and creates the canvas used.
def inv_show_yesno(line=""):
	action.has_dialog = 1
	global active_button
	active_button = 0
	global return_from_yesno
	return_from_yesno.set("0")

	canvas_width = g.buttons["no.png"].width()*4/3+g.buttons["yes.png"].width()*4/3
	canvas_height = g.buttons["yes.png"].height()+50
	global canvas_inv2
	canvas_inv2 = Canvas(window_inv, width=canvas_width,
		height=canvas_height, highlightthickness=0)
	canvas_inv2.grid(column=1, row=2, columnspan=2, rowspan=7, sticky="S")

	#background
	canvas_inv2.create_rectangle(0, 0, canvas_width, canvas_height,
		fill=g.fill_colour, outline="Black", tags="background_box")
	#text
	canvas_inv2.create_text(3, 3, text=line, anchor="nw",
		width=canvas_width-6, tags="dialogtxt")
	#buttons
	canvas_inv2.create_image(canvas_width/2,
		canvas_height, image=g.buttons["no_sel.png"], anchor="se", tags="no")
	canvas_inv2.create_image(canvas_width/2,
		canvas_height, image=g.buttons["yes.png"], anchor="sw", tags="yes")
	#bindings
	main.window_main.bind(g.binding_up, change_yesno_sel)
	main.window_main.bind(g.binding_right, change_yesno_sel)
	main.window_main.bind(g.binding_left, change_yesno_sel)
	main.window_main.bind(g.binding_down, change_yesno_sel)
	main.window_main.bind(g.binding_action, activate_yesno)
	canvas_inv2.tag_bind("no", "<Enter>", change_yesno_to_no)
	canvas_inv2.tag_bind("yes", "<Enter>", change_yesno_to_yes)
	canvas_inv2.tag_bind("no", "<Button-1>", activate_yesno)
	canvas_inv2.tag_bind("yes", "<Button-1>", activate_yesno)

	#wait. Continue after activate_yesno() is run.
	window_inv.wait_variable(return_from_yesno)
	#cleanup
	try: canvas_inv2.destroy()
	except TclError: return 1

	bind_keys()

	action.has_dialog = 0
	return active_button

#when a yesno dialog box is active, switch to yes.
def change_yesno_to_yes(event=None):
	global active_button
	active_button = 1
	canvas_inv2.itemconfigure("no", image=g.buttons["no.png"])
	canvas_inv2.itemconfigure("yes", image=g.buttons["yes_sel.png"])

#when a yesno dialog box is active, switch to no.
def change_yesno_to_no(event=None):
	global active_button
	active_button = 0
	canvas_inv2.itemconfigure("no", image=g.buttons["no_sel.png"])
	canvas_inv2.itemconfigure("yes", image=g.buttons["yes.png"])

#when a yesno dialog box is active, switch the yes and no buttons.
def change_yesno_sel(event=None):
	if active_button == 0: change_yesno_to_yes()
	else: change_yesno_to_no()

#called on Return when the yesno dialog box is active.
def activate_yesno(event=None):
	global return_from_yesno
	return_from_yesno.set("1")


#called when "Use" is pressed
def use_item():
	if action.has_dialog == 1: return 0
	if curr_item >= len(item.inv) or item.inv[curr_item] == -1:
		return 0

	#put the item[] index of the item into item_value
	try: item_value = item.inv[curr_item]
	except IndexError: return 0

	#put the equip slot into item_loc
	item_loc = item.item[item_value].type
	#if equipment
	if item_loc < 6:
		wear_item()
		return

	main.print_message("You use your " + item.item[item_value].name)
	#if item is healing
	if item_loc == 11:
		#heal the player, delete the item
		player.give_stat("hp", item.item[item_value].quality)
		item.drop_inv_item(curr_item)
	if item_loc == 16 or item_loc == 17:
		if action.activate_lines(g.xgrid, g.ygrid, g.zgrid,
										item.item[item_value].scripting) == 1:
			item.drop_inv_item(curr_item)

	refresh_inv()


#refresh buttons.
def refresh_buttons(event=0):
	no_item = 0  #set to one if no item is selected
	if action.has_dialog == 1: return 0
	canvas_buttons.delete(ALL)
	if curr_item >= len(item.inv) or item.inv[curr_item] == -1:
		no_item = 1
	if (cur_button == 0):
		canvas_buttons.create_image(0, 0, anchor=NW, image=g.buttons["drop_sel.png"])
		if no_item == 1: help_text.set("")
		else: help_text.set("Drop your " + item.item[item.inv[curr_item]].name)
	else: canvas_buttons.create_image(0, 0, anchor=NW, image=g.buttons["drop.png"])
	if (cur_button == 1):
		#switch between equip and use, based on the current item.
		try:
			item_value = item.inv[curr_item]
			item_loc = item.item[item_value].type
		except IndexError: item_loc = 50

		if (item_loc <= 6):
			canvas_buttons.create_image(use_height, 0, anchor=NW,
					image=g.buttons["equip_sel.png"])
			if no_item == 1: help_text.set("")
			else: help_text.set("Equip your " + item.item[item.inv[curr_item]].name)
		else:
			canvas_buttons.create_image(use_height, 0, anchor=NW,
					image=g.buttons["use_sel.png"])
			if no_item == 1: help_text.set("")
			else: help_text.set("Use your " + item.item[item.inv[curr_item]].name)
	else:
		try:
			item_value = item.inv[curr_item]
			item_loc = item.item[item_value].type
		except IndexError: item_loc = 50

		if (item_loc <= 6): canvas_buttons.create_image(use_height, 0,
					anchor=NW, image=g.buttons["equip.png"])
		else: canvas_buttons.create_image(use_height, 0, anchor=NW,
					image=g.buttons["use.png"])
	if (cur_button == 2):
		canvas_buttons.create_image(save_height, 0,
					anchor=NW, image=g.buttons["save_sel.png"])
		help_text.set("Save game")
	else: canvas_buttons.create_image(save_height, 0, anchor=NW,
							image=g.buttons["save.png"])
	if (cur_button == 3):
		canvas_buttons.create_image(remove_height, 0,
					anchor=NW, image=g.buttons["remove_sel.png"])
		help_text.set("Remove equipment")
	else: canvas_buttons.create_image(remove_height, 0, anchor=NW,
							image=g.buttons["remove.png"])
	if (cur_button == 4):
		canvas_buttons.create_image(leave_height, 0,
					anchor=NW, image=g.buttons["leave_sel.png"])
		help_text.set("Leave inventory")
	else: canvas_buttons.create_image(leave_height, 0, anchor=NW,
							image=g.buttons["leave.png"])

#refresh this screen. Call after moving around items.
def refresh_inv():
	if action.has_dialog == 1: return 0
	canvas_inv.delete("item")
# 	invpos = 0
	#if the inv is selected, draw a selection box around the current item.
	if cur_button == 0 or (cur_button == 1):
		if (curr_item != -1):
			canvas_inv.create_rectangle(
				(curr_item%inv_width)*g.tilesize + 2 * ((curr_item%inv_width)+1),
				(curr_item/inv_width)*g.tilesize + 2 * ((curr_item/inv_width)+1),
				((curr_item%inv_width)+1)*(g.tilesize + 2),
				((curr_item/inv_width)+1)*(g.tilesize + 2), fill=g.fill_sel_colour, tags="item")

	#draw the item pictures.
	for i in range(len(item.inv)):
		if item.inv[i] != -1:
			draw_item(canvas_inv, item.item[item.inv[i]].picturename,
						i%inv_width, i/inv_width)
# 			invpos += 1

	canvas_equip.delete("item")
	if cur_button == 3: #equipment
		canvas_equip.create_rectangle(
			(curr_item%equip_size)*g.tilesize + 2 * ((curr_item%equip_size)+1),
			(curr_item/equip_size)*g.tilesize + 2 * ((curr_item/equip_size)+1),
			((curr_item%equip_size)+1)*(g.tilesize + 2),
			((curr_item/equip_size)+1)*(g.tilesize + 2), fill=g.fill_sel_colour, tags="item")

	#rebuild the equipment display

	#Weapon
	if player.equip[0] != -1:
		draw_item(canvas_equip, item.item[player.equip[0]].picturename, 0, 1)
	else: draw_item(canvas_equip, "items/weapon_eq.png", 0, 1)
	#Armor
	if player.equip[1] != -1:
		draw_item(canvas_equip, item.item[player.equip[1]].picturename, 1, 1)
	else: draw_item(canvas_equip, "items/armor_eq.png", 1, 1)
	#Shield
	if player.equip[2] != -1:
		draw_item(canvas_equip, item.item[player.equip[2]].picturename, 2, 1)
	else: draw_item(canvas_equip, "items/shield_eq.png", 2, 1)
	#Helmet
	if player.equip[3] != -1:
		draw_item(canvas_equip, item.item[player.equip[3]].picturename, 1, 0)
	else: draw_item(canvas_equip, "items/helmet_eq.png", 1, 0)
	#Gloves
	if player.equip[4] != -1:
		draw_item(canvas_equip, item.item[player.equip[4]].picturename, 2, 0)
	else: draw_item(canvas_equip, "items/gloves_eq.png", 2, 0)
	#Boots
	if player.equip[5] != -1:
		draw_item(canvas_equip, item.item[player.equip[5]].picturename, 1, 2)
	else: draw_item(canvas_equip, "items/boots_eq.png", 1, 2)

	main.recalc_stats()

#Takes a canvas, a string (leading to a picture in g.tiles[]), and xy coords
#(in tiles, starting from 0), and draws the picture.
def draw_item(input_canvas, input_picture, x, y):
	input_canvas.create_image(x*g.tilesize + 2*(x+1),
				y*g.tilesize + 2*(y+1),
				image=g.tiles[input_picture],
				anchor="nw", tags="item")

#All keypresses in window_inv pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(key_name):
	if action.has_dialog == 1: return 0
	global cur_button
	global curr_item
	if (key_name == "esc"):
		leave_inv()
		return 0
	elif (key_name == "pgup"):
		if (cur_button == 0): #switch from drop to quit
			cur_button = 4
			curr_item = -1
		elif (cur_button == 1): #switch from use to drop
			cur_button = 0
		elif (cur_button == 2): #switch from save to use
			cur_button = 1
			curr_item = 3
		elif (cur_button == 3): #switch from remove to save
			cur_button = 2
			curr_item = -1
		elif (cur_button == 4): #switch from quit to remove
			cur_button = 3
			curr_item = 0
	elif (key_name == "pgdn"):
		if (cur_button == 0): #switch from drop to use
			cur_button = 1
		elif (cur_button == 1): #switch from use to save
			cur_button = 2
			curr_item = -1
		elif (cur_button == 2): #switch from save to remove
			cur_button = 3
			curr_item = 0
		elif (cur_button == 3): #switch from remove to quit
			cur_button = 4
			curr_item = -1
		elif (cur_button == 4): #switch from quit to drop
			cur_button = 0
			curr_item = 0
	elif (key_name == "right"):
		if (cur_button == 0): #move right, or switch from drop to use
			if (curr_item % inv_width == inv_width-1):  #if on right side
				cur_button = 1
			else: curr_item += 1
		elif (cur_button == 1): #move right, or switch from use to save
			if (curr_item % inv_width == inv_width-1):  #if on right side
				cur_button = 2
				curr_item = -1
			else: curr_item += 1
		elif (cur_button == 2): #switch from save to remove
			cur_button = 3
			curr_item = 0
		elif (cur_button == 3): #Move right, or switch from remove to quit
			if (curr_item % equip_size == equip_size-1):  #if on right side
				cur_button = 4
				curr_item = -1
			else: curr_item += 1
		elif (cur_button == 4): #switch from quit to drop
			cur_button = 0
			curr_item = 0
	elif (key_name == "left"):
		if (cur_button == 0): #move left, or switch from drop to quit
			if (curr_item % inv_width == 0):  #if on left side
				cur_button = 4
				curr_item = -1
			else: curr_item -= 1
		elif (cur_button == 1): #move left, or switch from use to drop
			if (curr_item % inv_width == 0):  #if on left side
				cur_button = 0
			else: curr_item -= 1
		elif (cur_button == 2): #switch from save to use
			cur_button = 1
			curr_item = 3
		elif (cur_button == 3): #move left, or switch from remove to save
			if (curr_item % equip_size == 0):  #if on left side
				cur_button = 2
				curr_item = -1
			else: curr_item -= 1
		elif (cur_button == 4): #switch from quit to remove
			cur_button = 3
			curr_item = equip_size -1
	elif (key_name == "up"):
		if (cur_button == 0 or cur_button == 1): #if in inv
			curr_item = curr_item - inv_width
			if curr_item < 0:
				curr_item += inv_width * inv_height
		if (cur_button == 3): #if in equip
			curr_item = curr_item - equip_size
			if curr_item < 0:
				curr_item += equip_size * equip_size
	elif (key_name == "down"):
		if (cur_button == 0 or cur_button == 1): #if in inv
			curr_item = curr_item + inv_width
			if curr_item >= inv_width * inv_height:
				curr_item -= inv_width * inv_height
		if (cur_button == 3): #if in equip
			curr_item = curr_item + equip_size
			if curr_item >= equip_size * equip_size:
				curr_item -= equip_size * equip_size
	elif (key_name == "return"):
		if (cur_button == 0): drop_item()
		elif (cur_button == 1):
			use_item()
		elif (cur_button == 2):
			inv_savegame()
			return 0
		elif (cur_button == 3): rm_equip()
		elif (cur_button == 4):
			leave_inv()
			return 0
	refresh_buttons()
	refresh_inv()

def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")
def key_handler_pgup(event=0): key_handler("pgup")
def key_handler_pgdn(event=0): key_handler("pgdn")

def mouse_handler_click(event=0):
	if action.has_dialog == 1: return 0
	key_handler("return")

#Used in mouse_sel_inv. Takes x y coordinates, and returns
#the selected box, or -1 for none.
def which_box(x, y, temp_size):
	if x < 3: return -1
	tempx = x - 3
	likelyx = tempx / (g.tilesize + 2)
	tempx = tempx - (likelyx * (g.tilesize + 2))
	if tempx >= g.tilesize - 1: return -1

	if y < 3: return -1
	tempy = y - 3
	likelyy = tempy / (g.tilesize + 2)
	tempy = tempy - (likelyy * (g.tilesize + 2))
	if tempy >= g.tilesize - 1: return -1

	return likelyy * temp_size + likelyx

#called when the user releases the mouse in the inv canvas.
def mouse_sel_inv(event=0):
	#decide if the mouse is within one of the boxes.
	global curr_item
	#global curr_focus
	temp_num =  which_box(event.x, event.y, inv_width)
	if temp_num == -1: return
	curr_item = temp_num
	global cur_button
	if cur_button != 0 and cur_button != 1:
		cur_button = 1
	refresh_buttons()
	refresh_inv()

#called when the user releases the mouse in the equip canvas.
def mouse_sel_equip(event=0):
	#decide if the mouse is within one of the boxes.
	global curr_item
	temp_num =  which_box(event.x, event.y, equip_size)
	if temp_num == -1: return
	curr_item = temp_num
	global cur_button
	cur_button = 3
	refresh_buttons()
	refresh_inv()

def mouse_handler_move(event=0):
	if action.has_dialog == 1: return 0
	global cur_button
	if (event.x < use_height):
		cur_button = 0
# 		listbox_equip.select_clear(0, END)
	elif (event.x < save_height):
		cur_button = 1
# 		listbox_equip.select_clear(0, END)
	elif (event.x < remove_height): cur_button = 2
	elif (event.x < leave_height):
		cur_button = 3
# 		if (len(listbox_equip.curselection()) == 0):
# 			listbox_equip.selection_set(0)
	else: cur_button = 4
	refresh_buttons()

def init_window_inv():
	#create the window
	global window_inv
	global bgcolour
	bgcolour = "lightgrey"
	window_inv = Frame(main.top, bd=4, relief=GROOVE, bg=bgcolour)
	window_inv.grid(row=1, column=5, columnspan=13, rowspan=13, sticky=E)
	global curr_item
	curr_item = 0

	#Set current window to inventory
	g.cur_window = "inventory"

	#Inventory canvas
	temp_canvas_width=(g.tilesize*inv_width)+ ((inv_width+1)*2) + 1
	temp_canvas_height=(g.tilesize*inv_height)+ ((inv_height+1)*2) + 1
	global canvas_inv
	canvas_inv = Canvas(window_inv, width=temp_canvas_width,
		height=temp_canvas_height, highlightthickness=0, bg=g.outline_colour)
	canvas_inv.grid(column=1, row=2, rowspan=10)
	#outside border
	canvas_inv.create_rectangle(0,0, temp_canvas_width-1, temp_canvas_height-1)
	#per-item borders
	for y in range(inv_height):
		for x in range(inv_width):
			canvas_inv.create_rectangle(x*g.tilesize + 2 * (x+1),
										y*g.tilesize + 2 * (y+1),
										(x+1)*(g.tilesize + 2),
										(y+1)*(g.tilesize + 2), fill=g.fill_colour)


	#Equipment canvas
	temp_canvas_width=(g.tilesize*equip_size)+ 9
	global canvas_equip
	canvas_equip = Canvas(window_inv, width=temp_canvas_width,
		height=temp_canvas_width, highlightthickness=0, bg=g.outline_colour)
	canvas_equip.grid(column=2, row=2, rowspan=10)
	canvas_equip.create_rectangle(0,0, temp_canvas_width-1, temp_canvas_width-1)
	#per-item borders
	for y in range(equip_size):
		for x in range(equip_size):
			canvas_equip.create_rectangle(x*g.tilesize + 2 * (x+1),
										y*g.tilesize + 2 * (y+1),
										(x+1)*(g.tilesize + 2),
										(y+1)*(g.tilesize + 2), fill=g.fill_colour)

# 	global listbox_equip
# 	listbox_equip = Listbox(window_inv, height=10, takefocus=0, bg=bgcolour)
# 	listbox_equip.grid(row=2, column=2, rowspan=10, sticky=N+W+E)


	#Location of the various buttons. Note that these are *_height, but
	#really measure width. Fix.
	global use_height; use_height = g.buttons["drop.png"].width()
	global save_height; save_height = use_height + g.buttons["use.png"].width()
	global remove_height; remove_height = save_height + g.buttons["save.png"].width()
	global leave_height; leave_height = remove_height + g.buttons["remove.png"].width()

	#Button canvas.
	global canvas_buttons
	canvas_buttons = Canvas(window_inv, height=g.buttons["leave.png"].height(),
		width=leave_height+g.buttons["leave.png"].width(), bg=bgcolour)
	canvas_buttons.grid(column=1, row=13, columnspan=2)


	#bindings
	bind_keys()

	label_help = Label(window_inv, bg=bgcolour,
		textvariable=help_text).grid(row=1, column=1, columnspan=2)

	refresh_inv()
	refresh_buttons()

	window_inv.master.wait_window(window_inv)


#bind the keys. Called upon window creation and return from a yes/no box
def bind_keys():
	canvas_inv.bind("<ButtonRelease-1>",  mouse_sel_inv)
	canvas_equip.bind("<ButtonRelease-1>",  mouse_sel_equip)
	main.window_main.bind(g.binding_cancel, key_handler_esc)
	main.window_main.bind(g.binding_action, key_handler_return)
	main.window_main.bind(g.binding_up, key_handler_up)
	main.window_main.bind(g.binding_down, key_handler_down)
	main.window_main.bind(g.binding_left, key_handler_left)
	main.window_main.bind(g.binding_right, key_handler_right)
	main.window_main.bind(g.binding_inv_left, key_handler_pgup)
	main.window_main.bind(g.binding_inv_right, key_handler_pgdn)
	canvas_buttons.bind("<ButtonRelease-1>", mouse_handler_click)
	canvas_buttons.bind("<Motion>", mouse_handler_move)
