#item.py
#Copyright (C) 2005 Free Software Foundation
#see GPL.txt for license.

#This file contains the item/inv structures and functions.

import g
#needed for reading items dir.
from os import listdir

#Item definition.
class item_class:
	def __init__(self):
		self.name = ""
		#type is 0-5 for equipment, 10-20 for items, and 99 for system items.
		self.type = 0
		#The power of the item.
		self.quality = 0
		#If price is 0, the item is un sell/buy/drop able. (For story items.)
		self.price = 0
		self.description = ""
		self.picturename = "items/dropped.png"
		self.hp_bonus = 0
		self.ep_bonus = 0
		self.attack_bonus = 0
		self.defense_bonus = 0

#equipment:
#equip[0]=weapon, [1]=armor, [2]=shield
#[3]=helmet, [4]=gloves, [5]=boots

#Contains a number, which is either the index of the
#item in the item[] array, or -1 for empty. Same deal for inv[].
equip = []
for x in range(6):
	equip.append(x)

#inventory: 28 spaces.
inv = []
for x in range(28):
	inv.append(x)

#takes the index in the item[] array, and returns the index
#of the first occurance in the inv[] array, or -1 for failure.
def find_inv_item(num):
	for i in range(len(inv)):
		if inv[i] == num:
			return i
	return -1

#takes the index of an item in the item[] array, and places it
#in the first empty spot in the inv[] array. Retuns the
#index of inv[] item is placed at, or -1 for failure.
def take_inv_item(num):
	for i in range(len(inv)):
		if inv[i] == -1:
			inv[i] = num
			return i
	return -1

#takes the index of an item in the inv[] array,
#removes it, then removes the empty space.
def drop_inv_item(num):
	inv[num] = -1
	for i in range(num+1, len(inv)):
		inv[i-1]=inv[i]
	inv[len(inv)-1] = -1

#Item arrays. Each item is a separate element in the array. Each element is
#a member of the class item_class. See the start of this file for details.
#Duplicate item names are bad.
global item
item = []

#takes an item name, and returns its location in the
#item[] array, with -1 == nonexisting.
def finditem(name):
	for i in range(len(item)):
		if name.lower() == item[i].name.lower():
			return i
	return -1


#read items directory. This is called on startup.
def read_items():
	#put the names of the available items in array_items.
	array_items = listdir(g.mod_directory + "/data/items")

	#remove all .* files.
	i = 0
	while i < len(array_items):
		extension_start = len(array_items[i]) - 4
		if(extension_start <= 0):
			array_items.pop(i)
		else:
			if array_items[i][:1] == ".":
				array_items.pop(i)
			elif array_items[i][extension_start:extension_start+4] != ".txt":
				array_items.pop(i)
			else:
				i += 1

	#go through all items, adding them to our knowledge.
	for item_filename in array_items:
		additem(item_filename)

#given the filename of an item file, load the data from the file into the
#item array.
def additem(item_filename):
	global item

	temp_name = ""
	temp_type = 0
	temp_quality = 0
	temp_price = 0
	temp_description = ""
	temp_picture = None
	item.append(item_class())
	item_array_loc = len(item)-1

	item_loc = g.mod_directory + "/data/items/" + item_filename
	item_file = open(item_loc, 'r')

	#go through all lines of the file
	item_line = item_file.readline()
	while item_line != '':
		#strip out spaces/tabs
		item_line = item_line.strip()

		#ignore blank lines and comments
		if item_line[:1] == "#" or item_line[:1] == "":
			item_line = item_file.readline()
			continue

		#Connect lines with the "\" character.
		while item_line[-1:] == "\\":  #really a single backslash, BTW.
			item_line = item_line[:-1] + item_file.readline()[:-1] #for \n

		#determine the command entered.
		item_command = item_line.split("=", 2)[0]
		item_command = item_command.strip()
		if (item_command.lower() == "name"):
			item[item_array_loc].name = str(item_line.split("=", 1)[1])
		elif (item_command.lower() == "type"):
			item[item_array_loc].type = int(item_line.split("=", 1)[1])
		elif (item_command.lower() == "quality"):
			item[item_array_loc].quality = int(item_line.split("=", 1)[1])
		elif (item_command.lower() == "price"):
			item[item_array_loc].price = int(item_line.split("=", 1)[1])
		elif (item_command.lower() == "description"):
			item[item_array_loc].description = str(item_line.split("=", 1)[1])
		elif (item_command.lower() == "picture"):
			item[item_array_loc].picturename = str(item_line.split("=", 1)[1])
		elif (item_command.lower() == "hp_bonus"):
			item[item_array_loc].hp_bonus = int(item_line.split("=", 1)[1])
		elif (item_command.lower() == "ep_bonus"):
			item[item_array_loc].ep_bonus = int(item_line.split("=", 1)[1])
		elif (item_command.lower() == "attack_bonus"):
			item[item_array_loc].attack_bonus = int(item_line.split("=", 1)[1])
		elif (item_command.lower() == "defense_bonus"):
			item[item_array_loc].defense_bonus = int(item_line.split("=", 1)[1])

		#ready another line
		item_line = item_file.readline()


	item_file.close()

#An array of dropped items. Used for keeping dropped items around
#through save/loads.
class dropped_item_class:
	def __init__(self, name, x, y, mapname):
		self.name = name
		self.x = x
		self.y = y
		self.mapname = mapname

dropped_items = []

def add_dropped_item(name, x, y, mapname):
	dropped_items.append(dropped_item_class(name, x, y, mapname))

def del_dropped_item(name, x, y, mapname):
	for i in range(len(dropped_items)):
		if dropped_items[i].name == name and dropped_items[i].x == x and \
			dropped_items[i].y == y and dropped_items[i].mapname == mapname:
				del dropped_items[i]
				return 0

def load_dropped_items():
	for dropped_item in dropped_items:
		z = g.mapname2zgrid(dropped_item.mapname)
		g.maps[z].field[dropped_item.y][dropped_item.x].additem(
														dropped_item.name)