#battle.py
#Copyright (C) 2005 Free Software Foundation
#see GPL.txt for license.

#this file controls the window_battle window.

from Tkinter import *
#needed for the buttons.
import ImageTk
import Image
import os.path #for checking on existance of monster pixs.

import g
import main
import action
import monster

mon_index = 0

mon_hp = StringVar()
hp = StringVar()
ep = StringVar()

help_text = StringVar()
return_from_yesno = StringVar()

#location of the various buttons. (Pixels from the left of the button canvas)
attack_button_loc = 0
item_button_loc = 0
skill_button_loc = 0
run_button_loc = 0

#did you run from this battle? Used for scripting.
did_run = 0

#currently selected button. 0=attack, 1=run/leave, 2=use item, 3=use skill
cur_button = 0

#Copy of monster.monster_groups[mon_index].monster_list.
#Used to reduce line length.
monster_list = []

#Current monster. Used to display stuff like description.
#Use with monster_list[cur_monster]
cur_monster = 0

#Number of times you've tried to run from this monster.
#Used to allow better chances after a while.
run_attempts = 0

#refreshes the battle view. Call after changing anything.
def refresh():
	mon_hp.set(str(monster_list[cur_monster].hp) + "/" +
										str(monster_list[cur_monster].maxhp))

	#hp/ep bars
	canvas_mon_hp.delete("show_mon_hp")
	canvas_mon_pic.itemconfig(canvas_mon_pic.find_withtag("mon_hp"),
			text=str(monster_list[cur_monster].hp) + "/" +
			str(monster_list[cur_monster].maxhp))

#	create_text(170, 168, anchor=NW, text=mon_hp, tags="mon_hp")

	temp_width = g.hpbar_width*int(monster_list[cur_monster].hp) / \
										int(monster_list[cur_monster].maxhp)
	if temp_width < 0: temp_width=0
	canvas_mon_hp.create_rectangle(0, 0, temp_width,
		g.hpbar_width/6, fill="#05BB05", tags="show_mon_hp")

	main.recalc_stats(1)

	#clear and rebuild listbox_item
	listbox_item.delete(0, END)
	for i in g.item.inv:
		if i != -1 and (g.item.item[i].type == 11 or g.item.item[i].type == 12):
			listbox_item.insert(END, g.item.item[i].name)

	#clear and rebuild listbox_skill
	listbox_skill.delete(0, END)
	for i in range(len(g.skill)):
		if g.skill[i][5] == 1 and g.skill[i][2] <= g.ep:
			listbox_skill.insert(END, g.skill[i][0] + ": "
				+ str(g.skill[i][2]) + " EP")


#attack button was pressed
def attack(event=0):
	global cur_button
	if monster_list[cur_monster].hp > 0 and g.hp > 0:
		attack_monster()
	if monster_list[cur_monster].hp > 0 and g.hp > 0:
		attack_player()
		refresh()
		refresh_buttons()

#attack the monster
def attack_monster():
	global cur_mon_hp
	#find the damage done
	damage = g.die_roll(1, g.adj_attack + 2)
	damage = damage - g.die_roll(1, monster_list[cur_monster].defense + 2)
	if damage > 0:
 		main.print_message("You hit the " + monster_list[cur_monster].name +
 			" for " + str(damage) + " damage.")
		monster_list[cur_monster].hp = monster_list[cur_monster].hp - damage
		#you kill it?
		if monster_list[cur_monster].hp <= 0:
			monster_dead()
			return 0
	else:
		main.print_message("You miss the " +
				monster_list[cur_monster].name + ".")


#monster attacks you
def attack_player():
	damage = g.die_roll(1, monster_list[cur_monster].attack + 2)
	damage = damage - g.die_roll(1, g.adj_defense + 2)
	if damage > 0:
		main.print_message("The " + monster_list[cur_monster].name +
		" hits you for " + str(damage) + " damage.")
		g.hp = g.hp - damage
		#you dead yet?
		if g.hp <= 0:
			main.print_message("The " + monster_list[cur_monster].name +
			" kills you.")
			cur_button = 1

	elif monster_list[cur_monster].hp > 0:
		main.print_message("The " + monster_list[cur_monster].name +
		" misses you.")
	refresh()

#use to reward the player for killing a monster
def monster_dead():
	#make the display look better
	monster_list[cur_monster].hp = 0
	#add info to listbox_move; add gold and xp
	main.print_message("The " + monster_list[cur_monster].name +
	" dies.")


	if len(monster_list[cur_monster].on_death) == 0:
		gold = monster_list[cur_monster].gold
		g.gold = str(int(g.gold) + gold)
		main.print_message("You find " + str(gold) + " gold,")

		exp = monster_list[cur_monster].exp
		main.print_message("and get " + str(exp) + " experience.")
		g.add_exp(exp)
	else:
		i=0
		while i < len(monster_list[cur_monster].on_death):
			temp = action.activate_line(g.xgrid, g.ygrid, g.zgrid,
				monster_list[cur_monster].on_death[i])
			if temp == "end": break
			if main.dead_yet() == 1:
				break
			i += 1

	#finish up
	window_battle.destroy()
	g.cur_window = "main"
	global did_run
	did_run = 0

#run/leave/quit button was pressed
def runaway():
	global run_attempts
	try:
		#leave/quit
		if g.hp <= 0 or monster_list[cur_monster].hp <= 0:
			window_battle.destroy()
		#Attempt to run. Testers get better chance.
		else:
			if g.die_roll(1, 10+run_attempts) > 7 or \
					(g.name == "testing123" and g.die_roll(1, 10) > 5):
				window_battle.destroy()
				main.print_message("You coward! You ran away from the "
					+ monster_list[cur_monster].name + ".")
				global did_run
				did_run = 1
			else:
				run_attempts += 1
				main.print_message("You fail to run away.")
				attack_player()
	except TclError:
		pass

#Use item button was pressed
def useitem():
	#don't do anything if anyone is dead.
	if monster_list[cur_monster].hp < 1 or g.hp < 1:
		return 0

	#put the name of the item into item_name
	if (len(listbox_item.curselection()) == 0): return 0

	try: item_num = map(int, listbox_item.curselection())
	except ValueError: pass


	item_name = listbox_item.get(item_num[0])


	#find the item[] index and item type
	item_value = g.item.finditem(item_name)
	item_type = g.item.item[item_value].type

	#if item is healing
	if item_type == 11:
		#heal the player, delete the item
		g.hp=g.hp + g.item.item[item_value].quality
		main.print_message("You are healed for " +
					str(g.item.item[item_value].quality) + " health.")
		g.item.drop_inv_item(g.item.find_inv_item(item_value))
		if g.hp >= g.adj_maxhp: g.hp = g.adj_maxhp
		attack_player()

	#if item is explosive
	if item_type == 12:
		#if monster is still alive
		if monster_list[cur_monster].hp > 0:
			damage = int(g.item.item[item_value].quality)
			g.item.drop_inv_item(g.item.find_inv_item(item_value))
			if damage > 0:
				main.print_message("The " + monster_list[cur_monster].name +
					" is hit for " + str(damage) + " damage.")
			monster_list[cur_monster].hp = monster_list[cur_monster].hp - damage
			#you kill it?
			if monster_list[cur_monster].hp <= 0:
				monster_dead()
				return 0
			else:
				attack_player()
	refresh()

	#replace the cursor
	if (listbox_item.size() != 0):
		listbox_item.selection_set(item_num[0])
		if (len(listbox_item.curselection()) == 0): #last item
			listbox_item.selection_set(END)
			listbox_item.see(END)
		else: listbox_item.see(item_num[0])
	refresh_buttons()


def useskill():
	#don't do anything if monster is dead.
	if monster_list[cur_monster].hp < 1 or g.hp < 1:
		return 0

	#get the skill name.
	if (len(listbox_skill.curselection()) == 0): return 0

	try: skill_num = map(int, listbox_skill.curselection())
	except ValueError: pass

	skill_raw_name = listbox_skill.get(skill_num[0])
	skill_array_name = skill_raw_name.split(":", 1)

	#get the skill[] index
	skill_index = g.findskill(skill_array_name[0])

	#make sure we can use that skill, just in case. . .
	if g.skill[skill_index][5] == 0 or g.skill[skill_index][2] > g.ep:
		return 0

	#pay for the skill
	g.ep = int(g.ep) - g.skill[skill_index][2]


	#actually use the skill.
	if g.skill[skill_index][1] == 0: #rage
		main.print_message("You fly into a rage.")
		#increase attack ability
		g.adj_attack += (1 + int(g.level)/4)
		main.attack.set(g.adj_attack)
		attack_player()

	elif g.skill[skill_index][1] == 1: #Sneak away
		global run_attempts
		if g.die_roll(1, 10 + int(g.level) + run_attempts) > 4:
			main.print_message("You coward! You ran away from the " +
				monster_list[cur_monster].name + ".")
			window_battle.destroy()
			global did_run
			did_run = 1
			return 0
		else:
			run_attempts += 3
			main.print_message("You fail to sneak away.")
			attack_player()
	elif g.skill[skill_index][1] == 2: #Frenzy
		for i in range(2 + int(g.level)/3):
			attack_monster()
			if monster_list[cur_monster].hp <= 0:
#				monster_dead()
				return 0
		if monster_list[cur_monster].hp > 0:
			attack_player()
	elif g.skill[skill_index][1] == 3: #Dismember
		damage = g.adj_attack * 2
		main.print_message("You hit the " + monster_list[cur_monster].name +
			" for " + str(damage) + " damage.")
		monster_list[cur_monster].hp = monster_list[cur_monster].hp - damage
		#you kill it?
		if monster_list[cur_monster].hp <= 0:
			monster_dead()
			return 0
		else:
			attack_player()

	refresh()

	#replace the cursor
	if (listbox_skill.size() != 0):
		listbox_skill.selection_set(skill_num[0])
		if (len(listbox_skill.curselection()) == 0): #last skill
			listbox_skill.selection_set(END)
			listbox_skill.see(END)
		else: listbox_skill.see(skill_num[0])
	refresh_buttons()



def refresh_buttons():
	canvas_buttons.delete(ALL)

	if (cur_button == 0):
		canvas_buttons.create_image(attack_button_loc, 0, anchor=NW,
					image=attack_button_sel)
		help_text.set("Attack the " + monster_list[cur_monster].name)
	else: canvas_buttons.create_image(attack_button_loc, 0, anchor=NW,
					image=attack_button)
	if (cur_button == 1):
		if g.hp <= 0:
			canvas_buttons.create_image(run_button_loc, 0, anchor=NW,
				image=quit_button_sel)
			help_text.set("Quit")
		elif monster_list[cur_monster].hp > 0:
			canvas_buttons.create_image(run_button_loc, 0, anchor=NW,
				image=run_button_sel)
			help_text.set("Run away")
		else:
			canvas_buttons.create_image(run_button_loc, 0, anchor=NW,
				image=leave_button_sel)
			help_text.set("Leave")
	elif g.hp <= 0: canvas_buttons.create_image(run_button_loc, 0, anchor=NW,
			image=quit_button)
	elif monster_list[cur_monster].hp > 0:
		canvas_buttons.create_image(run_button_loc,
			0, anchor=NW, image=run_button)
	else: canvas_buttons.create_image(run_button_loc, 0, anchor=NW,
			image=leave_button)

	if (cur_button == 2):
		listbox_skill.select_clear(0, END)
		canvas_buttons.create_image(item_button_loc, 0,
			anchor=NW, image=item_button_sel)
		if (len(listbox_item.curselection()) == 0):
			help_text.set("No items")
		else:
			try: item_num = map(int, listbox_item.curselection())
			except ValueError: pass
			item_name = listbox_item.get(item_num[0])
			help_text.set("Use your " + item_name)
	else: canvas_buttons.create_image(item_button_loc, 0,
			anchor=NW, image=item_button)

	if (cur_button == 3):
		listbox_item.select_clear(0, END)
		canvas_buttons.create_image(skill_button_loc, 0,
			anchor=NW, image=skill_button_sel)
		if (len(listbox_skill.curselection()) == 0):
			help_text.set("No useable skills")
		else:
			try: skill_num = map(int, listbox_skill.curselection())
			except ValueError: pass
			skill_name = listbox_skill.get(skill_num[0])
			help_text.set("Use " + skill_name)
	else: canvas_buttons.create_image(skill_button_loc, 0,
			anchor=NW, image=skill_button)


#All keypresses in window_shop pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(key_name):
	global cur_button
	if (key_name == "esc"):
		runaway()
		return 0
	elif (key_name == "right"):
		cur_button += 1
		if (cur_button == 1): cur_button = 2 #run is now at end
		elif (cur_button == 2): cur_button = 0 #run is now at end
		if (cur_button == 2): #switch to items
			if (len(listbox_item.curselection()) == 0):
				listbox_item.selection_set(0)
		if (cur_button == 3): #switch to skills
			listbox_item.select_clear(0, END)
			if (len(listbox_skill.curselection()) == 0):
				listbox_skill.selection_set(0)
		if (cur_button == 4): #switch to run
			cur_button = 1
			listbox_skill.select_clear(0, END)
	elif (key_name == "left"):
		cur_button -= 1
		if (cur_button == -1): cur_button = 1 #loop around
		elif (cur_button == 1): cur_button = 0
		elif (cur_button == 0): cur_button = 3
		#if (cur_button == 0): cur_button = 3
		if (cur_button == 0): #switch to attack
		#	cur_button = 0
			listbox_item.select_clear(0, END)
		if (cur_button == 2): #switch to items
			listbox_skill.select_clear(0, END)
			if (len(listbox_item.curselection()) == 0):
				listbox_item.selection_set(0)
		if (cur_button == 3): #switch to skills
			if (len(listbox_skill.curselection()) == 0):
				listbox_skill.selection_set(0)
	elif (key_name == "up"):
		#if (cur_button == 0): cur_button = 1
		#elif (cur_button == 1): cur_button = 0
		if (cur_button == 2):
			try: item_num = map(int, listbox_item.curselection())
			except ValueError: pass
			try:
				if (item_num[0] != 0):
					listbox_item.select_clear(0, END)
					listbox_item.selection_set(item_num[0] - 1)
					listbox_item.see(item_num[0] - 1)
				else:
					listbox_item.select_clear(0, END)
					listbox_item.selection_set(END)
					listbox_item.see(END)
			except IndexError: pass
		if (cur_button == 3):
			try:
				try: skill_num = map(int, listbox_skill.curselection())
				except ValueError: pass
				if (skill_num[0] != 0):
					listbox_skill.select_clear(0, END)
					listbox_skill.selection_set(skill_num[0] - 1)
					listbox_skill.see(skill_num[0] - 1)
				else:
					listbox_skill.select_clear(0, END)
					listbox_skill.selection_set(END)
					listbox_skill.see(END)
			except IndexError: pass

	elif (key_name == "down"):
		#if (cur_button == 0): cur_button = 1
		#elif (cur_button == 1): cur_button = 0
		if (cur_button == 2):
			try: item_num = map(int, listbox_item.curselection())
			except ValueError: pass
			try:
				if (item_num[0] != listbox_item.size() - 1):
					listbox_item.select_clear(0, END)
					listbox_item.selection_set(item_num[0] + 1)
					listbox_item.see(item_num[0] + 1)
				else:
					listbox_item.select_clear(0, END)
					listbox_item.selection_set(0)
					listbox_item.see(0)
			except IndexError: pass
		elif (cur_button == 3):
			try: skill_num = map(int, listbox_skill.curselection())
			except ValueError: pass
			try:
				if (skill_num[0] != listbox_skill.size() - 1):
					listbox_skill.select_clear(0, END)
					listbox_skill.selection_set(skill_num[0] + 1)
					listbox_skill.see(skill_num[0] + 1)
				else:
					listbox_skill.select_clear(0, END)
					listbox_skill.selection_set(0)
					listbox_skill.see(0)
			except IndexError: pass

	elif (key_name == "return"):
		if (cur_button == 0):
			attack()
			return 0
		elif (cur_button == 1):
			runaway()
			return 0
		elif (cur_button == 2):
			useitem()
			return 0
		elif (cur_button == 3):
			useskill()
			return

	refresh_buttons()



def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")

def mouse_handler_click(event=0):
	mouse_handler_move(event)
	key_handler("return")

def mouse_handler_item(event=0):
	global cur_button; cur_button = 2
	refresh_buttons()

def mouse_handler_skill(event=0):
	global cur_button; cur_button = 3
	refresh_buttons()

def mouse_handler_move(event=0):
	global cur_button
	if (event.x < item_button_loc):
		cur_button = 0
		listbox_item.select_clear(0, END)
		listbox_skill.select_clear(0, END)
	elif (event.x < skill_button_loc):
		cur_button = 2
		listbox_skill.select_clear(0, END)
		if (len(listbox_item.curselection()) == 0):
			listbox_item.selection_set(0)
	elif (event.x < run_button_loc):
		cur_button = 3
		listbox_item.select_clear(0, END)
		if (len(listbox_skill.curselection()) == 0):
			listbox_skill.selection_set(0)
	else:
		cur_button = 1
		listbox_item.select_clear(0, END)
		listbox_skill.select_clear(0, END)
	refresh_buttons()


#Like show_yesno in main, but only expects one or two lines,
#and creates the canvas used.
def battle_show_yesno(line=""):
	action.has_dialog = 1
	global active_button
	active_button = 0
	global return_from_yesno
	return_from_yesno.set("0")

	canvas_width = no_button.width()*4/3+yes_button.width()*4/3
	canvas_height = yes_button.height()+50
	global canvas_battle2
	canvas_battle2 = Canvas(window_battle, width=canvas_width,
		height=canvas_height, highlightthickness=0)
	canvas_battle2.grid(column=1, row=2, columnspan=2, rowspan=7, sticky="S")

	#background
	canvas_battle2.create_rectangle(0, 0, canvas_width, canvas_height,
		fill=g.fill_colour, outline="Black", tags="background_box")
	#text
	canvas_battle2.create_text(3, 3, text=line, anchor="nw",
		width=canvas_width-6, tags="dialogtxt")
	#buttons
	canvas_battle2.create_image(canvas_width/2,
		canvas_height, image=no_button_sel, anchor="se", tags="no")
	canvas_battle2.create_image(canvas_width/2,
		canvas_height, image=yes_button, anchor="sw", tags="yes")
	#bindings
	main.window_main.bind(g.binding_up, change_yesno_sel)
	main.window_main.bind(g.binding_right, change_yesno_sel)
	main.window_main.bind(g.binding_left, change_yesno_sel)
	main.window_main.bind(g.binding_down, change_yesno_sel)
	main.window_main.bind(g.binding_action, activate_yesno)
	canvas_battle2.tag_bind("no", "<Enter>", change_yesno_to_no)
	canvas_battle2.tag_bind("yes", "<Enter>", change_yesno_to_yes)
	canvas_battle2.tag_bind("no", "<Button-1>", activate_yesno)
	canvas_battle2.tag_bind("yes", "<Button-1>", activate_yesno)

	canvas_buttons.bind("<ButtonRelease-1>", do_nothing)
	canvas_buttons.bind("<Motion>", do_nothing)
	listbox_item.bind("<ButtonRelease-1>", do_nothing)
	listbox_skill.bind("<ButtonRelease-1>", do_nothing)

	#wait. Continue after activate_yesno() is run.
	window_battle.wait_variable(return_from_yesno)
	#cleanup
	try: canvas_battle2.destroy()
	except TclError: return 1

	bind_keys()

	action.has_dialog = 0
	return active_button


#when a yesno dialog box is active, switch to yes.
def change_yesno_to_yes(event=None):
	global active_button
	active_button = 1
	canvas_battle2.itemconfigure("no", image=no_button)
	canvas_battle2.itemconfigure("yes", image=yes_button_sel)

#when a yesno dialog box is active, switch to no.
def change_yesno_to_no(event=None):
	global active_button
	active_button = 0
	canvas_battle2.itemconfigure("no", image=no_button_sel)
	canvas_battle2.itemconfigure("yes", image=yes_button)

#when a yesno dialog box is active, switch the yes and no buttons.
def change_yesno_sel(event=None):
	if active_button == 0: change_yesno_to_yes()
	else: change_yesno_to_no()

#called on Return when the yesno dialog box is active.
def activate_yesno(event=None):
	global return_from_yesno
	return_from_yesno.set("1")


#start a battle.
def begin(mon_index_input):

	global window_battle
	global bgcolour
	bgcolour = "lightgrey"
	window_battle = Frame(main.top, bd=2, relief=SUNKEN, bg=bgcolour)
	window_battle.grid(row=1, column=5, columnspan=13, rowspan=13, sticky=E)
	global mon_index
	mon_index = mon_index_input
	global monster_list
	monster_list = []
	for line in monster.monster_groups[mon_index].monster_list:
		monster_list.append(monster.monsters[monster.monster_name_to_index(line)])
	for i in range(len(monster_list)):
		monster_list[i].reset()

	global did_run
	did_run = 0
	global cur_button
	cur_button = 0
	global cur_monster
	cur_monster = 0
	global run_attempts
	run_attempts = 0

	global yes_button; global yes_button_sel
	global no_button; global no_button_sel
	yes_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/yes.png")
	no_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/no.png")
	yes_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
                "/images/buttons/yes_sel.png")
	no_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
                "/images/buttons/no_sel.png")

	# Set the current window
	g.cur_window = "battle"



	global canvas_desc
	canvas_desc = Canvas(window_battle, width=200, height=190,
		highlightthickness=0, bg=bgcolour)
	canvas_desc.grid(row=2, column=1, sticky=NSEW)
	canvas_desc.create_text(1, 5, anchor=NW,
			text=monster_list[cur_monster].description, width=195)

	pic_frame = Frame(window_battle, bd=2, relief=SUNKEN, bg="#327a22")
	pic_frame.grid(row=1, column=2, columnspan=3, rowspan=6, sticky=E)

	global canvas_mon_pic
	background_pic = g.maps[g.zgrid].battle_background
	if os.path.isfile(g.mod_directory +
			"/images/tiles/monsters/" + monster_list[cur_monster].name + ".png"):
		monster_pic = ImageTk.PhotoImage(file=g.mod_directory +
			"/images/tiles/monsters/" + monster_list[cur_monster].name + ".png")
	else:
		monster_pic = ImageTk.PhotoImage(file=g.mod_directory +
			"/images/tiles/monsters/generic.png")
	canvas_mon_pic = Canvas(pic_frame,
		height=background_pic.height(),
		width=background_pic.width())
	canvas_mon_pic.grid(column=2, row=1, rowspan=5, sticky=NW)
	canvas_mon_pic.create_image(0, 0, anchor=NW, image=background_pic)
	canvas_mon_pic.create_image(background_pic.width()/2, 10, anchor=N, image=monster_pic)


	global canvas_mon_hp
	canvas_mon_hp = Canvas(pic_frame, width=g.hpbar_width,
		height=g.hpbar_width/6, highlightthickness=0)
	canvas_mon_hp.grid(column=2, row=5)
	canvas_mon_hp.create_rectangle(0, 0, g.hpbar_width,
		g.hpbar_width/6, fill="#EE0505")


	#formatting for the labels.
	label_formatting = Label(window_battle,
			text=monster_list[cur_monster].name, bg=bgcolour).grid(row=1,
			column=1, columnspan=2)

	canvas_mon_pic.create_text(25, 168, anchor=NW, text="HP:")
	canvas_mon_pic.create_text(152, 168, anchor=NW, text=mon_hp, tags="mon_hp")

	#stat display
#	label_mon_hp = Label(pic_frame, textvariable=mon_hp,
#		bg="#327a22").grid(row=5, column=2, sticky=E, padx=2)

	label_attack = Label(window_battle, text="Attack: " +
	str(monster_list[cur_monster].attack), bg=bgcolour).grid(row=4,
			column=1, sticky=W)
	label_defend = Label(window_battle, text="Defense: " +
	str(monster_list[cur_monster].defense), bg=bgcolour).grid(row=4,
			column=1, sticky=E)

	#help text
	label_text = Label(window_battle,
		textvariable=help_text, bg=bgcolour)
	label_text.grid(column=1, row=5, columnspan=2)
	window_battle.update_idletasks()
	window_battle.columnconfigure(1, minsize=canvas_mon_pic.winfo_width())


	button_frame = Frame(window_battle, bg=bgcolour)
	button_frame.grid(row=14, column=1, columnspan=2, sticky="NSEW")

	#Attack and run buttons.
	global attack_button; global attack_button_sel
	global run_button; global run_button_sel
	global quit_button; global quit_button_sel
	global leave_button; global leave_button_sel
	global item_button; global item_button_sel
	global skill_button; global skill_button_sel

	attack_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/attack.png")
	run_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/run.png")
	attack_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/attack_sel.png")
	run_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/run_sel.png")
	quit_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/quit_battle.png")
	leave_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/leave.png")
	item_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/use.png")
	skill_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/skill.png")
	quit_button_sel = \
		ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/quit_battle_sel.png")
	leave_button_sel = \
		ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/leave_sel.png")
	item_button_sel = \
		ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/use_sel.png")
	skill_button_sel = \
		ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/skill_sel.png")

	global item_button_loc
	global skill_button_loc
	global run_button_loc
	item_button_loc = attack_button.width()
	skill_button_loc = item_button_loc + item_button.width()
	run_button_loc = skill_button_loc + skill_button.width()

	global canvas_buttons
	canvas_buttons = Canvas(button_frame, bg="#b3b3b3",
		height=attack_button.height(),
		width=attack_button.width() + run_button.width() +
		item_button.width() + skill_button.width())
	canvas_buttons.grid(column=1, row=1, sticky="NSEW")

	#use item listbox
	item_label = Label(window_battle, text='Items', bg=bgcolour)
	item_label.grid(row=9, column=1, sticky=N)

	global listbox_item
	listbox_item = Listbox(window_battle, height=5, bg=bgcolour)
	listbox_item.grid(row=9, column=1, rowspan=5, sticky=N+S+E+W)
	global item_scroll
	item_scroll = Scrollbar(window_battle, command=listbox_item.yview,
		bg=bgcolour)
	item_scroll.grid(row=9, column=1, rowspan=5, sticky=N+S+E)
	listbox_item.config(yscrollcommand=item_scroll.set)

	#use skill listbox
#	skill_frame = Frame(window_battle, background="#003300")
#	skill_frame.grid(row=9, column=3, sticky=N+S+E+W)

	skill_label = Label(window_battle, text='Skills', bg=bgcolour)
	skill_label.grid(row=9, column=2, sticky=N)

	global listbox_skill
	listbox_skill = Listbox(window_battle, height=5, bg=bgcolour)
	listbox_skill.grid(row=9, column=2, rowspan=5, sticky="NSEW")
	global skill_scroll
	skill_scroll = Scrollbar(window_battle, command=listbox_skill.yview,
		bg=bgcolour)
	skill_scroll.grid(row=9, column=2, rowspan=5, sticky=N+S+E)
	listbox_skill.config(yscrollcommand=skill_scroll.set)
	window_battle.update_idletasks()
	window_battle.columnconfigure(2, minsize=pic_frame.winfo_width())


	#bindings
	bind_keys()

	main.print_message("The " + monster.monster_groups[mon_index].name +
		" attacks you.")

	refresh()
	refresh_buttons()

	#keep the window_main window asleep until this one is closed.
	window_battle.master.wait_window(window_battle)
	return did_run


#bind the keys. Called upon window creation and return from a yes/no box
def bind_keys():
	main.window_main.bind(g.binding_attack, attack)
	main.window_main.bind(g.binding_cancel, key_handler_esc)
	main.window_main.bind(g.binding_action, key_handler_return)
	main.window_main.bind(g.binding_up, key_handler_up)
	main.window_main.bind(g.binding_down, key_handler_down)
	main.window_main.bind(g.binding_left, key_handler_left)
	main.window_main.bind(g.binding_right, key_handler_right)
	main.window_main.bind(g.binding_inv, key_handler)
	main.window_main.bind(g.binding_save, key_handler)
	main.window_main.bind(g.binding_quit, key_handler)

	canvas_buttons.bind("<ButtonRelease-1>", mouse_handler_click)
	canvas_buttons.bind("<Motion>", mouse_handler_move)
	listbox_item.bind("<ButtonRelease-1>", mouse_handler_item)
	listbox_skill.bind("<ButtonRelease-1>", mouse_handler_skill)

def do_nothing(event=0):
	pass
