#file: map_editor.py
#Copyright (C) 2004 Free Software Foundation
#see GPL.txt for license.

# This file runs a map editing program.
# Currently, loading maps does not work.
# Author: Allison Marles
# Date: Sept.1, 2004

from Tkinter import *
#needed for the tiles.
import ImageTk
import Image
#import re
from os import path, mkdir, remove, walk, listdir, getcwd
import tkMessageBox
import load_map
import re

import g
import scripting

mapsize_x =15
mapsize_y =15

portal_x = 0
portal_y = 0
portalsize = 15

bgcolour='lightgrey'
window = Toplevel()
window.master.withdraw()
window.title("Map Editor")

cur_tile = ""
cur_tile_num = 0
cur_mode = "replace"
border = "rock.png"
background = "grass.png"
map_name = "map.txt"
tile_set_size = 0
tilebox_width = 4
tilegrid = 0 #whether or not to display the map grid
cur_map = "" #this will normally be a g.map class.
global dirnames
dirnames = []
#all possible items so we can make unique variables for each one
global item_list
item_list = {"blank": 4}

#create a new map. Set mapsize_* first.
def create_map():
	global top
	try: top.destroy() #used to prevent memory leaks.
	except NameError: pass
	top = Frame(window,bd=2, relief=SUNKEN, bg=bgcolour);
	top.grid(row=1, column=1, sticky=E)

	#this creates the actual map.
	global cur_map
	cur_map = g.map("")
	#g.maps.append(g.map(map_name))
	#g.zgrid = len(g.maps) -1

	cur_map.field.append([])
	for y in range(mapsize_x): #upper border
		cur_map.field[0].append(g.tile(""))
		cur_map.field[0][len(cur_map.field[0])-1].onload.append("pix " + border)
		cur_map.field[0][len(cur_map.field[0])-1].onload.append("walk 0")

	for x in range(mapsize_y-2):
		cur_map.field.append([])
		cur_map.field[x+1].append(g.tile("")) #left border
		cur_map.field[x+1][0].onload.append("pix " + border)
		cur_map.field[x+1][0].onload.append("walk 0")
		for y in range(mapsize_x - 2):
			cur_map.field[x+1].append(g.tile("")) #inside
			cur_map.field[x+1][len(cur_map.field[x+1])-1].onload.append("pix " + background)
			cur_map.field[x+1][len(cur_map.field[x+1])-1].onload.append("walk 1")
		cur_map.field[x+1].append(g.tile("")) #right border
		cur_map.field[x+1][len(cur_map.field[x+1])-1].onload.append("pix " + border)
		cur_map.field[x+1][len(cur_map.field[x+1])-1].onload.append("walk 0")

	cur_map.field.append([])
	map_len = len(cur_map.field)-1
	for y in range(mapsize_x):
		cur_map.field[map_len].append(g.tile("")) #lower border
		cur_map.field[map_len][len(cur_map.field[map_len])-1].onload.append("pix " + border)
		cur_map.field[map_len][len(cur_map.field[map_len])-1].onload.append("walk 0")

	global canvas_map
	canvas_map = Canvas(top, width=g.tilesize*portalsize,
		height=g.tilesize*portalsize, highlightthickness=0)
	canvas_map.grid(column=0, row=0)
	global y_scroll
	y_scroll = Scrollbar(top, orient=VERTICAL, command=map_from_scroll_y)
	y_scroll.grid(column=1, row=0, sticky=NS)
	global x_scroll
	x_scroll = Scrollbar(top, orient=HORIZONTAL, command=map_from_scroll_x)
	x_scroll.grid(column=0, row=1, sticky=EW)

	canvas_map.bind("<Button-1>", map_callback)
	canvas_map.bind("<Button-4>", move_up)
	canvas_map.bind("<Button-5>", move_down)
	canvas_map.bind("<B1-Motion>", map_callback)
	window.bind("<Up>", move_up)
	window.bind("<Down>", move_down)
	window.bind("<Left>", move_left)
	window.bind("<Right>", move_right)
	global portal_x
	global portal_y
	portal_x = 0
	portal_y = 0

	refresh_map()
	scroll_from_map()

def move_up(event=None):
	global portal_y
	if portal_y > 0:
		portal_y -= 1
	refresh_map()

def move_down(event=None):
	global portal_y
	if portal_y + portalsize < mapsize_y:
		portal_y += 1
	refresh_map()

def move_left(event=None):
	global portal_x
	if portal_x > 0:
		portal_x -= 1
	refresh_map()

def move_right(event=None):
	global portal_x
	if portal_x + portalsize < mapsize_x:
		portal_x += 1
	refresh_map()

def map_callback(event):
	if(cur_tile != "" or cur_mode == "remove"):
		set_tile((event.x / g.tilesize)+portal_x, (event.y / g.tilesize)+portal_y, cur_tile)

#set mode to add, replace, or remove
def set_mode(mode):
    global cur_mode
    cur_mode = mode

#set all interior tiles to background tile
def set_bkg(bkg):
	for y in range(mapsize_y-2):
		for x in range(mapsize_x - 2):
			cur_map.field[y+1][x+1].onload = []
			cur_map.field[y+1][x+1].onload.append("pix " + bkg)
			cur_map.field[y+1][x+1].onload.append("walk 1")
	refresh_map()

#what will appear around edges of map (must be walk 0 to keep hero penned in)
def set_border(edge):
	for y in range(mapsize_y):
		cur_map.field[y][0].onload = []
		cur_map.field[y][0].onload.append("pix " + edge)
		cur_map.field[y][0].onload.append("walk 0")
		temp_len = len(cur_map.field[y])-1
		cur_map.field[y][temp_len].onload = []
		cur_map.field[y][temp_len].onload.append("pix " + edge)
		cur_map.field[y][temp_len].onload.append("walk 0")
	for x in range(mapsize_x):
		cur_map.field[0][x].onload = []
		cur_map.field[0][x].onload.append("pix " + edge)
		cur_map.field[0][x].onload.append("walk 0")
		temp_len = len(cur_map.field)-1
		cur_map.field[temp_len][x].onload = []
		cur_map.field[temp_len][x].onload.append("pix " + edge)
		cur_map.field[temp_len][x].onload.append("walk 0")

	refresh_map()

#refresh map.
def refresh_map():
	canvas_map.delete(ALL)
	for y in range(portal_y, portal_y+portalsize):
		if y >= mapsize_y: return
		for x in range(portal_x, portal_x+portalsize):
			if x >= mapsize_x: break
			for line in cur_map.field[y][x].onload:
				if line.strip().split()[0].strip().lower() == "pix" or \
				line.strip().split()[0].strip().lower() == "addpix":
					canvas_map.create_image((x-portal_x)*g.tilesize,
						(y-portal_y)*g.tilesize, anchor=NW,
						image=g.tiles[line.strip().split()[1].strip()])
				elif len(line.strip().split()) >= 8 and \
				line.strip().split()[6].strip().lower() == "addpix":
					canvas_map.create_image((x-portal_x)*g.tilesize,
						(y-portal_y)*g.tilesize, anchor=NW,
						image=g.tiles[line.strip().split()[7].strip()])
	scroll_from_map()

#set tile at x, y to name.
def set_tile(x, y, name):
	if x >= mapsize_x: return
	if y >= mapsize_y: return

	#if the tile is an item, add it to the current tile
	tile_prefix = name.split("/", 1)[0]
	if tile_prefix == "items":
		add_item(x, y, name)
	elif cur_mode == "add":
	    	cur_map.field[y][x].onload.append("addpix " + name);
	elif cur_mode == "remove":
	   	cur_map.field[y][x].onload = []
		cur_map.field[y][x].onload.append("pix " + background)
                cur_map.field[y][x].onload.append("walk 1")
	else:
		temp_name = name
		for line_num in range(len(cur_map.field[y][x].onload)):
			if cur_map.field[y][x].onload[line_num].split()[0].strip().lower() == "pix":
				cur_map.field[y][x].onload[line_num] = "pix " + name
				temp_name = name
		for line_num in range(len(cur_map.field[y][x].onload)):
			if cur_map.field[y][x].onload[line_num].split()[0].strip().lower() == "walk":
				cur_map.field[y][x].onload[line_num] = "walk " + walk[temp_name]
	refresh_map()

#add name item to tile at x, y
def add_item(x, y, name):
	item = name.split("/", 1)[1]
	item = item[0:len(item)-4]
	item_name = re.sub("_", " ", item)
	var_name = item + "_found" + str(item_list[name])
	item_list[name] += 1
	cur_map.field[y][x].onload.append("if var " + var_name + " | end | addpix " + name)
	global amount
	amount = "AMOUNT"
	set_item_amount()
	cur_map.field[y][x].actions.append("if var " + var_name + "| end | pass")
	cur_map.field[y][x].actions.append("if find \""  + item_name + "\" " + amount + " | set " + var_name + " = 1 | end")
	cur_map.field[y][x].actions.append("delpix " + name)

def set_item_amount():
	temp_amount = StringVar()
	global amount_window
	amount_window = Toplevel(window)
	label_format = Label(amount_window, text="Item Amount: \n")
	label_format.grid(row=0, column=0, sticky=E)
	amount_textbox = Entry(amount_window, textvariable=temp_amount)
	amount_textbox.grid(row=0, column=1, sticky=W)
	ok_button = Button(amount_window, text="OK",
		command=(lambda: really_set_amount( temp_amount.get())))
	ok_button.grid(row=2, column=0)
	cancel_button = Button(amount_window, text="Cancel",
		command=(lambda: close_amount_window()))
	cancel_button.grid(row=2, column=1)
	amount_window.master.wait_window(amount_window)

def really_set_amount(temp_amount):
	try:
		amount_window.destroy()
	except:
		pass
	global amount
	amount = temp_amount

def close_amount_window():
	amount_window.destroy()

def map_from_scroll_y(scrolltype, step, what=None):
	global portal_y
	if scrolltype=="moveto":
		portal_y = int(float(step)*mapsize_y)
		if portal_y+portalsize > mapsize_y: portal_y = mapsize_y - portalsize
		if portal_y < 0: portal_y = 0
		refresh_map()
	else:
		if what=="units":
			if step=="1": move_down()
			else: move_up()
		else:
			if step=="1":
				portal_y += 5
				if portal_y+portalsize > mapsize_y: portal_y = mapsize_y - portalsize
			else:
				portal_y -= 5
				if portal_y < 0: portal_y = 0
			refresh_map()

def map_from_scroll_x(scrolltype, step, what=None):
	global portal_x
	if scrolltype=="moveto":
		portal_x = int(float(step)*mapsize_x)
		if portal_x+portalsize > mapsize_x: portal_x = mapsize_x - portalsize
		if portal_x < 0: portal_x = 0
		refresh_map()
	else:
		if what=="units":
			if step=="1": move_right()
			else: move_left()
		else:
			if step=="1":
				portal_x += 5
				if portal_x+portalsize > mapsize_x: portal_x = mapsize_x - portalsize
			else:
				portal_x -= 5
				if portal_x < 0: portal_x = 0
			refresh_map()

def scroll_from_map():
	scrolltop = float(portal_y)/mapsize_y
	scrollbot = float((portal_y+portalsize))/mapsize_y
	y_scroll.set(scrolltop, scrollbot)

	scrollleft = float(portal_x)/mapsize_x
	scrollright = float((portal_x+portalsize))/mapsize_x
	x_scroll.set(scrollleft, scrollright)

#this loads the various tiles.
def load_tiles():
	global tiles
	tiles = {"blank" : ImageTk.PhotoImage("RGB", (g.tilesize, g.tilesize))}
	global tilenames
	tilenames= []
	global num_tiles
	num_tiles = 0

	for root, dirs, files in walk(g.mod_directory + "/images/tiles/"):
		(head, tail) = path.split(root)
		if (tail != "CVS"):
			for tilename in files:
				num_tiles = num_tiles + 1
				#if image is in a sub-dir:
				if (root != g.mod_directory + "/images/tiles/"):
					i = len(g.mod_directory + "/images/tiles/")
					tilenames.append(root[i:] + "/" + tilename)
					tiles[root[i:] + "/" + tilename] = \
					ImageTk.PhotoImage(file=root + "/" + tilename)
				else: #if image is in root dir
					tilenames.append(tilename)
					tiles[tilename] = \
						ImageTk.PhotoImage(file=root + "/" + tilename)
	get_walk_values()

def get_walk_values():
	global walk
	walk = {"blank" : StringVar}
	walk_defs_loc = g.mod_directory + "/data/" + "walk_defs.txt"
	walk_defs = open(walk_defs_loc, 'r')
	#read lines, store in walk[tilename] = 1 or 0
	walk_line = walk_defs.readline()
	while walk_line != '' and walk_line[:1] != ":":
		#strip out leading and trailing whitespace
		walk_line = walk_line.strip()

		#ignore blank lines and comments
		if walk_line[:1] == "#" or walk_line[:1] == "" or walk_line[:1] == "\n":
			walk_line = walk_defs.readline()
			continue

		#add the line
		line = walk_line.split(" ")
		walk[line[0]] = line[1]

		#ready another line
		walk_line = walk_defs.readline()


def set_codes():
	global codes
	codes = []
	#This gives me a few thousand tiles per map.
	for i in  "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789":
		for j in "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789":
			codes.append(i + j)

#set current tile to work with
def choose_tile(file, num):
	global cur_tile
	global cur_tile_num
	cur_tile = file
	cur_tile_num = num
	refresh_tiles()

#set up tile
def setup_tilebox():
	global bottom
	bottom = Frame(window,bd=2, relief=SUNKEN, bg="lightgreen");
	bottom.grid(row=1, column=mapsize_x+2, columnspan=num_tiles/mapsize_x, sticky=E)
	#this creates the tile display portion
	global tilebox
	tilebox = []

# show tile set as buttons
def display_tiles(set = "default"):
	global bottom
	bottom.destroy()
	bottom = Frame(window,bd=2, relief=SUNKEN, bg="lightgreen");
	bottom.grid(row=1, column=mapsize_x+2, columnspan=tilebox_width, sticky=NE)
	cur_row = 1
	col_start = mapsize_x+1
	col_span = tilebox_width
	cur_col = col_start
	cur = 0
	global tile_set_size
	tile_set_size = 0

	for file in tilenames:
		file_prefix = file.split("/", 1)[0]
		end_in_png = file_prefix[len(file_prefix)-4:len(file_prefix)]
		#if not in a sub-dir, then this tile is in default set
		if(end_in_png == ".png"):
			file_prefix = "default"

		#only show tiles in appropriate set (ie. correct subdir)
		if(file_prefix == set):
		    tile_set_size = tile_set_size + 1
		    if cur_col == col_start + col_span:
			cur_row = cur_row + 1
			cur_col = col_start
		    tilebox.append(cur)
		    tilebox[cur] = Button(bottom, image=tiles[file], borderwidth=1,
				    bg="black", activebackground = "red",
				    command=(lambda x=file, y=cur:choose_tile(x, y)))
		    tilebox[cur].grid(column=cur_col, row=cur_row)
		    cur_col = cur_col + 1
		    cur = cur + 1

def refresh_tiles():
	for cur in range(tile_set_size):
		tile_button = tilebox[cur]
		if(cur != cur_tile_num):
			tile_button.config(bg="black")
		else:
			tile_button.config(bg="red")

def quit_command(event=0):
	try:
		window.destroy()
		try: window_sel_game.destroy()
		except NameError: pass
		raise SystemExit
	except TclError:
		pass

def check_repeat_tile(x, y):
	for in_y in range(y):
		for in_x in range(mapsize_x): #for each previous tile.
			if tiles_equal(cur_map.field[y][x], cur_map.field[in_y][in_x]) == 1:
				cur_map.field[y][x].name = cur_map.field[in_y][in_x].name
				return 1
	for in_x in range(x):
		if tiles_equal(cur_map.field[y][x], cur_map.field[y][in_x]) == 1:
			cur_map.field[y][x].name = cur_map.field[y][in_x].name
			return 1
	return 0

#save map to map dir and call it map.txt
def save_map(event=0):
	set_codes()
	map_loc = g.mod_directory + "/data/maps/" + map_name
	print "Saving map to " + map_loc
	map_file = open(map_loc, 'w')
	count = 0
	for y in range(mapsize_y):
		for x in range(mapsize_x): #for each tile
			if(check_repeat_tile(x, y) == 0): #if tile was not repeated
				cur_map.field[y][x].name = codes[count]
				count += 1

	for y in range(mapsize_y):
		string = ""
		for x in range(mapsize_x): #for each tile
			string += cur_map.field[y][x].name + " "
		map_file.write(string + "\n")

	map_file.write("\n:def\n")
	for monster_name in cur_map.monster:
		map_file.write("monster=" + monster_name + "\n")

	#use the upper-left tile as background.
	map_file.write(":a\n" + "pix ")
	for onload_line in cur_map.field[0][0].onload:
		if onload_line.split()[0].strip().lower() == "pix":
			map_file.write(onload_line + "\n")
			break

	map_file.write("walk 0" + "\n")
	for tile_type in range(count): #for each tile type.
		map_file.write(":" + codes[tile_type] + "\n")
		for y in range(mapsize_y): #Find an example of that tile.
			for x in range(mapsize_x):
				if cur_map.field[y][x].name == codes[tile_type]:
					for onload_line in cur_map.field[y][x].onload:
						map_file.write(onload_line + "\n")
					if len(cur_map.field[y][x].actions) > 0:
						map_file.write("Action\n")
					for actions_line in cur_map.field[y][x].actions:
						map_file.write(actions_line + "\n")
					break
			else: continue #bit confusing here; this breaks out of both loops
			break          #when the tile is found.

	map_file.close()

#loads the loadmap window, then loads the returned map into cur_map.
def do_load_map():
	if (load_map.init_window() == 0): return
	g.zgrid = g.mapname2zgrid(load_map.mapname)
	global cur_map
	cur_map = g.map("")
	copy_map(cur_map, g.maps[g.zgrid])
	global mapsize_x
	mapsize_x = len(cur_map.field[0])
	global mapsize_y
	mapsize_y = len(cur_map.field)
	global portal_x
	global portal_y
	portal_x = 0
	portal_y = 0
	refresh_map()
	scroll_from_map()

#given input and output maps, copies the important parts.
def copy_map(output_map, input_map):
	output_map.name = input_map.name
	global map_name
	map_name = output_map.name
	for y in range(len(input_map.field)):
		output_map.field.append([])
		for x in range(len(input_map.field[y])):
			output_map.field[y].append(g.tile(""))
			copy_tile(output_map.field[y][x], input_map.field[y][x])
	for monster in input_map.monster:
		output_map.monster.append(monster)

#given input and output tiles, copies the important parts.
def copy_tile(output_tile, input_tile):
	output_tile.walk = input_tile.walk
	for line in input_tile.onload:
		output_tile.onload.append(line)
	for line in input_tile.actions:
		output_tile.actions.append(line)

#given two tiles, return 1 if they are equal, 0 if not.
#Checks onload and actions.
def tiles_equal(tile1, tile2):
	if len(tile1.onload) != len(tile2.onload):
		return 0
	if len(tile1.actions) != len(tile2.actions):
		return 0
	for x in range(len(tile2.onload)):
		if tile1.onload[x] != tile2.onload[x]:
			return 0
	for x in range(len(tile2.actions)):
		if tile1.actions[x] != tile2.actions[x]:
			return 0
	return 1


#brings up the monster edit window.
def edit_monsters(i):
	global monster_window
	monster_window = Toplevel(window)
	monster_window.title("Edit Monsters:")

	monster_textbox = Text(monster_window, width=50, height=8)
	for monster_name in cur_map.monster:
		monster_textbox.insert(END, monster_name + "\n")
	monster_textbox.grid(row=0, column=0, columnspan=2)

	ok_button = Button(monster_window, text="OK",
		command=(lambda: change_monsters(monster_textbox.get(1.0, END))))
	ok_button.grid(row=2, column=0)
	cancel_button = Button(monster_window, text="Cancel",
		command=(lambda: close_monster_window()))
	cancel_button.grid(row=2, column=1)
	monster_window.master.wait_window(monster_window)

#given a \n separated list of monsters, place into the monster list
def change_monsters(monster_text):
	cur_map.monster = []
	monster_array = monster_text.split("\n")
	for monster_name in monster_array:
		if monster_name.strip() != "":
			cur_map.monster.append(monster_name)
	close_monster_window()

def close_monster_window():
	try:
		monster_window.destroy()
	except: pass



#brings up the change mapsize window.
def change_mapsize(size):
	temp_x = StringVar()
	temp_y = StringVar()
	global size_window
	size_window = Toplevel(window)
	label_format = Label(size_window, text="Width")
	label_format.grid(row=0, column=0, sticky=E)
	label_format = Label(size_window, text="Height")
	label_format.grid(row=1, column=0, sticky=E)
	width_textbox = Entry(size_window, textvariable=temp_x)
	width_textbox.grid(row=0, column=1, sticky=W)
	height_textbox = Entry(size_window, textvariable=temp_y)
	height_textbox.grid(row=1, column=1, sticky=W)
	ok_button = Button(size_window, text="OK",
		command=(lambda: really_change_mapsize(temp_x.get(), temp_y.get())))
	ok_button.grid(row=2, column=0)
	cancel_button = Button(size_window, text="Cancel",
		command=(lambda: close_size_window()))
	cancel_button.grid(row=2, column=1)
	size_window.master.wait_window(size_window)

#given x and y in tiles, resizes the map, destroying and creating tiles as needed.
def really_change_mapsize(x, y):
	try: size_window.destroy()
	except: pass
	global mapsize_x
	global mapsize_y
	mapsize_x = int(x)
	mapsize_y = int(y)
	if len(cur_map.field) > int(y):
		for tmpy in range(len(cur_map.field) - int(y)):
			cur_map.field.pop()
	elif len(cur_map.field) < int(y):
		for tmpy in range(int(y) - len(cur_map.field)):
			cur_map.field.append([])
	for tmpy in range(len(cur_map.field)):
		if len(cur_map.field[tmpy]) > int(x):
			for tmpx in range(len(cur_map.field[tmpy]) - int(x)):
				cur_map.field[tmpy].pop()
		elif len(cur_map.field[tmpy]) < int(x):
			for tmpx in range(int(x) - len(cur_map.field[tmpy])):
				cur_map.field[tmpy].append(g.tile(""))
				cur_map.field[tmpy][len(cur_map.field[tmpy])-1].onload.append("pix " + background)
				cur_map.field[tmpy][len(cur_map.field[tmpy])-1].onload.append("walk 0")

	global portal_x
	global portal_y
	portal_x = 0
	portal_y = 0
	line = "Reset border and background for new map size ? "  \
		"(This will clear the contents of the map.)"
	if ask_yesno(line):
		set_border(border)
		set_bkg(background)
	refresh_map()

def close_size_window():
	size_window.destroy()

def ask_yesno(line=None):
	if window.state() != "normal": return 0
	return tkMessageBox.askyesno("Map Editor Question", line, parent=window)

def toggle_grid():
	global tilegrid
	if tilegrid == 0:
		tilegrid = 1
		g.tilesize += 1
	elif tilegrid == 1:
		tilegrid = 0
		g.tilesize -= 1
	canvas_map.config(width=g.tilesize*portalsize, height=g.tilesize*portalsize)
	refresh_map()

def make_menus():
	global menubar
	menubar = Frame(window, bg=bgcolour)
	menubar.grid(row=0, column=1, columnspan=200, sticky=W)
	#main menu
	mbutton = Menubutton(menubar, text='Main Menu', bg=bgcolour)
	picks = Menu(mbutton, bg=bgcolour)
	mbutton.config(menu=picks)
	picks.add_command(label='Load Map ...', command=do_load_map)
	picks.add_command(label='Save', command=save_map)
	picks.add_command(label='Quit', command=quit_command)
	mbutton.grid(row=0, column=1, sticky=NW)
	#tile set menu
	mbutton = Menubutton(menubar, text='Tile Set', bg=bgcolour)
	picks = Menu(mbutton, bg=bgcolour)
	mbutton.config(menu=picks)
	for root, dirs, files in walk(g.mod_directory + "/images/tiles/"):
		(head, tail) = path.split(root)
		if (tail != "CVS"):
			if(tail == ""):
				picks.add_command(label="default", command=(lambda x="default":display_tiles(x)))
			else:
				picks.add_command(label=tail, command=(lambda x=tail:display_tiles(x)))
	mbutton.grid(row=0, column=4, sticky=NW)

	#Settings Parent menu
	mbutton = Menubutton(menubar, text='Map Settings', bg=bgcolour)
	map_options = Menu(mbutton, bg=bgcolour)
	mbutton.config(menu=map_options)

	#mapmode submenu
	mapmode_menu = Menu(map_options, bg=bgcolour)
	map_options.add_cascade(label='Map Mode', menu=mapmode_menu)
	mapmode_menu.add_command(label='Replace Tile (default)', command=(lambda x="replace":set_mode(x)))
	mapmode_menu.add_command(label='Add Tile (transparency)', command=(lambda x="add":set_mode(x)))
	mapmode_menu.add_command(label='Reset Tile (clear to background)', command=(lambda x="remove":set_mode(x)))

	#mapsize submenu
	mapsize_menu = Menu(map_options, bg=bgcolour)
	map_options.add_cascade(label='Map Size',menu=mapsize_menu)
	mapsize_menu.add_command(label='Custom Map Size ...', command=(lambda x=0:change_mapsize(x)))
	mapsize_menu.add_command(label='15x15', command=(lambda x=15:really_change_mapsize(x, x)))
	mapsize_menu.add_command(label='20x20', command=(lambda x=20:really_change_mapsize(x, x)))
	mapsize_menu.add_command(label='25x25', command=(lambda x=25:really_change_mapsize(x, x)))

	#background submenu
	background_menu = Menu(map_options, bg=bgcolour)
	map_options.add_cascade(label='Background',menu=background_menu)
	background_menu.add_command(label='water', command=(lambda x="water/water.png":set_bkg(x)))
	background_menu.add_command(label='dirt', command=(lambda x="underground/dirt.png":set_bkg(x)))
	background_menu.add_command(label='void', command=(lambda x="underground/void.png":set_bkg(x)))
	background_menu.add_command(label='grass', command=(lambda x="grass.png":set_bkg(x)))

	#border submenu
	border_menu = Menu(map_options, bg=bgcolour)
	map_options.add_cascade(label='Border',menu=border_menu)
	border_menu.add_command(label='water', command=(lambda x="water/water.png":set_border(x)))
	border_menu.add_command(label='rock', command=(lambda x="rock.png":set_border(x)))
	border_menu.add_command(label='hills', command=(lambda x="hills/hills_n4.png":set_border(x)))
	border_menu.add_command(label='cave', command=(lambda x="underground/rock.png":set_border(x)))
	border_menu.add_command(label='void', command=(lambda x="underground/void.png":set_border(x)))

	map_options.add_command(label='Edit Monsters', command=(lambda x=0:edit_monsters(x)))


	mbutton.grid(row=0, column=5, sticky=NW)

	#display menu
	mbutton = Menubutton(menubar, text='Display', bg=bgcolour)
	picks = Menu(mbutton, bg=bgcolour)
	mbutton.config(menu=picks)
	picks.add_command(label='Toggle Grid', command=(lambda x=1:toggle_grid()))
	picks.add_command(label='Portal Size 15 (800x600)', command=(lambda x=15:change_portal(x)))
	picks.add_command(label='Portal Size 20 (1024x768)', command=(lambda x=20:change_portal(x)))
	picks.add_command(label='Portal Size 25 (Larger)', command=(lambda x=25:change_portal(x)))
	mbutton.grid(row=0, column=6, sticky=NW)

	window.bind("<Escape>", quit_command)
	window.bind("q", quit_command)

def change_portal(size):
	global portalsize
	portalsize = size
	canvas_map.config(width=g.tilesize*portalsize, height=g.tilesize*portalsize)
	refresh_map()

def sel_list_mod():
	if (len(listbox_mods.curselection()) == 0): return 0
	try: mod_num = map(int, listbox_mods.curselection())
	except ValueError: pass
	mod_name = dirnames[mod_num[0]]
	sel_mod(mod_name)

def sel_mod(selected_mod):
	window_sel_game.withdraw()
	g.mod_directory = "../modules/" + selected_mod
	g.read_maps()
	g.load_tiles()
	g.read_variables()
	window.deiconify()
	make_menus()
	load_tiles()
	create_map()
	setup_tilebox()
	display_tiles("default")

from os import listdir

array_mods = listdir("../modules/")
i = 0
while i < len(array_mods):
	if array_mods[i] == "CVS":
		array_mods.pop(i)
	else:
		i += 1

if (len(array_mods) == 1):
	g.mod_directory = "../modules/" + array_mods[0]
	g.read_maps()
	g.load_tiles()
	g.read_variables()
	make_menus()
	load_tiles()
	create_map()
	setup_tilebox()
	display_tiles("default")
	toggle_grid()
else:
	global window_sel_game #reduced form of rpg.py
	window_sel_game = Toplevel()
	window_sel_game.title("Select module")
	window_sel_game.resizable(0, 0)
	window_sel_game.maxsize(900, 900)
	window_sel_game.wm_geometry("+%d+%d" % (20, 20))

	global listbox_mods
	listbox_mods = Listbox(window_sel_game, height=10)
	listbox_mods.grid(row=1, column=1, rowspan=10, sticky=N+W+E)

	global button_sel
	button_sel = Button(window_sel_game, text="Select mod",
		command=sel_list_mod)
	button_sel.grid(row=1, column=0)

	global button_quit
	button_quit = Button(window_sel_game, text="Quit", command=quit_command)
	button_quit.grid(row=2, column=0)

	for modname in array_mods:
		g.mod_directory = "../modules/" + modname
		listbox_mods.insert(END, g.read_game_name())
		dirnames.append(modname)
	window.withdraw()

# put all items in a list
item_dir = listdir("../modules/" + array_mods[0] + "/images/tiles/items")
j=0
while j<len(item_dir):
	if item_dir[j] != "CVS":
		name = "items/" + item_dir[j]
		item_list[name] = 0
	j += 1


window.master.wait_window(window)
