#file: shop.py
#Copyright (C) 2004 Free Software Foundation
#see GPL.txt for license.

#This file controls the town shops.


from Tkinter import *
import main
import g


#type of the store: Weapon store is 1, general store is 2,
#armory is 3, and training hall is 4.
global store_type

#array containing the item[] index of all inventory items.
#Used to determine which item to sell/drop
global listbox_inv_array
listbox_inv_array = []

#variables for the middle info display
item_name  = StringVar()
item_cost  = StringVar()
item_power = StringVar()
item_desc  = StringVar()
curr_gold  = StringVar()
curr_skill = StringVar()


#refresh the inventory listbox
def refresh_inv():
	#clear listbox_inv
	listbox_inv.delete(0, END)
	listbox_inv_array[0:len(listbox_inv_array)] = []

	#fill in listbox
	for i in g.inv:
		if i != -1:
			listbox_inv_array.append(i)
			listbox_inv.insert(END, g.item[i][0])

	#set gold and skillpoints
	curr_gold.set("Gold: " + str(g.gold))
	curr_skill.set("Skillpoints: " + str(g.skillpoints))
	main.recalc_stats()

#Show details for an inventory item. Called when an inv item is selected.
#called_from is either "selected", "first", or "mouse".
def show_inv_details(event=0, called_from="mouse"):
	#put the item index into item_loc
	#Note: this tries the item nearest to the cursor, then the active item.
	#This works to allow both clicking on an item
	#and displaying the first by default.
	listbox_inv.update_idletasks()
	if called_from == "mouse":
		#try:
		cur_item = listbox_inv.get(listbox_inv.nearest(event.y))
		#except AttributeError:
		#	cur_item = listbox_inv.get(ACTIVE)
	elif called_from == "selected":
		try: item_num = map(int, listbox_inv.curselection())
		except ValueError: pass
		try: cur_item = listbox_inv.get(item_num[0])
		except IndexError:
			button_sell.config(state=DISABLED)
			button_buy.config(state=DISABLED)
			return 0
	else: cur_item = listbox_inv.get(0)
	#convert from name to ID.
	item_loc = g.finditem(cur_item)
	if (item_loc == -1): return 0
	#fill in the actual info

	item_name.set(g.item[item_loc][0])
	item_cost.set("Cost: " + str(g.item[item_loc][3]) + " AU")
	item_power.set("Power: " + str(g.item[item_loc][2]))

	canvas_desc.delete("all")
	canvas_desc.create_text(1, 5, anchor=NW,
			text=g.item[item_loc][4], width=142)


	#disable/enable buttons as needed.
	button_buy.config(state=DISABLED)
	button_sell.config(state=NORMAL)

#show info for a selected item in the middle of the window.
def show_details(event=0, called_from="mouse"):
	#put the item index into item_loc
	#Note: this tries the item nearest to the cursor, then the active item.
	#This works to allow both clicking on an item
	#and displaying the first by default.
	listbox_shop.update()
	if called_from == "mouse":
		cur_item = listbox_shop.nearest(event.y)
	elif called_from == "selected":
		try: item_num = map(int, listbox_shop.curselection())
		except ValueError: pass
		try: cur_item = item_num[0]
		except IndexError:
			button_sell.config(state=DISABLED)
			button_buy.config(state=DISABLED)
			return 0
	else: #called_from == "first":
		cur_item = 0

	#fill in the actual info
	item_name.set(g.shops[store_num].itemlist[cur_item].item_name)
	if (g.shops[store_num].itemlist[cur_item].buytype == "gold"):
		item_cost.set("Cost: " +
			str(g.shops[store_num].itemlist[cur_item].cost) + " AU")
		if int(g.shops[store_num].itemlist[cur_item].cost) <= int(g.gold):
			button_buy.config(state=NORMAL)
		else:
			button_buy.config(state=DISABLED)
	else:
		item_cost.set("Cost: " +
			str(g.shops[store_num].itemlist[cur_item].cost) + " SP")
		if (int(g.shops[store_num].itemlist[cur_item].cost) <= \
														int(g.skillpoints)):
			if (g.findskill(g.shops[store_num].itemlist[cur_item].item_name)
					== -1 or g.skill[g.findskill(
					g.shops[store_num].itemlist[cur_item].item_name)][5] == 0):
				button_buy.config(state=NORMAL)
			else:
				button_buy.config(state=DISABLED)
		else:
			button_buy.config(state=DISABLED)
	if (str(g.shops[store_num].itemlist[cur_item].power) != "-1"):
		item_power.set("Power: " +
			str(g.shops[store_num].itemlist[cur_item].power))
	else:
		item_power.set("")


	canvas_desc.delete("all")
	canvas_desc.create_text(1, 5, anchor=NW,
		text=g.shops[store_num].itemlist[cur_item].description, width=142)
	button_sell.config(state=DISABLED)


#place appropriate items into the store.
def fill_shop():
	#likely not needed, but good practice
	listbox_shop.delete(0, END)

	for i in range(len(g.shops[store_num].itemlist)):
		listbox_shop.insert(END, g.shops[store_num].itemlist[i].item_name)


#called upon pressing "Sell". Uses the selected item.
def sell_item():
	#find what item is selected
	try: item_num = map(int, listbox_inv.curselection())
	except ValueError: pass
	try: item_to_delete = g.find_inv_item(listbox_inv_array[item_num[0]])
	except IndexError: return 0

	#give the player money
	#note that all stores have a 5 year, money-back guarantee,
	#and accept returns from other stores as well.
	#This means there is no need to doublecheck intent. ;)
	main.print_message("You sell your " + g.item[g.inv[item_to_delete]][0]
		+ ".")
	g.gold = int(g.gold) + g.item[g.inv[item_to_delete]][3]

	#remove the item
	g.drop_inv_item(item_num[0])

	refresh_inv()
	listbox_inv.selection_set(0)


#Call on pressing "Buy". Uses the selected item.
def buy_item():
	#find the name of the item
	try: item_num = map(int, listbox_shop.curselection())
	except ValueError: pass
	cur_item = item_num[0]

	if (g.shops[store_num].itemlist[cur_item].buytype == "gold"):
		#if enough gold
		if int(g.shops[store_num].itemlist[cur_item].cost) <= int(g.gold):
			#if no actions were given
			if (len(g.shops[store_num].itemlist[cur_item].actions) == 0):
				#if given successfully.
				if (main.action.activate_line(0, 0, 0, "item " +
						g.shops[store_num].itemlist[cur_item].item_name)
						== 1):
					main.print_message("You buy a " +
					g.shops[store_num].itemlist[cur_item].item_name + ".")
					g.gold = int(g.gold) - \
					int(g.shops[store_num].itemlist[cur_item].cost)
			else:
				for script_line in \
						g.shops[store_num].itemlist[cur_item].actions:
					temp = main.action.activate_line(0, 0, 0, script_line)
					if temp == "end" or main.dead_yet() == 1:
						show_details(0, "selected")
						refresh_inv()
						return
				g.gold = int(g.gold) - \
				int(g.shops[store_num].itemlist[cur_item].cost)
	else: #skillpoints
		#if enough skillpoints
		if int(g.shops[store_num].itemlist[cur_item].cost) <= \
													int(g.skillpoints):
			#if no actions were given
			if (len(g.shops[store_num].itemlist[cur_item].actions) == 0):
				#if given successfully.
				if (main.action.activate_line(0, 0, 0, "item " +
						g.shops[store_num].itemlist[cur_item].item_name)
						== 1):
					main.print_message("You buy a " +
					g.shops[store_num].itemlist[cur_item].item_name + ".")
					g.skillpoints = int(g.skillpoints) - \
					int(g.shops[store_num].itemlist[cur_item].cost)
			else:
				for script_line in \
						g.shops[store_num].itemlist[cur_item].actions:
					temp = main.action.activate_line(0, 0, 0, script_line)
					if temp == "end" or main.dead_yet() == 1:
						show_details(0, "selected")
						refresh_inv()
						return
				g.skillpoints = int(g.skillpoints) - \
				int(g.shops[store_num].itemlist[cur_item].cost)

	show_details(0, "selected")
	refresh_inv()


def leave_shop(event=0):
	try:
		window_shop.destroy()
	except TclError:
		pass


#All keypresses in window_shop pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(switch):
	#place list into cur_list
	if (listbox_shop.curselection()):
		cur_list = "shop"
	elif (listbox_inv.curselection()):
		cur_list = "inv"
	else:  #if neither list is selected
		cur_list = "neither"

	#switch based on keycode
	if (switch == "esc"):
		leave_shop()
		return
	elif (switch == "return"):
		if (cur_list == "shop"): buy_item()
		else: sell_item()
	elif (switch == "left"):  #move between lists
		if (cur_list != "inv" and listbox_inv.size() > 0):
			cur_list = "inv"
			listbox_inv.selection_set(0)
	elif (switch == "right"):
		if (cur_list != "shop" and listbox_shop.size() > 0):
			cur_list = "shop"
			listbox_shop.selection_set(0)
	elif (switch == "up"):
		if (cur_list == "shop"):
			try:
				item_num = map(int, listbox_shop.curselection())
			except ValueError: pass
			if (item_num[0] != 0):
				listbox_shop.select_clear(0, END)
				listbox_shop.selection_set(item_num[0] - 1)
			else:
				listbox_shop.select_clear(0, END)
				listbox_shop.selection_set(END)
		if (cur_list == "inv"):
			try:
				item_num = map(int, listbox_inv.curselection())
			except ValueError: pass
			if (item_num[0] != 0):
				listbox_inv.select_clear(0, END)
				listbox_inv.selection_set(item_num[0] - 1)
			else:
				listbox_inv.select_clear(0, END)
				listbox_inv.selection_set(END)
	elif (switch == "down"):
		if (cur_list == "shop"):
			try:
				item_num = map(int, listbox_shop.curselection())
			except ValueError: pass
			if (item_num[0] != listbox_shop.size() - 1):
				listbox_shop.select_clear(0, END)
				listbox_shop.selection_set(item_num[0] + 1)
			else:
				listbox_shop.select_clear(0, END)
				listbox_shop.selection_set(0)
		if (cur_list == "inv"):
			try:
				item_num = map(int, listbox_inv.curselection())
			except ValueError: pass
			if (item_num[0] != listbox_inv.size() - 1):
				listbox_inv.select_clear(0, END)
				listbox_inv.selection_set(item_num[0] + 1)
			else:
				listbox_inv.select_clear(0, END)
				listbox_inv.selection_set(0)


	if (cur_list == "inv"): show_inv_details(0, "selected")
	if (cur_list == "shop"): show_details(0, "selected")

#Python does not appear to allow arguments in callbacks. Grumble.
def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")

#create window_shop
def init_window_shop(store_type_input):
	global window_shop
	global bgcolour
	bgcolour = "lightgrey"
	window_shop = Frame(main.top, bd=2, relief=SUNKEN, bg=bgcolour)
	window_shop.grid(row=1, column=5, columnspan=13, sticky=E)

	global store_num
	for i in range(len(g.shops)):
		if (g.shops[i].name == store_type_input):
			store_num = i
			break

	global store_type
	store_type = store_type_input


	#Inventory listbox
	global listbox_inv
	listbox_inv = Listbox(window_shop, height=16, takefocus=0, bg=bgcolour)
	listbox_inv.grid(row=6, column=1, columnspan=2, rowspan=16)

	#Shop listbox
	global listbox_shop
	listbox_shop = Listbox(window_shop, height=16, takefocus=0, bg=bgcolour)
	listbox_shop.grid(row=6, column=6, columnspan=2, rowspan=16)

	#Info labels
	label_formatting = Label(window_shop,
		text="Info:                             ", bg=bgcolour).grid(row=7,
				column=3)

	label_name = Label(window_shop, textvar=item_name,
		wraplength=143, bg=bgcolour).grid(row=8, column=3, sticky=W)
	label_cost = Label(window_shop,
		textvar=item_cost, bg=bgcolour).grid(row=9, column=3, sticky=W)
	label_power = Label(window_shop,
		textvar=item_power, bg=bgcolour).grid(row=11, column=3, sticky=W)

	global canvas_desc
	canvas_desc = Canvas(window_shop, width=143, highlightthickness=0,
			bg=bgcolour)
	canvas_desc.grid(row=12, column=3, rowspan=8, sticky=NSEW)

	label_skill = Label(window_shop, textvar=curr_skill, anchor=NW,
		bg=bgcolour).grid(row=20, column=3, sticky=W)
	label_gold = Label(window_shop, textvar=curr_gold, anchor=NW,
		bg=bgcolour).grid(row=21, column=3, sticky=W)


	#Buttons
	global button_sell
	button_sell = Button(window_shop, text="Sell", command=sell_item,
		bg=bgcolour)
	button_sell.grid(row=28, column=1)
	global button_buy
	button_buy  = Button(window_shop, text="Buy",  command=buy_item,
		bg=bgcolour)
	button_buy.grid(row=28, column=6)
	button_leave= Button(window_shop, text="Leave",
		command=leave_shop, bg=bgcolour).grid(row=28, column=3)

	#get data in listboxes
	refresh_inv()
	fill_shop()
	listbox_shop.select_set(0)

	#bindings
	listbox_shop.bind("<ButtonRelease-1>", show_details)
	listbox_inv.bind("<ButtonRelease-1>",  show_inv_details)
	main.window_main.bind("<Escape>", key_handler_esc)
	main.window_main.bind("<Left>", key_handler_left)
	main.window_main.bind("<Right>", key_handler_right)
	main.window_main.bind("<Up>", key_handler_up)
	main.window_main.bind("<Down>", key_handler_down)
	main.window_main.bind("<Return>", key_handler_return)
	main.window_main.bind("i", key_handler)
	main.window_main.bind("s", key_handler)
	main.window_main.bind("q", key_handler)

	show_details(0, "first")
	window_shop.master.wait_window(window_shop)


