/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_UTIL_H
#define DOODLEHASH_UTIL_H

#include <glib.h>
#include <libxml/tree.h>
#include <librsvg/rsvg.h>

G_BEGIN_DECLS
//int find_connect_point(xmlNodePtr n, char *name, unsigned int *x, unsigned int *y);
int find_connect_point(RsvgHandle *handle, char *name, unsigned int *x, unsigned int *y);

int get_colours(const guint8 *data, gsize data_len, gchar ***primary_stroke, gchar ***primary_fill, gchar ***secondary_stroke, gchar ***secondary_fill, guint32 *num);
gchar* get_svg_path(const char *subdir);

void colourify_svg_file (const char *indata, size_t indatalen, char **outdata, size_t *outdatalen, char *prev_stroke, char *prev_fill, char *stroke, char *fill, int primary);
xmlNodePtr findNode(xmlNodePtr root, const char *name);
G_END_DECLS
#endif /* DOODLEHASH_UTIL_H */
