/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_SPECTACLES_H
#define DOODLEHASH_SPECTACLES_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
struct _DoodleHashSpectacles
{
  DoodleHashObject *base;
};

DoodleHashSpectacles* doodlehash_spectacles_new();
DoodleHashSpectacles* doodlehash_spectacles_copy(const DoodleHashSpectacles*orig);
DoodleHashSpectacles* doodlehash_spectacles_load_from_svg_file(const char *file);
void doodlehash_spectacles_get_width_and_height(DoodleHashSpectacles* spectacles, guint32* width, guint32* height);
guint32 doodlehash_spectacles_get_width(DoodleHashSpectacles* spectacles);
guint32 doodlehash_spectacles_get_height(DoodleHashSpectacles* spectacles);
void doodlehash_spectacles_set_width(DoodleHashSpectacles* spectacles, guint32 width);
void doodlehash_spectacles_set_height(DoodleHashSpectacles* spectacles, guint32 height);
void doodlehash_spectacles_set_random_colours(DoodleHashSpectacles* spectacles, guint code);
void doodlehash_spectacles_set_colours(DoodleHashSpectacles* spectacles, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_spectacles_get_fill_colour(DoodleHashSpectacles* spectacles, guint code);
gchar *doodlehash_spectacles_get_stroke_colour(DoodleHashSpectacles* spectacles, guint code);
void doodlehash_spectacles_scale(DoodleHashSpectacles *spectacles, double scale);
void doodlehash_spectacles_free(DoodleHashSpectacles* spectacles);
G_END_DECLS

#endif /* DOODLEHASH_SPECTACLES_H */
