/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope tmoustache it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_MOUSTACHE_H
#define DOODLEHASH_MOUSTACHE_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
struct _DoodleHashMoustache
{
  DoodleHashObject *base;
  guint32 connect_to_mouth_x;
  guint32 connect_to_mouth_y;
};
DoodleHashMoustache* doodlehash_moustache_new();
DoodleHashMoustache* doodlehash_moustache_copy(const DoodleHashMoustache*orig);
DoodleHashMoustache* doodlehash_moustache_load_from_svg_file(const char *file);
void doodlehash_moustache_get_width_and_height(DoodleHashMoustache* moustache, guint32* width, guint32* height);
guint32 doodlehash_moustache_get_width(DoodleHashMoustache* moustache);
guint32 doodlehash_moustache_get_height(DoodleHashMoustache* moustache);
void doodlehash_moustache_set_width(DoodleHashMoustache* moustache, guint32 width);
void doodlehash_moustache_set_height(DoodleHashMoustache* moustache, guint32 height);
void doodlehash_moustache_get_mouth_connection_point(DoodleHashMoustache* moustache, guint32* x, guint32* y);
guint32 doodlehash_moustache_get_mouth_connection_point_x(DoodleHashMoustache* moustache);
guint32 doodlehash_moustache_get_mouth_connection_point_y(DoodleHashMoustache* moustache);
void doodlehash_moustache_set_mouth_connection_point(DoodleHashMoustache* moustache, guint32 x, guint32 y);
void doodlehash_moustache_set_random_colours(DoodleHashMoustache* moustache, guint code);
void doodlehash_moustache_set_colours(DoodleHashMoustache* moustache, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_moustache_get_fill_colour(DoodleHashMoustache* moustache, guint code);
gchar *doodlehash_moustache_get_stroke_colour(DoodleHashMoustache* moustache, guint code);
void doodlehash_moustache_scale(DoodleHashMoustache *moustache, double scale);
void doodlehash_moustache_free(DoodleHashMoustache* moustache);

G_END_DECLS
#endif /* DOODLEHASH_MOUSTACHE_H */
