/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_HAIR_H
#define DOODLEHASH_HAIR_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
struct _DoodleHashHair
{
  DoodleHashObject *base;
};

DoodleHashHair* doodlehash_hair_new();
DoodleHashHair* doodlehash_hair_copy(const DoodleHashHair*orig);
DoodleHashHair* doodlehash_hair_load_from_svg_file(const char *file);
void doodlehash_hair_get_width_and_height(DoodleHashHair* hair, guint32* width, guint32* height);
guint32 doodlehash_hair_get_width(DoodleHashHair* hair);
guint32 doodlehash_hair_get_height(DoodleHashHair* hair);
void doodlehash_hair_set_width(DoodleHashHair* hair, guint32 width);
void doodlehash_hair_set_height(DoodleHashHair* hair, guint32 height);
void doodlehash_hair_set_random_colours(DoodleHashHair* hair, guint code);
void doodlehash_hair_set_colours(DoodleHashHair* hair, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_hair_get_fill_colour(DoodleHashHair* hair, guint code);
gchar *doodlehash_hair_get_stroke_colour(DoodleHashHair* hair, guint code);
void doodlehash_hair_scale(DoodleHashHair *hair, double scale);
void doodlehash_hair_free(DoodleHashHair* hair);
G_END_DECLS

#endif /* DOODLEHASH_HAIR_H */
