/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_FACE_H
#define DOODLEHASH_FACE_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>
#include <libdoodlehash/cheeks.h>
#include <libdoodlehash/chin.h>
#include <libdoodlehash/ears.h>
#include <libdoodlehash/earrings.h>
#include <libdoodlehash/eyebrows.h>
#include <libdoodlehash/eyes.h>
#include <libdoodlehash/hair.h>
#include <libdoodlehash/head.h>
#include <libdoodlehash/moustache.h>
#include <libdoodlehash/mouth.h>
#include <libdoodlehash/nose.h>
#include <libdoodlehash/spectacles.h>

G_BEGIN_DECLS
struct _DoodleHashFace
{
  DoodleHashCheekPair * cheeks;
  DoodleHashChin *chin;
  DoodleHashEarPair *ears;
  DoodleHashEarRingPair *earrings;
  DoodleHashEyeBrowPair *eyebrows;
  DoodleHashEyes *eyes;
  DoodleHashHair *hair;
  DoodleHashHead *head;
  DoodleHashMoustache *moustache;
  DoodleHashMouth *mouth;
  DoodleHashNose *nose;
  DoodleHashSpectacles *spectacles;
};

DoodleHashFace* doodlehash_face_new();
DoodleHashFace* doodlehash_face_copy(const DoodleHashFace *orig);
DoodleHashFace* doodlehash_face_load_from_svg_files(const char *ear_left_file, const char *ear_right_file, const char *earring_left_file, const char *earring_right_file, const char *eyes_file, const char *hair_file, const char *head_file, const char *moustache_file, const char *mouth_file, const char *nose_file, const char *eyebrow_left_file, const char *eyebrow_right_file, const char *chin_file, const char *cheek_left_file, const char *cheek_right_file, const char *spectacles_file);
DoodleHashCheekPair * doodlehash_face_get_cheeks(DoodleHashFace *f);
void doodlehash_face_set_cheeks(DoodleHashFace *f, DoodleHashCheekPair * cheeks);
DoodleHashChin *doodlehash_face_get_chin(DoodleHashFace *f);
void doodlehash_face_set_chin(DoodleHashFace *f, DoodleHashChin *chin);
DoodleHashEarPair *doodlehash_face_get_ears(DoodleHashFace *f);
void doodlehash_face_set_ears(DoodleHashFace *f, DoodleHashEarPair *ears);
DoodleHashEarRingPair *doodlehash_face_get_earrings(DoodleHashFace *f);
void doodlehash_face_set_earrings(DoodleHashFace *f, DoodleHashEarRingPair *earrings);
DoodleHashEyeBrowPair *doodlehash_face_get_eyebrows(DoodleHashFace *f);
void doodlehash_face_set_eyebrows(DoodleHashFace *f, DoodleHashEyeBrowPair *eyebrows);
DoodleHashEyes *doodlehash_face_get_eyes(DoodleHashFace *f);
void doodlehash_face_set_eyes(DoodleHashFace *f, DoodleHashEyes *eyes);
DoodleHashHair *doodlehash_face_get_hair(DoodleHashFace *f);
void doodlehash_face_set_hair(DoodleHashFace *f, DoodleHashHair *hair);
DoodleHashHead *doodlehash_face_get_head(DoodleHashFace *f);
void doodlehash_face_set_head(DoodleHashFace *f, DoodleHashHead *head);
DoodleHashMoustache *doodlehash_face_get_moustache(DoodleHashFace *f);
void doodlehash_face_set_moustache(DoodleHashFace *f, DoodleHashMoustache *moustache);
DoodleHashMouth *doodlehash_face_get_mouth(DoodleHashFace *f);
void doodlehash_face_set_mouth(DoodleHashFace *f, DoodleHashMouth *mouth);
DoodleHashNose *doodlehash_face_get_nose(DoodleHashFace *f);
void doodlehash_face_set_nose(DoodleHashFace *f, DoodleHashNose *nose);
DoodleHashSpectacles *doodlehash_face_get_spectacles(DoodleHashFace *f);
void doodlehash_face_set_spectacles(DoodleHashFace *f, DoodleHashSpectacles *spectacles);
void doodlehash_face_set_random_colours(DoodleHashFace *f);
void doodlehash_face_free(DoodleHashFace* face);
G_END_DECLS

#endif /* DOODLEHASH_FACE_H */
