/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_EARRINGS_H
#define DOODLEHASH_EARRINGS_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
typedef struct earring
{
  DoodleHashObject *base;
  guint32 connect_to_ear_x;
  guint32 connect_to_ear_y;
}DoodleHashEarRing;

struct _DoodleHashEarRingPair
{
  DoodleHashEarRing *left;
  DoodleHashEarRing *right;
};

DoodleHashEarRingPair* doodlehash_earrings_new();
DoodleHashEarRingPair* doodlehash_earrings_copy(const DoodleHashEarRingPair *orig);
DoodleHashEarRingPair* doodlehash_earrings_load_from_svg_file(const gchar *left, const gchar *right);
void doodlehash_earrings_get_width_and_height(DoodleHashEarRingPair* earrings, guint side, guint32* width, guint32* height);
guint32 doodlehash_earrings_get_width(DoodleHashEarRingPair* earrings, guint side);
guint32 doodlehash_earrings_get_height(DoodleHashEarRingPair* earrings, guint side);
void doodlehash_earrings_set_width(DoodleHashEarRingPair* earrings, guint side, guint32 width);
void doodlehash_earrings_set_height(DoodleHashEarRingPair* earrings, guint side, guint32 height);
void doodlehash_earrings_get_ear_connection_point(DoodleHashEarRingPair* earrings, guint side, guint32* x, guint32* y);
guint32 doodlehash_earrings_get_ear_connection_point_x(DoodleHashEarRingPair* earrings, guint side);
guint32 doodlehash_earrings_get_ear_connection_point_y(DoodleHashEarRingPair* earrings, guint side);
void doodlehash_earrings_set_ear_connection_point(DoodleHashEarRingPair* earrings, guint side, guint32 x, guint32 y);
void doodlehash_earrings_set_random_matching_colours(DoodleHashEarRingPair *earrings);
void doodlehash_earrings_set_random_colours(DoodleHashEarRingPair* earrings, guint code);
void doodlehash_earrings_set_colours(DoodleHashEarRingPair* earrings, guint side, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_earrings_get_fill_colour(DoodleHashEarRingPair* earrings, guint side, guint code);
gchar *doodlehash_earrings_get_stroke_colour(DoodleHashEarRingPair* earrings, guint side, guint code);
void doodlehash_earrings_scale(DoodleHashEarRingPair *earrings, guint side, double scale);
void doodlehash_earrings_free(DoodleHashEarRingPair* earrings);

G_END_DECLS
#endif /* DOODLEHASH_EARRINGS_H */
