# Class Log definition

# Copyright (C) 2011 Charles Atkinson
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

# Purpose: docoll Ruby scripts' logging interface 

class Log
  attr_reader :n_errors, :n_warnings
  attr_writer :log_level

  # Class constants
  DEBUG = 1
  INFO  = 2
  WARN  = 3
  ERROR = 4
  FATAL = 5

  def initialize( fd, log_level, timestamps )
    # TODO: accept path instead of fd but how to determine whether arg is fd or path?
    # TODO: when accepting path, use EnsureDir library method before opening
    @fd = fd
    @timestamps = timestamps
    self.log_level( log_level )
    @n_errors = 0
    @n_warnings = 0
  end 

  def close( )
    @fd.close
  end

  def log_level( log_level )
    if log_level >= DEBUG && log_level <= FATAL
      @log_level = log_level
    else
      @log_level = FATAL
      self.write( FATAL, \
        "FATAL: programming error: Log: called with invalid log_level #{ log_level }"
      )
    end
  end

  def write( level, msg_text )
#puts "Log.write: level: #{ level }, @log_level: #{ @log_level }, msg_text: #{ msg_text }"
    if level < @log_level; return end
    case level
    when DEBUG
      msg_text = "DEBUG: " + msg_text
    when INFO
    when WARN
      @n_warnings += 1
      msg_text = "WARNING: " + msg_text
    when ERROR
      @n_errors += 1
      msg_text = "ERROR: " + msg_text
    when FATAL
      msg_text = "FATAL: " + msg_text
      if @timestamps; msg_text = Time.now.strftime( '%H:%M:%S ' ) + msg_text end
      @fd.puts( msg_text )
      Finalise( 1 )
    end
    if @timestamps; msg_text = Time.now.strftime( '%H:%M:%S ' ) + msg_text end
    @fd.puts( msg_text )
  end

end
