@ECHO OFF

REM *****************************************************************
REM LOCAL_CWRSYNC.CMD
REM
REM Usage: no aruments
REM *****************************************************************
REM 18dec10 Charles
REM	* Creation, based on as-installed cwrsync.cmd. Additional
REM	  code follows "Above code is from as-installed CWRSYNC.CMD".
REM 16feb11 Charles
REM	* Read this computer's name from name_of_this_computer.txt
REM	* Read server's name or IP address from server_ID.txt
REM     * Use | instead of : as field separator in 
REM	  local_cwrsync.conf.txt.
REM *****************************************************************
REM Programming notes:
REM 	* If this script is to be significantly extended, consider
REM 	  re-writing in Visual Basic Script
REM *****************************************************************
REM TODO:
REM 	* Add error traps for non-existent files
REM	* Allow comments and empty lines in local_cwrsync.cmd 
REM	  configuration files.
REM *****************************************************************

REM Make environment variable changes local to this batch file
SETLOCAL

REM ** CUSTOMIZE ** Specify where to find rsync and related files (C:\CWRSYNC)
SET CWRSYNCHOME=%PROGRAMFILES%\CWRSYNC

REM Set CYGWIN variable to 'nontsec'. That makes sure that permissions
REM on your windows machine are not updated as a side effect of cygwin
REM operations.
SET CYGWIN=nontsec

REM Set HOME variable to your windows home directory. That makes sure 
REM that ssh command creates known_hosts in a directory you have access.
SET HOME=%HOMEDRIVE%%HOMEPATH%

REM Make cwRsync home as a part of system PATH to find required DLLs
SET CWOLDPATH=%PATH%
SET PATH=%CWRSYNCHOME%\BIN;%PATH%

REM Windows paths may contain a colon (:) as a part of drive designation and 
REM backslashes (example c:\, g:\). However, in rsync syntax, a colon in a 
REM path means searching for a remote host. Solution: use absolute path 'a la unix', 
REM replace backslashes (\) with slashes (/) and put -/cygdrive/- in front of the 
REM drive letter:
REM 
REM Example : C:\WORK\* --> /cygdrive/c/work/*
REM 
REM Example 1 - rsync recursively to a unix server with an openssh server :
REM
REM       rsync -r /cygdrive/c/work/ remotehost:/home/user/work/
REM
REM Example 2 - Local rsync recursively 
REM
REM       rsync -r /cygdrive/c/work/ /cygdrive/d/work/doc/
REM
REM Example 3 - rsync to an rsync server recursively :
REM    (Double colons?? YES!!)
REM
REM       rsync -r /cygdrive/c/doc/ remotehost::module/doc
REM
REM Rsync is a very powerful tool. Please look at documentation for other options. 
REM

REM Above code is from as-installed CWRSYNC.CMD; below code added locally

REM *****************************************************************
REM Synchronise to server
REM *****************************************************************

REM EnableDelayedExpansion is required for sane variable expansion in FOR loops
SETLOCAL EnableDelayedExpansion

REM Set timestamp for --backup-dir
FOR /F "usebackq" %%a IN (`UnxUtilsDate.exe +%%Y-%%m-%%d@%%H-%%M`) DO SET TIMESTAMP=%%a

REM Set password environent variable
REM The --password-file option cannot be used because this script is
REM intended to be run by SYSTEM and rsync requires that the password 
REM file is only readable by "root"
C:
CD "\Program Files\cwRsync\"
SET /P RSYNC_PASSWORD= < password.txt
SET /P SERVER= < server_ID.txt
SET /P THIS_COMPUTER= < name_of_this_computer.txt

REM Run rsync once for each source in the configuration file

REM Experimentation showed loop iterates silently if file line is empty. Helpful :-)
REM Experimentation showed neither of next two lines work :-(
REM IF [%%a:~0,1] == [#] SET DATA=FALSE
REM SET TEST=%%a:~0,1

REM In SET varname=value, double quotes must not be used around value or they become part of it.
REM Understanding the ^^ double escapes below requires knowledge of how cmd.exe operates
REM as described at http://www.lingubender.com/forum/viewtopic.php?f=12&t=615#p3531
REM (no definitive Microsoft equivalent was found).    

FOR /F "delims=| tokens=1-4" %%a in (local_cwrsync.conf.txt) DO (
    SET DATA=TRUE
    SET TEST=%%a && SET TEST=!TEST:~0,1!
    IF !TEST! == # SET DATA=FALSE
    IF !DATA! == TRUE (
        SET SOURCE=%%a
        SET DRIVE=!SOURCE:~-1,1!
        SET FILESFROM=/cygdrive/C/Program Files/cwRsync/empty.txt
        IF NOT [%%b] == [] SET FILESFROM=%%b
        SET INCLUDEFROM=/cygdrive/C/Program Files/cwRsync/empty.txt
        IF NOT [%%c] == [] SET INCLUDEFROM=%%c
        SET EXCLUDEFROM=/cygdrive/C/Program Files/cwRsync/empty.txt
        IF NOT [%%d] == [] SET EXCLUDEFROM=%%d
        rsync --backup --backup-dir %TIMESTAMP% --compress --include-from ^^"!INCLUDEFROM!" --exclude-from ^^"!EXCLUDEFROM!" --files-from ^^"!FILESFROM!" --log-file="/cygdrive/C/Program Files/cwRsync/%TIMESTAMP%.log.rtf" --partial --partial-dir=.rsync-partial --prune-empty-dirs --recursive --relative --times !SOURCE! %THIS_COMPUTER%@%SERVER%::%THIS_COMPUTER%/!DRIVE!/
    )
)

REM *****************************************************************
REM Age out log files more than one month old
REM *****************************************************************

REM Set cutoff timestamp
FOR /F "usebackq" %%t IN (`UnxUtilsDate.exe -d "1 month ago" +%%Y%%m%%d`) DO SET CUTOFF=%%t

REM Experimentation showed the .CMD IF <string> LEQ <string> command 
REM silently stops working as a numeric comparison for numbers greater
REM than 9999999999.  For this reason minutes and seconds are not used.

FOR /F "delims=-@. tokens=1-5" %%a in ('DIR /B /O:-D *.log.rtf') DO (
    IF %%a%%b%%c LEQ %CUTOFF% DEL %%a-%%b-%%c@%%d-%%e.log.rtf
)

ENDLOCAL

REM ECHO Final EXIT is commented out!  Must be uncommented when run as a Scheduled Task
EXIT