#!/usr/bin/env bash

# Copyright (C) 2007 Juan Manuel Borges Caño

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

function dn_have_command
{
	[[ $(which "$1" 2>&1 /dev/null) ]]
}

function dn_have_file
{
	[[ -f "$1" ]]
}

function dn_try_by_lsb_release
{
	if [[ $(dn_have_command lsb_release) ]]
	then
		lsb_release -d | cut -d':' -f2 | sed -re 's,^[[:space:]]+,,'
		exit 0
	fi
}

function dn_try_by_file
{
	if dn_have_file "$1"
	then
		cat "$1"
		exit 0;
	fi
}

function dn_try_by_uname
{
	if dn_have_command uname && [[ $(uname -rs | grep -i "$1") ]]
	then
		uname -rs
		exit 0
	fi
}

function dn_not_found
{
	echo "Distribution name not found."
	echo "If you really want it, ask <juanmabc3@yahoo.com> to add it, and if you know how to get it and want to use it via distroname send it."
	exit 1
}


dn_try_by_lsb_release
dn_try_by_file "/etc/slackware-version"
dn_try_by_uname "FreeBSD"
dn_try_by_uname "SunOS"
dn_try_by_uname "CYGWIN"
dn_not_found
