/****************************************************************************
   GLASHCtl - a simple tray applet for controlling lashd
   
   Copyright (C) 2006  Lars Luthman <lars.luthman@gmail.com>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
****************************************************************************/

#ifndef TERMWIN_HPP
#define TERMWIN_HPP

#include <gtkmm.h>
#include <vte/vte.h>

#include "terminal.hpp"
#include "lashwrapper.hpp"


class TermWin : public Gtk::Window {
public:
  
  TermWin(LASHWrapper& lashd);
  
  void toggle_visibility();
  
  void print_msg(const std::string& msg);
  
private:
  
  Terminal m_term;
  LASHWrapper& m_lashd;
  
};


#endif

