/****************************************************************************
   GLASHCtl - a simple tray applet for controlling lashd
   
   Copyright (C) 2006  Lars Luthman <lars.luthman@gmail.com>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
****************************************************************************/

#include <iostream>
#include <csignal>

#include <gtk/gtk.h>
#include <gtkmm.h>

#include "eggtrayicon.h"
#include "lashwrapper.hpp"
#include "termwin.hpp"
#include "trayicon.hpp"


using namespace std;
using namespace Gtk;
using namespace Gdk;
using namespace Glib;


int die_now = 0;


void signalhandler(int signal) {
  die_now = 1;
}


bool check_death() {
  if (die_now == 1)
    Main::quit();
  return true;
}


int main(int argc, char** argv) {
  
  // exit cleanly when interrupted by the user
  std::signal(SIGHUP, &signalhandler);
  std::signal(SIGINT, &signalhandler);
  std::signal(SIGTERM, &signalhandler);
  
  // create the objects
  Main kit(argc, argv);
  LASHWrapper lashd(&argc, &argv);
  TrayIcon icon;
  TermWin window(lashd);
  
  // connect the signals
  icon.signal_start_lashd.connect(mem_fun(lashd, &LASHWrapper::start_lashd));
  icon.signal_stop_lashd.connect(mem_fun(lashd, &LASHWrapper::stop_lashd));
  icon.signal_close_session.connect(mem_fun(lashd, 
                                            &LASHWrapper::close_session));
  icon.signal_save_session.connect(mem_fun(lashd, 
                                           &LASHWrapper::save_session));
  icon.signal_restore_session.connect(mem_fun(lashd, 
                                              &LASHWrapper::restore_session));
  icon.signal_set_session_dir.connect(mem_fun(lashd, 
                                              &LASHWrapper::set_session_dir));
  icon.signal_set_session_name.connect(mem_fun(lashd, 
                                              &LASHWrapper::set_session_name));
  icon.signal_toggle_window.connect(mem_fun(window, 
                                            &TermWin::toggle_visibility));
  lashd.signal_lashd_started.connect(mem_fun(icon, &TrayIcon::lashd_started));
  lashd.signal_lashd_stopped.connect(mem_fun(icon, &TrayIcon::lashd_stopped));
  lashd.signal_session_changed.connect(mem_fun(icon, 
                                               &TrayIcon::session_changed));
  lashd.signal_event_received.connect(mem_fun(window, &TermWin::print_msg));
  signal_timeout().connect(&check_death, 100);
  
  // add the tray icon in the notification area
  EggTrayIcon* egg_icon = egg_tray_icon_new("glashctl");
  gtk_container_add(GTK_CONTAINER((GtkWidget*)egg_icon), 
                    (GtkWidget*)icon.gobj());
  gtk_widget_show_all((GtkWidget*)egg_icon);
  
  // run
  kit.run();
  
  return 0;
}

