/*****************************************************************************************/
/* Copyright 2008, 2009,2010,2011,2012,2013 Elias Potapov. */
/* Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007
   The GSL Team. */

/*****************************************************************************************/
/* This file is part of DINAMICA. */

/* DINAMICA is free software: you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation, either version 3 of the License, or */
/* (at your option) any later version. */

/* DINAMICA is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with DINAMICA.  If not, see <http://www.gnu.org/licenses/>. */
/****************************************************************************************/
/****************************************************************************************/
/* Original author is Elias Potapov <elias.potapov@gmail.com>
   Lomonosov Moscow State University, Biophysics Dep..
   Tampere University of Technology, Department of Signal Processing
   Moscow, Russia / Tampere, Finland */
/****************************************************************************************/

/*Steady States numerical code. SS stands for general steady state
  regime. If LDIM==1, i.e. number of the coupled systems is equal to
  1, then SS is the only regime available. If LDIM>1, i.e. number of
  the coupled systems more than 1, then regimes might be either SS+HSS
  or SS+IHSS. Thus, eventually regimes can be SS(1),SS+HSS(3) or
  SS+IHSS(5), other numerical codes are errors.*/
#define SS 1
#define HSS 2
#define IHSS 4
/*Limit Cycles numerical code. LC stands for general oscillatory(limit
  cycle) regime. If LDIM==1 then LC is the only regime available. If
  LDIM>1 then regimes should be of the following form:
  LC+<phase_shift>+<amplitude>, where <phase_shift> is
  regime(numerical code) defined with phase shift between two
  oscillators and <amplitude> is regime(numerical code) defined with
  amplitude either equality or inequality.*/
#define LC 100
#define HLC 3
#define IHLC 7
#define INLC 5
#define OUTLC 11
#define ANTILC 18

typedef struct {
  double *t;
  double *x;
  int size;
  int *peak_true_table;
} trajPeak;
