/*****************************************************************************************/
/* Copyright 2008,2009,2010,2011,2012,2013 Elias Potapov. */
/* Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
   2008, 2009, 2010, 2011 The GSL Team. */

/*****************************************************************************************/
/* This file is part of DINAMICA. */

/* DINAMICA is free software: you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation, either version 3 of the License, or */
/* (at your option) any later version. */

/* DINAMICA is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with DINAMICA.  If not, see <http://www.gnu.org/licenses/>. */
/****************************************************************************************/
/****************************************************************************************/
/* Original author is Elias Potapov <elias.potapov@gmail.com>
   Lomonosov Moscow State University, Biophysics Dep..
   Tampere University of Technology, Dep. of Signal Processing.
   Moscow, Russia / Tampere, Finland
*/
/****************************************************************************************/

/* This file defines/describes the functions and routines used in plotting procedures
   of Dinamica. */

#include "init.h"
//#include <plot.h>
#include <stdio.h>
#include <string.h>
#include <gsl/gsl_statistics_double.h>
#define PLOT_NUM_MIN_CHAR 10//Num of char in strings determining numbers in plots
#define USER_COORD_EXTEN 0.2//fraction of the user coord to extend from the ends
#define XY_AXES_EXTEN 0.05//fraction to extend xy-axes from the +\infty ends
/* -\infty ends are left as min of the corresponding x and y vars */

int gnuplot_interp()
{/* This function differs from all _interp function from input_interpreter.c. It
    emulates the gnuplot command line. */
  int Len = 100;
  char *symbuf = (char *)malloc(Len*sizeof(char));
  while(1){
    fprintf(stdout,"%s>",gnuplot_prompt);
    fgets(symbuf,Len,stdin);
    if(symbuf[0] == 'q'){
      fprintf(stdout,"Exit gnuplot prompt...\n");
      break;
    }
    if(strchr(symbuf,'\n') == 0){
      fprintf(stdout,"Limit one line input to %d characters.",Len);
      fprintf(stdout,"Use \"\" for continuation.\n");
      continue;
    }
    gnuplot_cmd(plot_handle,"%s",symbuf);
  }
  return 0;
}

void gplot_results(const char *data_name, const int complex_flag,
		   const char *method)
{
  int i;
  /* Error check */
  if((graph.xInd > (DIM-1)) || (graph.yInd[0] > (DIM-1)) ||
     (graph.yInd[1] > (DIM-1)) || (graph.yInd[2] > (DIM-1))){
    fprintf(stderr,"Graph: out of var indices. Change to default.\n");
    graph.xInd = -1;
    graph.yInd[0] = 0;
    graph.yInd[1] = -2;
    graph.yInd[2] = -2;
  }
  graph_set_labels(graph,"tsphase");
  /* Grid */
  if(graph.grid_flag)
    gnuplot_cmd(plot_handle,"set grid\n");

  if((complex_flag == 0) || (complex_flag == 1)){
    if((strcmp(method,"discrete") == 0) && (graph.xInd == -1)){
      gnuplot_cmd(plot_handle,"plot '%s' i 0 u %d:%d w steps t \"%s(%s)\"\n",
		  data_name,graph.xInd+2,graph.yInd[0]+2,method,
		  var_name[graph.yInd[0]]);
      i = 1;
      while(i<3){
	if(graph.yInd[i] > -1)
	  gnuplot_cmd(plot_handle,"replot '%s' i 0 u %d:%d w steps t \"%s(%s)\"",
		      data_name,graph.xInd+2,graph.yInd[i]+2,method,
		      var_name[graph.yInd[i]]);
      	i++;
      }
    }
    else if(graph.xInd != -1){
      gnuplot_cmd(plot_handle,"plot '%s' i 0 u %d:%d w l t \"%s\"\n",
		  data_name,graph.xInd+2,graph.yInd[0]+2,method);
      i = 1;
      while(i<3){
	if(graph.yInd[i] > -1)
	  gnuplot_cmd(plot_handle,"replot '%s' i 0 u %d:%d w l t \"%s\"",
		      data_name,graph.xInd+2,graph.yInd[i]+2,method);
      	i++;
      }
    }
    else{
      gnuplot_cmd(plot_handle,"plot '%s' i 0 u %d:%d w l t \"%s(%s)\"\n",
		  data_name,graph.xInd+2,graph.yInd[0]+2,method,
		  var_name[graph.yInd[0]]);
      i = 1;
      while(i<3){
	if(graph.yInd[i] > -1)
	  gnuplot_cmd(plot_handle,"replot '%s' i 0 u %d:%d w l t \"%s(%s)\"",
		      data_name,graph.xInd+2,graph.yInd[i]+2,method,
		      var_name[graph.yInd[i]]);
	i++;
      }
    }
  }
  else{/* Second run fo complex method */
    if((strcmp(method,"discrete") == 0) && (graph.xInd == -1)){
      gnuplot_cmd(plot_handle,"replot '%s' i 1 u %d:%d w steps t \"%s(%s)\"\n",
		  data_name,graph.xInd+2,graph.yInd[0]+2,method,
		  var_name[graph.yInd[0]]);
      i = 1;
      while(i<3){
	if(graph.yInd[i] > -1)
	  gnuplot_cmd(plot_handle,"replot '%s' i 1 u %d:%d w steps t \"%s(%s)\"",
		      data_name,graph.xInd+2,graph.yInd[i]+2,method,
		      var_name[graph.yInd[i]]);
      	i++;
      }
    }
    else if(graph.xInd != -1){/* Phase portrait */
      gnuplot_cmd(plot_handle,"replot '%s' i 1 u %d:%d w l t \"%s\"\n",
		  data_name,graph.xInd+2,graph.yInd[0]+2,method);
      i = 1;
      while(i<3){
	if(graph.yInd[i] > -1)
	  gnuplot_cmd(plot_handle,"replot '%s' i 1 u %d:%d w l t \"%s\"",
		      data_name,graph.xInd+2,graph.yInd[i]+2,method);
      	i++;
      }
    }
    else{
      gnuplot_cmd(plot_handle,"replot '%s' i 1 u %d:%d w l t \"%s(%s)\"\n",
		  data_name,graph.xInd+2,graph.yInd[0]+2,method,
		  var_name[graph.yInd[0]]);
      i = 1;
      while(i<3){
	if(graph.yInd[i] > -1)
	  gnuplot_cmd(plot_handle,"replot '%s' i 1 u %d:%d w l t \"%s(%s)\"",
		      data_name,graph.xInd+2,graph.yInd[i]+2,method,
		      var_name[graph.yInd[i]]);
      	i++;
      }
    }
  }
}

void graph_set_labels(const struct coordNet graph, const char *type)
{
  char *tmp = (char *)calloc(20,sizeof(char));
  int i = 0;
  if(strcmp(type,"tsphase")==0){
    gnuplot_cmd(plot_handle,"set term x11 0 enh\n");
    gnuplot_cmd(plot_handle,"reset\n");
    if(graph.xInd == -1)
      gnuplot_cmd(plot_handle,"set xlabel \"Time\"\n");
    else
      gnuplot_cmd(plot_handle,"set xlabel \"%s\"\n",var_name[graph.xInd]);
    while(i<3){
      if(graph.yInd[i] > -1){
	strcat(tmp,var_name[graph.yInd[i]]);
	strcat(tmp,",");
      }
      i++;
    }
    gnuplot_cmd(plot_handle,"set ylabel \"%s\"\n",tmp);
  }
  if(strcmp(type,"thist")==0){
    gnuplot_cmd(plot_handle,"set term x11 1 enh\n");
    gnuplot_cmd(plot_handle,"reset\n");
    gnuplot_cmd(plot_handle,"set boxwidth 0.8 relative\n");
    gnuplot_cmd(plot_handle,"set style fill solid\n");
    gnuplot_cmd(plot_handle,"set style line 1 lw 2 lc rgb \"green\"\n");
    gnuplot_cmd(plot_handle,"set xlabel \"Period\"\n");
    gnuplot_cmd(plot_handle,"set ylabel\n");
    gnuplot_cmd(plot_handle,"set title \"n=%d\"\n",nPerStoch);
  }
  if(strcmp(type,"mdist")==0){
    gnuplot_cmd(plot_handle,"set term x11 1 enh\n");
    gnuplot_cmd(plot_handle,"reset\n");
    gnuplot_cmd(plot_handle,"set boxwidth 0.8 relative\n");
    gnuplot_cmd(plot_handle,"set style fill solid\n");
    gnuplot_cmd(plot_handle,"set style line 1 lw 2 lc rgb \"green\"\n");
    gnuplot_cmd(plot_handle,"set xlabel \"# %s species\"\n",var_name[perVarInd]);
    gnuplot_cmd(plot_handle,"set ylabel\n");
  }
  free(tmp);
}

void init_graph()
{
  /* graph.xInd = -1; Initialized within read_ode.c*/
  /* graph.yInd[0-2] = 0; Initialized within read_ode.c*/
  graph.xUlim = 20;
  graph.xLlim = 0;
  graph.yUlim = 20;
  graph.yLlim = 0;
  graph.nTics = 5;
  graph.grid_flag = 0;
  plot_handle = gnuplot_init();
  gnuplot_cmd(plot_handle,"set pointsize 2\n");
}

void send_to_eps()
{
  int len = 20;
  char *fname = (char *)malloc(len*sizeof(char));
  char *p = fname;
  memset(fname,'\0',len);
  fprintf(stdout,"File name for the graphics output:\n");
  do{
    if(p == 0)
      fprintf(stdout,"File name too long (max %d).\n",len);
    fgets(fname,len-1,stdin);
  }
  while((p=strchr(fname,'\n')) == NULL);
  *p = 0;/* Terminate string at newline */
  gnuplot_cmd(plot_handle,"set term postscript eps color enh\n");
  gnuplot_cmd(plot_handle,"set output \"%s\"\n",fname);
  gnuplot_cmd(plot_handle,"replot\n");
  gnuplot_cmd(plot_handle,"set term X11\n");//Reset to X11 back
  gnuplot_cmd(plot_handle,"set pointsize 2\n");
  free(fname);
}


/******* LIBPLOT FUNCTIONS: disabled *******/
/* int init_plotter(const char *type) */
/* {/\* The function creates the plotter of type `type', activates/selects it and returns */
/*      the handle of the created plotter `handle'.  *\/ */
/*   int handle = pl_newpl(type,stdin,stdout,stderr); */
/*   if(handle < 0){/\* Error handling *\/ */
/*     fprintf(stderr,"Couldn't create Plotter\n"); */
/*     return -1; */
/*   } */
/*   pl_selectpl(handle); */
/*   return handle; */
/* } */

/* void close_plotter(const int handle) */
/* {/\* The function deletes the plotter recognized by the handle `handle'. *\/ */
/*   if(pl_deletepl(handle) < 0) */
/*     fprintf(stderr,"Couldn't delete Plotter\n"); */
/* } */

/* void plot_coord(const int handle, struct coordNet * graph) */
/* {/\* The function plots the coordinate system of the plot. openpl and closepl, as well */
/*     as fspace function(s), should be outside of this function. It takes the handle of */
/*     created and selected(!) plotter and the figure specifying graph structure. NOTE */
/*     the function uses erase(). *\/ */
/*   int i; */
/*   char *label; */
/*   /\* NOTE: this function uses ERASE()!!! *\/ */
/*   pl_erase(); */
/*   /\* Allocate user space *\/ */
/*   pl_fspace2(graph->xLlim-USER_COORD_EXTEN*(graph->xUlim-graph->xLlim), */
/* 	     graph->yLlim-USER_COORD_EXTEN*(graph->yUlim-graph->yLlim), */
/* 	     graph->xUlim+USER_COORD_EXTEN*(graph->xUlim-graph->xLlim), */
/* 	     graph->yLlim-USER_COORD_EXTEN*(graph->yUlim-graph->yLlim), */
/* 	     graph->xLlim-USER_COORD_EXTEN*(graph->xUlim-graph->xLlim), */
/* 	     graph->yUlim+USER_COORD_EXTEN*(graph->yUlim-graph->yLlim)); */
/*   /\* drawing X-axis: adding XY_AXES_EXTEN% at the end and label *\/ */
/*   pl_fline(graph->xLlim, */
/* 	   graph->yLlim, */
/* 	   graph->xUlim+XY_AXES_EXTEN*(graph->xUlim-graph->xLlim), */
/* 	   graph->yLlim); */
/*   pl_fmoverel(0,-0.2*USER_COORD_EXTEN*(graph->yUlim-graph->yLlim)); */
/*   if((label = get_label(label,graph->xInd)) != NULL) */
/*     pl_alabel('c','t',label); */
/*   /\* drawing Y-axis: adding XY_AXES_EXTEN% at the end and label *\/ */
/*   pl_fline(graph->xLlim, */
/* 	   graph->yLlim, */
/* 	   graph->xLlim, */
/* 	   graph->yUlim+XY_AXES_EXTEN*(graph->yUlim-graph->yLlim)); */
/*   pl_fmoverel(-0.5*USER_COORD_EXTEN*(graph->xUlim-graph->xLlim),0); */
/*   if((label = get_label(label,graph->yInd[0])) != NULL) */
/*     pl_alabel('r','t',label); */
/*   /\* Drawing TICS *\/ */
/*   /\* X tics *\/ */
/*   /\* Re-using label *\/ */
/*   label = (char *)malloc(PLOT_NUM_MIN_CHAR*sizeof(char)); */
/*   double dx = (graph->xUlim - graph->xLlim) / graph->nTics; */
/*   for(i=0;i<graph->nTics+1;i++){ */
/*     pl_fmove(graph->xLlim+i*dx, */
/* 	     graph->yLlim); */
/*     sprintf(label,"%.1lf",graph->xLlim+i*dx); */
/*     pl_alabel('c','t',label); */
/*   } */
/*   /\* Y tics *\/ */
/*   dx = (graph->yUlim - graph->yLlim) / graph->nTics; */
/*   for(i=0;i<graph->nTics+1;i++){ */
/*     pl_fmove(graph->xLlim, */
/* 	     graph->yLlim+i*dx); */
/*     sprintf(label,"%.1lf",graph->yLlim+i*dx); */
/*     pl_alabel('r','b',label); */
/*   } */
/*   /\* Drawing grid *\/ */
/*   if(graph->grid_flag != 0){ */
    
/*   } */
/* } */

/* char *get_label(char *label,const int ind) */
/* {/\* The function gets a name for the label with index ind. This can be var names or */
/*     some other entities(Time, % of cases for histogram plots etc). *\/ */
/*   if(ind == -1){//Time var */
/*     label = (char *)malloc((strlen("Time")+1)*sizeof(char)); */
/*     strcpy(label,"Time"); */
/*     return label; */
/*   } */
/*   else if((ind > -1) && (ind < DIM)){//Variables */
/*     label = (char *)malloc((strlen(var_name[ind])+1)*sizeof(char)); */
/*     strcpy(label,var_name[ind]); */
/*     return label; */
/*   } */
/*   else{ */
/*     fprintf(stderr,"I do not know the index!\n"); */
/*     return NULL; */
/*   } */
/* } */
