/*****************************************************************************************/
/* Copyright 2008,2009,2010,2011,2012 Elias Potapov. */
/* Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007
   The GSL Team. */

/*****************************************************************************************/
/* This file is part of DINAMICA. */

/* DINAMICA is free software: you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation, either version 3 of the License, or */
/* (at your option) any later version. */

/* DINAMICA is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with DINAMICA.  If not, see <http://www.gnu.org/licenses/>. */
/****************************************************************************************/
/****************************************************************************************/
/* Original author is Elias Potapov <elias.potapov@gmail.com>
   Lomonosov Moscow State University, Biophysics Dep..
   Lebedev Physical Inst., Dep. of Theoretical Physics.
   Moscow, Russia */
/****************************************************************************************/

#include "init.h"
#include "errors.h"
#include "continue.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define TRUE 1
#define FALSE 0


int continuation()
{
  int i,j,l;

  int write_count=0;
  int n=1;

  FILE *param;
  FILE *param_point;
  param=fopen("par","w");
  param_point=fopen("par_p","w");

  P1step=P1stepin;
  P2step=P2stepin;
  P1=P1in;
  P2=P2in;
  // BIG loop over 1-st parameter.
  while((P1 <= P1max) && (P1 >= P1min))
    {
      mu.P[par1]=P1;

      // BIG loop over 2-nd parameter.
      while((P2 <= P2max) && (P2 >= P2min))
	{
	  mu.P[par2]=P2;

	  fprintf(stdout,"***********************\n");
	  //Integrating...
	  run(mynum.method,mynum.total_time,write_flag,0,1);
	  //Getting attractor by additional integrating.
	  for(i=0;i<DIM;i++){
	    j=0;
	    while(per_ratio[i] > eps_per_ratio){
	      run(mynum.method,mynum.trans_time,0,1,1);
	      j++;
	      if(j>10){
		fprintf(stdout,"!Could not get attractor!\n");
		break;
	      }
	    }
	  }
	  //Determining trajectory.
	  traj();
	  //Reporting to stdout.
	  fprintf(stdout,"%s: %G\t%s: %G\n",par_name[par1],P1,par_name[par2],P2);
	  
	  //Now initial is current, both for pars and vars.
 	  if(cont_sol==regime){
	    for(j=0;j<DIM;j++){xin[j]=x[j];}
	    //P2in=P2;
	  }
	   	  
	  //Point is not successive...
	  if(cont_sol!=regime){
	    P2=P2-P2step;
	    for(j=0;j<DIM;j++){x[j]=xin[j];}
	    fprintf(param,"%Gf %Gf\n",P1,P2);
	    write_count++;
	    if(write_count == n*write_num){ fprintf(param_point,"%lf %lf\n",P1,P2);
	      for(l=0;l<DIM;l++)
		fprintf(param_point,"%lf\n",x[l]);
	      n++;
	    }
	    break;
	  }
	  //Boundary reflection.
	  if((P2 > P2max) || (P2 < P2min)) {P2=P2-P2step; P2step=-P2step;break;}

	  P2 = P2 + P2step;
	}// END of 2-nd par.
      P1 = P1 + P1step;
    }//END of 1-st par.
  fclose(param);
  fclose(param_point);

  return 0;

}

int cont_init()
{
  par1=1;
  par2=2;
  P1in=mu.P[par1];
  P2in=mu.P[par2];
  P1stepin=0.01;
  P2stepin=0.01;
  P1max=2*P1in;P1min=0;
  P2max=2*P2in;P2min=0;

  write_num=1;

  return 0;
}
