/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "globalobject.h"


GlobalObject::GlobalObject(QObject *parent) : QObject(parent)
{
    QSettings settings;
    settings.beginGroup("Configuration");

    /////////////////////////////////////////////////////////////////// GENERAL
    this->syncGeneralSettings(settings.value("minorFeedSnippets", 0).toInt(),
                              settings.value("snippetsCharLimit", 200).toInt());


    /////////////////////////////////////////////////////////////////// FONTS
    QFont defaultTitleFont;     // 1 point larger
    defaultTitleFont.setPointSize(defaultTitleFont.pointSize() + 1);
    defaultTitleFont.setBold(true);

    QFont defaultContentFont;   // Just the default text size

    QFont defaultCommentsFont;  //  1 point smaller
    defaultCommentsFont.setPointSize(defaultCommentsFont.pointSize() - 1);

    QFont defaultMinorFeedFont; // 2 points smaller
    defaultMinorFeedFont.setPointSize(defaultMinorFeedFont.pointSize() - 2);

    this->syncFontSettings(settings.value("font1",
                                          defaultTitleFont).toString(),
                           settings.value("font2",
                                          defaultContentFont).toString(),
                           settings.value("font3",
                                          defaultCommentsFont).toString(),
                           settings.value("font4",
                                          defaultMinorFeedFont).toString());


    /////////////////////////////////////////////////////////////////// COLORS
    this->colorsList.clear();
    colorsList << settings.value("color1", "DISABLED#401020").toString()
               << settings.value("color2", "DISABLED#154060").toString()
               << settings.value("color3", "DISABLED#403510").toString()
               << settings.value("color4", "DISABLED#103510").toString()
               << settings.value("color5").toString()
               << settings.value("color6").toString();
    // no need to call this->syncColorSettings() now...

    settings.endGroup();


    qDebug() << "GlobalObject created";
}

GlobalObject::~GlobalObject()
{
    qDebug() << "GlobalObject destroyed";
}



void GlobalObject::syncGeneralSettings(int minorFeedSnippets,
                                       int snippetsChars)
{
    this->minorFeedSnippetsType = minorFeedSnippets;
    this->snippetsCharLimit = snippetsChars;

    // TODO the rest
}

int GlobalObject::getMinorFeedSnippetsType()
{
    return this->minorFeedSnippetsType;
}

int GlobalObject::getSnippetsCharLimit()
{
    return this->snippetsCharLimit;
}




void GlobalObject::syncFontSettings(QString postTitleFont,
                                    QString postContentsFont,
                                    QString commentsFont,
                                    QString minorFeedFont)
{
    this->postTitleFontInfo = postTitleFont;
    this->postContentsFontInfo = postContentsFont;
    this->commentsFontInfo = commentsFont;
    this->minorFeedFontInfo = minorFeedFont;

    qDebug() << "GlobalObject::syncFontSettings() - font info sync'd";
}

QString GlobalObject::getPostTitleFont()
{
    return this->postTitleFontInfo;
}

QString GlobalObject::getPostContentsFont()
{
    return this->postContentsFontInfo;
}

QString GlobalObject::getCommentsFont()
{
    return this->commentsFontInfo;
}

QString GlobalObject::getMinorFeedFont()
{
    return this->minorFeedFontInfo;
}



void GlobalObject::syncColorSettings(QStringList newColorList)
{
    this->colorsList = newColorList;

    qDebug() << "GlobalObject::syncColorSettings() - color list sync'd";
}

QStringList GlobalObject::getColorsList()
{
    return this->colorsList;
}




void GlobalObject::createMessageForContact(QString name, QString id)
{
    // Send signal to be caught by Publisher()
    emit messagingModeRequested(name, id);

    qDebug() << "GlobalObject; asking for Messaging mode for " << name << id;
}

void GlobalObject::editPost(QString originalPostId, QString title, QString contents)
{
    // Signal to be caught by Publisher
    emit postEditRequested(originalPostId,
                           title,
                           contents);

    qDebug() << "GlobalObject; asking to edit post: " << originalPostId << title;
}
